/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.common;

import io.quarkiverse.operatorsdk.common.AnnotationConfigurableAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.Constants;
import io.quarkiverse.operatorsdk.common.CustomResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.DependentResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconcilerAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.SelectiveAugmentedClassInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class ClassUtils {
    private ClassUtils() {
    }

    public static boolean isStatusNotVoid(String statusClassName) {
        return !Void.class.getName().equals(statusClassName);
    }

    public static Stream<ReconcilerAugmentedClassInfo> getKnownReconcilers(IndexView index, Logger log) {
        return ClassUtils.getProcessableImplementationsOf(Constants.RECONCILER, index, log, Collections.emptyMap()).map(ReconcilerAugmentedClassInfo.class::cast);
    }

    public static Stream<? extends SelectiveAugmentedClassInfo> getProcessableImplementationsOf(DotName interfaceType, IndexView index, Logger log, Map<String, Object> context) {
        return ClassUtils.getProcessableImplementationsOrExtensionsOf(interfaceType, index, log, context, true);
    }

    public static Stream<? extends SelectiveAugmentedClassInfo> getProcessableSubClassesOf(DotName classType, IndexView index, Logger log, Map<String, Object> context) {
        return ClassUtils.getProcessableImplementationsOrExtensionsOf(classType, index, log, context, false);
    }

    private static Stream<? extends SelectiveAugmentedClassInfo> getProcessableImplementationsOrExtensionsOf(DotName implementedOrExtendedClass, IndexView index, Logger log, Map<String, Object> context, boolean isInterface) {
        Collection extensions = isInterface ? index.getAllKnownImplementors(implementedOrExtendedClass) : index.getAllKnownSubclasses(implementedOrExtendedClass);
        return extensions.stream().map(classInfo -> ClassUtils.createAugmentedClassInfoFor(implementedOrExtendedClass, classInfo)).filter(fci -> fci.keep(index, log, context)).peek(fci -> fci.augmentIfKept(index, log, context));
    }

    static SelectiveAugmentedClassInfo createAugmentedClassInfoFor(DotName implementedOrExtendedClass, ClassInfo classInfo) {
        if (Constants.RECONCILER.equals((Object)implementedOrExtendedClass)) {
            return new ReconcilerAugmentedClassInfo(classInfo);
        }
        if (Constants.DEPENDENT_RESOURCE.equals((Object)implementedOrExtendedClass)) {
            return new DependentResourceAugmentedClassInfo(classInfo);
        }
        if (Constants.ANNOTATION_CONFIGURABLE.equals((Object)implementedOrExtendedClass)) {
            return new AnnotationConfigurableAugmentedClassInfo(classInfo);
        }
        if (Constants.CUSTOM_RESOURCE.equals((Object)implementedOrExtendedClass)) {
            return new CustomResourceAugmentedClassInfo(classInfo, null);
        }
        throw new IllegalArgumentException("Don't know how to process " + String.valueOf(implementedOrExtendedClass));
    }

    public static boolean isImplementationOf(IndexView index, ClassInfo info, DotName targetInterface) {
        if (info.interfaceNames().contains(targetInterface)) {
            return true;
        }
        Type superType = info.superClassType();
        DotName superTypeName = superType.name();
        if (Constants.OBJECT.equals((Object)superTypeName)) {
            return false;
        }
        ClassInfo superClass = index.getClassByName(superTypeName);
        if (superClass == null) {
            throw new IllegalStateException("The class " + String.valueOf(superTypeName) + " is not inside the Jandex index");
        }
        return ClassUtils.isImplementationOf(index, superClass, targetInterface);
    }

    public static boolean hasField(IndexView index, ClassInfo info, String fieldName) {
        ClassInfo tmpClassInfo = info;
        while (tmpClassInfo != null) {
            FieldInfo status = tmpClassInfo.field(fieldName);
            if (status != null) {
                return true;
            }
            if (tmpClassInfo.superName() != null) {
                tmpClassInfo = index.getClassByName(tmpClassInfo.superName());
                continue;
            }
            tmpClassInfo = null;
        }
        return false;
    }
}

