/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.common;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.quarkiverse.operatorsdk.common.ClassLoadingUtils;
import io.quarkiverse.operatorsdk.common.ClassUtils;
import io.quarkiverse.operatorsdk.common.Constants;
import io.quarkiverse.operatorsdk.common.CustomResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconciledResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ResourceAssociatedAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.SelectiveAugmentedClassInfo;
import io.quarkus.builder.BuildException;
import io.quarkus.deployment.util.JandexUtil;
import java.util.Map;
import java.util.Optional;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

public class ReconciledAugmentedClassInfo<T>
extends SelectiveAugmentedClassInfo {
    private Class<T> clazz;
    private final String resourceClassName;
    private final String reconcilerName;

    protected ReconciledAugmentedClassInfo(ClassInfo classInfo, DotName extendedOrImplementedClass, int expectedParameterTypesCardinality, String associatedReconcilerName) {
        super(classInfo, extendedOrImplementedClass, expectedParameterTypesCardinality);
        this.resourceClassName = classInfo.name().toString();
        this.reconcilerName = associatedReconcilerName;
    }

    @Override
    protected void doAugment(IndexView index, Logger log, Map<String, Object> context) {
        this.registerForReflection(this.classInfo().name().toString());
    }

    public Class<T> loadAssociatedClass() {
        if (this.clazz == null) {
            this.clazz = ClassLoadingUtils.loadClass((String)this.resourceClassName, HasMetadata.class);
        }
        return this.clazz;
    }

    public boolean isCR() {
        return false;
    }

    public boolean isResource() {
        return false;
    }

    public Optional<String> getAssociatedReconcilerName() {
        return Optional.ofNullable(this.reconcilerName);
    }

    public ReconciledResourceAugmentedClassInfo asResourceTargeting() {
        if (this instanceof ReconciledResourceAugmentedClassInfo) {
            return (ReconciledResourceAugmentedClassInfo)this;
        }
        throw new IllegalStateException("Cannot convert " + String.valueOf(this.classInfo().name()) + " to ReconciledResourceAugmentedClassInfo");
    }

    public static ReconciledAugmentedClassInfo createFor(ResourceAssociatedAugmentedClassInfo parent, ClassInfo resourceCI, String reconcilerName, IndexView index, Logger log, Map<String, Object> context) {
        boolean isResource = false;
        boolean isCR = false;
        boolean isGenericKubernetesResource = false;
        try {
            isResource = ClassUtils.isImplementationOf(index, resourceCI, Constants.HAS_METADATA);
            if (isResource && !(isCR = JandexUtil.isSubclassOf((IndexView)index, (ClassInfo)resourceCI, (DotName)Constants.CUSTOM_RESOURCE))) {
                isGenericKubernetesResource = JandexUtil.isSubclassOf((IndexView)index, (ClassInfo)parent.classInfo(), (DotName)Constants.GENERIC_KUBERNETES_DEPENDENT_RESOURCE);
            }
        }
        catch (BuildException e) {
            log.errorv("Couldn't ascertain if ''{0}'' is a CustomResource or HasMetadata subclass. Assumed not to be.", (Object)e);
        }
        ReconciledAugmentedClassInfo reconciledInfo = isCR ? new CustomResourceAugmentedClassInfo(resourceCI, reconcilerName) : (isResource && !isGenericKubernetesResource ? new ReconciledResourceAugmentedClassInfo(resourceCI, Constants.HAS_METADATA, 0, reconcilerName) : new ReconciledAugmentedClassInfo(resourceCI, Constants.OBJECT, 0, reconcilerName));
        reconciledInfo.augmentIfKept(index, log, context);
        return reconciledInfo;
    }
}

