/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.common;

import io.quarkiverse.operatorsdk.common.ReconciledAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.SelectiveAugmentedClassInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

public class ResourceAssociatedAugmentedClassInfo
extends SelectiveAugmentedClassInfo {
    private final String name;
    private ReconciledAugmentedClassInfo<?> resourceInfo;
    private final String reconcilerName;

    protected ResourceAssociatedAugmentedClassInfo(ClassInfo classInfo, DotName extendedOrImplementedClass, int expectedParameterTypesCardinality, String name) {
        this(classInfo, extendedOrImplementedClass, expectedParameterTypesCardinality, name, null);
    }

    protected ResourceAssociatedAugmentedClassInfo(ClassInfo classInfo, DotName extendedOrImplementedClass, int expectedParameterTypesCardinality, String name, String reconcilerName) {
        super(classInfo, extendedOrImplementedClass, expectedParameterTypesCardinality);
        this.name = name;
        this.reconcilerName = reconcilerName != null ? reconcilerName : name;
    }

    public DotName resourceTypeName() {
        return this.typeAt(0).name();
    }

    public String nameOrFailIfUnset() {
        return this.name().orElseThrow();
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    @Override
    protected void doAugment(IndexView index, Logger log, Map<String, Object> context) {
        DotName primaryTypeDN = this.resourceTypeName();
        ClassInfo primaryCI = index.getClassByName(primaryTypeDN);
        if (primaryCI == null) {
            throw new IllegalStateException("'" + String.valueOf(primaryTypeDN) + "' has not been found in the Jandex index so it cannot be introspected. Please index your classes with Jandex.");
        }
        this.resourceInfo = ReconciledAugmentedClassInfo.createFor(this, primaryCI, this.reconcilerName, index, log, context);
    }

    public ReconciledAugmentedClassInfo<?> associatedResourceInfo() {
        return this.resourceInfo;
    }

    @Override
    public List<String> getClassNamesToRegisterForReflection() {
        List<String> own = super.getClassNamesToRegisterForReflection();
        List<String> associated = this.resourceInfo.getClassNamesToRegisterForReflection();
        ArrayList<String> result = new ArrayList<String>(own.size() + associated.size());
        result.addAll(own);
        result.addAll(associated);
        return result;
    }
}

