/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.common;

import io.javaoperatorsdk.operator.ControllerUtils;
import io.javaoperatorsdk.operator.api.config.Utils;
import io.quarkiverse.operatorsdk.common.Constants;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.logging.Logger;

public class ConfigurationUtils {
    public static <C, T> T extract(C externalConfig, AnnotationInstance annotation, Function<C, Optional<T>> extractor, String annotationField, Function<AnnotationValue, T> converter, Supplier<T> defaultValue) {
        if (externalConfig != null) {
            return extractor.apply(externalConfig).orElse(ConfigurationUtils.annotationValueOrDefault(annotation, annotationField, converter, defaultValue));
        }
        return ConfigurationUtils.annotationValueOrDefault(annotation, annotationField, converter, defaultValue);
    }

    public static <T> T annotationValueOrDefault(AnnotationInstance annotation, String annotationFieldName, Function<AnnotationValue, T> converter, Supplier<T> defaultValue) {
        return annotation != null ? Optional.ofNullable(annotation.value(annotationFieldName)).map(converter).orElseGet(defaultValue) : defaultValue.get();
    }

    public static boolean shouldValidateCustomResources(Optional<Boolean> oldValidateCRD, boolean newValidateCRD, Logger log) {
        if (Utils.isValidateCustomResourcesEnvVarSet()) {
            return Utils.shouldCheckCRDAndValidateLocalModel();
        }
        if (log != null && oldValidateCRD.isPresent()) {
            Boolean validateCustomResources = oldValidateCRD.get();
            String msg = validateCustomResources != newValidateCRD ? String.format("Deprecated property check-crd-and-validate-local-model with value '%s' is overridden by crd.validate property value '%s'", validateCustomResources, newValidateCRD) : "Use of deprecated check-crd-and-validate-local-model property. Use crd.validate instead.";
            log.warn((Object)msg);
        }
        return newValidateCRD;
    }

    public static String getControllerName(ClassInfo info) {
        String controllerClassName = info.name().toString();
        AnnotationInstance controllerAnnotation = info.classAnnotation(Constants.CONTROLLER);
        return ConfigurationUtils.getControllerName(controllerClassName, controllerAnnotation);
    }

    public static String getControllerName(String resourceControllerClassName, AnnotationInstance controllerAnnotation) {
        String defaultControllerName = ControllerUtils.getDefaultResourceControllerName((String)resourceControllerClassName);
        return ConfigurationUtils.annotationValueOrDefault(controllerAnnotation, "name", AnnotationValue::asString, () -> defaultControllerName);
    }
}

