/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.common;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Converters;
import io.smallrye.config.ExpressionConfigSourceInterceptor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.Converter;

public class RuntimeConfigurationUtils {
    private static final ExpressionConfigSourceInterceptor RESOLVER = new ExpressionConfigSourceInterceptor();
    private static final Converter<HashSet<String>> converter = Converters.newCollectionConverter((Converter)Converters.getImplicitConverter(String.class), HashSet::new);
    private static final Config config = ConfigProvider.getConfig();

    public static Set<String> stringPropValueAsSet(String propValue) {
        return ((HashSet)converter.convert(propValue)).stream().map(String::trim).collect(Collectors.toSet());
    }

    public static String expandedValueFrom(String unexpandedValue) {
        ConfigSourceInterceptorContext context = new ConfigSourceInterceptorContext(){
            private boolean firstLookup = true;

            public ConfigValue proceed(String name) {
                if (this.firstLookup) {
                    this.firstLookup = false;
                    return ConfigValue.builder().withName(name).withValue(name).build();
                }
                ConfigValue configValue = (ConfigValue)config.getConfigValue(name);
                return configValue.getValue() == null ? null : configValue;
            }

            public Iterator<String> iterateNames() {
                throw new UnsupportedOperationException();
            }

            public Iterator<ConfigValue> iterateValues() {
                throw new UnsupportedOperationException();
            }
        };
        ConfigValue value = RESOLVER.getValue(context, unexpandedValue);
        return value.getValue() == null ? unexpandedValue : value.getValue();
    }
}

