/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.common;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.Converters;
import io.smallrye.config.ExpressionConfigSourceInterceptor;
import io.smallrye.config.Expressions;
import io.smallrye.config.common.utils.StringUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.spi.Converter;

public class RuntimeConfigurationUtils {
    private static final ExpressionConfigSourceInterceptor RESOLVER = new ExpressionConfigSourceInterceptor();
    private static final Converter<HashSet<String>> converter = Converters.newCollectionConverter((Converter)Converters.getImplicitConverter(String.class), HashSet::new);
    private static final Config config = ConfigProvider.getConfig();
    private static final String QUARKUS_OPERATOR_SDK_CONTROLLERS = "quarkus.operator-sdk.controllers.";
    private static final String NAMESPACES = ".namespaces";

    public static Set<String> namespacesFromConfigurationFor(String controllerName) {
        String propName = RuntimeConfigurationUtils.namespacePropertyKey(controllerName);
        String envOrSysVarName = StringUtil.replaceNonAlphanumericByUnderscores((String)propName.toUpperCase());
        String namespaces = System.getProperty(envOrSysVarName);
        if (namespaces != null && !namespaces.isBlank()) {
            return RuntimeConfigurationUtils.toSet(namespaces);
        }
        namespaces = System.getenv(envOrSysVarName);
        if (namespaces != null && !namespaces.isBlank()) {
            return RuntimeConfigurationUtils.toSet(namespaces);
        }
        ConfigValue configValue = config.getConfigValue(propName);
        namespaces = (String)Expressions.withoutExpansion(() -> ((ConfigValue)configValue).getRawValue());
        if (namespaces != null && !namespaces.isBlank()) {
            return RuntimeConfigurationUtils.toSet(namespaces);
        }
        return null;
    }

    private static Set<String> toSet(String namespaces) {
        return ((HashSet)converter.convert(namespaces)).stream().map(String::trim).collect(Collectors.toSet());
    }

    public static String expandedValueFrom2(String unexpanded) {
        if (unexpanded.startsWith("${")) {
            String substring = unexpanded.substring(2, unexpanded.length() - 1);
            String expanded = System.getProperty(substring);
            if (expanded != null) {
                return expanded;
            }
            return System.getenv(substring);
        }
        return unexpanded;
    }

    public static String expandedValueFrom(String unexpandedValue) {
        ConfigSourceInterceptorContext context = new ConfigSourceInterceptorContext(){
            private boolean firstLookup = true;

            public io.smallrye.config.ConfigValue proceed(String name) {
                if (this.firstLookup) {
                    this.firstLookup = false;
                    return io.smallrye.config.ConfigValue.builder().withName(name).withValue(name).build();
                }
                io.smallrye.config.ConfigValue configValue = (io.smallrye.config.ConfigValue)config.getConfigValue(name);
                return configValue.getValue() == null ? null : configValue;
            }

            public Iterator<String> iterateNames() {
                throw new UnsupportedOperationException();
            }

            public Iterator<io.smallrye.config.ConfigValue> iterateValues() {
                throw new UnsupportedOperationException();
            }
        };
        io.smallrye.config.ConfigValue value = RESOLVER.getValue(context, unexpandedValue);
        return value.getValue() == null ? unexpandedValue : value.getValue();
    }

    public static String namespacePropertyKey(String controllerName) {
        return QUARKUS_OPERATOR_SDK_CONTROLLERS + controllerName + NAMESPACES;
    }
}

