/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluent;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingBuilder;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent;
import io.quarkiverse.operatorsdk.deployment.AddClusterRolesDecorator;
import io.quarkiverse.operatorsdk.deployment.OperatorSDKProcessor;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AddRoleBindingsDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final Map<String, QuarkusControllerConfiguration> configs;
    private final boolean validateCRDs;
    private static final ConcurrentMap<String, Object> alreadyLogged = new ConcurrentHashMap<String, Object>();

    public AddRoleBindingsDecorator(Map<String, QuarkusControllerConfiguration> configs, boolean validateCRDs) {
        this.configs = configs;
        this.validateCRDs = validateCRDs;
    }

    public void visit(KubernetesListBuilder list) {
        String serviceAccountName = this.getMandatoryDeploymentMetadata(list).getName();
        for (Map.Entry<String, QuarkusControllerConfiguration> entry : this.configs.entrySet()) {
            String controllerName = entry.getKey();
            QuarkusControllerConfiguration config = entry.getValue();
            if (config.watchCurrentNamespace()) {
                list.addToItems(new HasMetadata[]{((RoleBindingBuilder)((RoleBindingBuilder)((RoleBindingBuilder)((RoleBindingFluent.MetadataNested)new RoleBindingBuilder().withNewMetadata().withName(controllerName + "-role-binding")).endMetadata()).withNewRoleRef("rbac.authorization.k8s.io", "ClusterRole", AddClusterRolesDecorator.getClusterRoleName(controllerName))).addNewSubject(null, "ServiceAccount", serviceAccountName, null)).build()});
            } else if (config.watchAllNamespaces()) {
                String crBindingName = controllerName + "-cluster-role-binding";
                if (alreadyLogged.putIfAbsent(controllerName, new Object()) != null) {
                    OperatorSDKProcessor.log.warnv("''{0}'' controller is configured to watch all namespaces, this requires a ClusterRoleBinding for which we MUST specify the namespace of the operator ServiceAccount. However, at this information is not known at build time, we are leaving it blank and needs to be provided by the user by editing the ''{1}'' ClusterRoleBinding to provide the namespace in which the operator will be deployed.", (Object)controllerName, (Object)crBindingName);
                }
                list.addToItems(new HasMetadata[]{((ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.MetadataNested)new ClusterRoleBindingBuilder().withNewMetadata().withName(crBindingName)).endMetadata()).withNewRoleRef("rbac.authorization.k8s.io", "ClusterRole", AddClusterRolesDecorator.getClusterRoleName(controllerName))).addNewSubject(null, "ServiceAccount", serviceAccountName, null)).build()});
            } else {
                config.getEffectiveNamespaces().forEach(ns -> list.addToItems(new HasMetadata[]{((RoleBindingBuilder)((RoleBindingBuilder)((RoleBindingBuilder)((RoleBindingFluent.MetadataNested)((RoleBindingFluent.MetadataNested)new RoleBindingBuilder().withNewMetadata().withName(controllerName + "-role-binding")).withNamespace((String)ns)).endMetadata()).withNewRoleRef("rbac.authorization.k8s.io", "ClusterRole", AddClusterRolesDecorator.getClusterRoleName(controllerName))).addNewSubject(null, "ServiceAccount", serviceAccountName, null)).build()}));
            }
            if (!this.validateCRDs) continue;
            list.addToItems(new HasMetadata[]{((RoleBindingBuilder)((RoleBindingBuilder)((RoleBindingBuilder)((RoleBindingFluent.MetadataNested)new RoleBindingBuilder().withNewMetadata().withName(controllerName + "-crd-validating-role-binding")).endMetadata()).withNewRoleRef("rbac.authorization.k8s.io", "ClusterRole", "josdk-crd-validating-cluster-role")).addNewSubject(null, "ServiceAccount", serviceAccountName, null)).build()});
        }
    }
}

