/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.javaoperatorsdk.operator.ControllerUtils;
import io.quarkiverse.operatorsdk.common.ConfigurationUtils;
import io.quarkiverse.operatorsdk.runtime.BuildTimeControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

class BuildTimeHybridControllerConfiguration {
    private final BuildTimeOperatorConfiguration operatorConfiguration;
    private final BuildTimeControllerConfiguration externalConfiguration;
    private final AnnotationInstance controllerAnnotation;
    private final AnnotationInstance delayRegistrationAnnotation;

    public BuildTimeHybridControllerConfiguration(BuildTimeOperatorConfiguration operatorConfiguration, BuildTimeControllerConfiguration externalConfiguration, AnnotationInstance controllerAnnotation, AnnotationInstance delayRegistrationAnnotation) {
        this.operatorConfiguration = operatorConfiguration;
        this.externalConfiguration = externalConfiguration;
        this.controllerAnnotation = controllerAnnotation;
        this.delayRegistrationAnnotation = delayRegistrationAnnotation;
    }

    boolean generationAware() {
        return (Boolean)ConfigurationUtils.extract((Object)this.externalConfiguration, (AnnotationInstance)this.controllerAnnotation, c -> c.generationAware, (String)"generationAwareEventProcessing", AnnotationValue::asBoolean, () -> this.operatorConfiguration.generationAware.orElse(true));
    }

    Type eventType() {
        return (Type)ConfigurationUtils.extract((Object)this.externalConfiguration, (AnnotationInstance)this.delayRegistrationAnnotation, c -> this.fromName(c.delayRegistrationUntilEvent), (String)"event", AnnotationValue::asClass, () -> this.fromName(this.operatorConfiguration.delayRegistrationUntilEvent).orElse(null));
    }

    private Optional<Type> fromName(Optional<String> className) {
        return className.filter(s -> Void.TYPE.getName().equals(s)).map(DotName::createSimple).map(dn -> Type.create((DotName)dn, (Type.Kind)Type.Kind.CLASS));
    }

    boolean delayedRegistration() {
        return (Boolean)ConfigurationUtils.extract((Object)this.externalConfiguration, (AnnotationInstance)this.delayRegistrationAnnotation, c -> this.hasNonVoidRegistrationEvent(c.delayRegistrationUntilEvent), (String)"event", v -> v.asClass().kind() != Type.Kind.VOID, () -> this.hasNonVoidRegistrationEvent(this.operatorConfiguration.delayRegistrationUntilEvent).orElse(false));
    }

    private Optional<Boolean> hasNonVoidRegistrationEvent(Optional<String> className) {
        return className.map(s -> Void.TYPE.getName().equals(s));
    }

    String name(String resourceControllerClassName) {
        String defaultControllerName = ControllerUtils.getDefaultResourceControllerName((String)resourceControllerClassName);
        return (String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)this.controllerAnnotation, (String)"name", AnnotationValue::asString, () -> defaultControllerName);
    }
}

