/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.fabric8.crd.generator.CRDGenerationInfo;
import io.fabric8.crd.generator.CRDGenerator;
import io.fabric8.crd.generator.CustomResourceInfo;
import io.fabric8.kubernetes.client.CustomResource;
import io.quarkiverse.operatorsdk.deployment.CustomResourceControllerMapping;
import io.quarkiverse.operatorsdk.deployment.OperatorSDKProcessor;
import io.quarkiverse.operatorsdk.runtime.CRDConfiguration;
import io.quarkiverse.operatorsdk.runtime.CRDInfo;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

class CRDGeneration {
    private final CRDGenerator generator = new CRDGenerator();
    private final boolean generate;
    private boolean needGeneration;
    private final CustomResourceControllerMapping crMappings = new CustomResourceControllerMapping();

    public CRDGeneration(boolean generate) {
        this.generate = generate;
    }

    public boolean wantCRDGenerated() {
        return this.generate;
    }

    io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo generate(OutputTargetBuildItem outputTarget, CRDConfiguration crdConfig, boolean validateCustomResources, Map<String, Map<String, CRDInfo>> existing) {
        HashMap<String, Map<String, CRDInfo>> converted = new HashMap<String, Map<String, CRDInfo>>(existing);
        HashSet generated = new HashSet();
        if (this.needGeneration) {
            String outputDirName = crdConfig.outputDirectory;
            File outputDir = outputTarget.getOutputDirectory().resolve(outputDirName).toFile();
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            CRDGenerationInfo info = this.generator.forCRDVersions(crdConfig.versions).inOutputDir(outputDir).detailedGenerate();
            Map crdDetailsPerNameAndVersion = info.getCRDDetailsPerNameAndVersion();
            crdDetailsPerNameAndVersion.forEach((crdName, initialVersionToCRDInfoMap) -> {
                OperatorSDKProcessor.log.infov("Generated {0} CRD:", crdName);
                generated.add(crdName);
                Map<String, io.quarkiverse.operatorsdk.common.CustomResourceInfo> versions = this.crMappings.getCustomResourceInfos((String)crdName);
                Map versionToCRDInfo = converted.computeIfAbsent((String)crdName, s -> new HashMap());
                initialVersionToCRDInfoMap.forEach((version, crdInfo) -> {
                    String filePath = crdInfo.getFilePath();
                    OperatorSDKProcessor.log.infov("  - {0} -> {1}", version, (Object)filePath);
                    versionToCRDInfo.put(version, new CRDInfo(crdInfo.getCrdName(), version, filePath, crdInfo.getDependentClassNames(), versions));
                });
            });
        }
        return new io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo(crdConfig.apply.booleanValue(), validateCustomResources, converted, generated);
    }

    public void withCustomResource(Class<CustomResource> crClass, String crdName, String associatedControllerName) {
        try {
            CustomResourceInfo info = CustomResourceInfo.fromClass(crClass);
            this.crMappings.add(info, crdName, associatedControllerName);
            this.generator.customResources(new CustomResourceInfo[]{info});
            this.needGeneration = true;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot process " + crClass.getName() + " custom resource for controller '" + associatedControllerName + "'", e);
        }
    }
}

