/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.fabric8.crd.generator.CustomResourceInfo;
import java.util.HashMap;
import java.util.Map;

public class CustomResourceControllerMapping {
    private final Map<String, Map<String, io.quarkiverse.operatorsdk.common.CustomResourceInfo>> crdNameToCRVersionToCRInfos = new HashMap<String, Map<String, io.quarkiverse.operatorsdk.common.CustomResourceInfo>>(7);

    public Map<String, io.quarkiverse.operatorsdk.common.CustomResourceInfo> getCustomResourceInfos(String crdName) {
        Map<String, io.quarkiverse.operatorsdk.common.CustomResourceInfo> customResourceInfos = this.crdNameToCRVersionToCRInfos.get(crdName);
        if (customResourceInfos == null) {
            throw new IllegalStateException("Should have information associated with '" + crdName + "'");
        }
        return customResourceInfos;
    }

    public void add(CustomResourceInfo info, String crdName, String associatedControllerName) {
        String version = info.version();
        Map versionsForCR = this.crdNameToCRVersionToCRInfos.computeIfAbsent(crdName, s -> new HashMap());
        io.quarkiverse.operatorsdk.common.CustomResourceInfo cri = (io.quarkiverse.operatorsdk.common.CustomResourceInfo)versionsForCR.get(version);
        if (cri != null) {
            throw new IllegalStateException("Cannot process controller '" + associatedControllerName + "' because a controller (" + cri.getControllerName() + ") is already associated with CRD " + crdName + " with version " + version);
        }
        io.quarkiverse.operatorsdk.common.CustomResourceInfo converted = new io.quarkiverse.operatorsdk.common.CustomResourceInfo(info.group(), version, info.kind(), info.singular(), info.plural(), info.shortNames(), info.storage(), info.served(), info.scope(), info.crClassName(), info.specClassName(), info.statusClassName(), crdName, associatedControllerName);
        versionsForCR.put(version, converted);
    }
}

