/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.CustomResource;
import io.javaoperatorsdk.operator.ControllerUtils;
import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.api.ResourceController;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.quarkiverse.operatorsdk.common.ClassUtils;
import io.quarkiverse.operatorsdk.common.ConfigurationUtils;
import io.quarkiverse.operatorsdk.common.Constants;
import io.quarkiverse.operatorsdk.deployment.AddClusterRolesDecorator;
import io.quarkiverse.operatorsdk.deployment.AddRoleBindingsDecorator;
import io.quarkiverse.operatorsdk.deployment.BuildTimeHybridControllerConfiguration;
import io.quarkiverse.operatorsdk.deployment.CRDGeneration;
import io.quarkiverse.operatorsdk.deployment.ConfigurationServiceBuildItem;
import io.quarkiverse.operatorsdk.deployment.ContextStoredCRDInfos;
import io.quarkiverse.operatorsdk.deployment.ContextStoredControllerConfigurations;
import io.quarkiverse.operatorsdk.deployment.GeneratedCRDInfoBuildItem;
import io.quarkiverse.operatorsdk.runtime.AppEventListener;
import io.quarkiverse.operatorsdk.runtime.BuildTimeControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.CRDConfiguration;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import io.quarkiverse.operatorsdk.runtime.CRDInfo;
import io.quarkiverse.operatorsdk.runtime.ConfigurationServiceRecorder;
import io.quarkiverse.operatorsdk.runtime.DelayRegistrationUntil;
import io.quarkiverse.operatorsdk.runtime.NoOpMetricsProvider;
import io.quarkiverse.operatorsdk.runtime.OperatorProducer;
import io.quarkiverse.operatorsdk.runtime.QuarkusConfigurationService;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.RunTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.Version;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.ObserverRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.ObserverConfigurator;
import io.quarkus.bootstrap.app.ClassChangeInformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ForceNonWeakReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.runtime.QuarkusApplication;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class OperatorSDKProcessor {
    static final Logger log = Logger.getLogger((String)OperatorSDKProcessor.class.getName());
    private static final String FEATURE = "operator-sdk";
    private static final DotName DELAY_REGISTRATION = DotName.createSimple((String)DelayRegistrationUntil.class.getName());
    public static final String CUSTOM_RESOURCE_DOTNAME_AS_STRING = Constants.CUSTOM_RESOURCE.toString();
    private BuildTimeOperatorConfiguration buildTimeConfiguration;

    OperatorSDKProcessor() {
    }

    @BuildStep
    void setup(BuildProducer<IndexDependencyBuildItem> indexDependency, BuildProducer<FeatureBuildItem> features, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, Optional<MetricsCapabilityBuildItem> metricsCapability, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        features.produce((BuildItem)new FeatureBuildItem(FEATURE));
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("io.javaoperatorsdk", "operator-framework-core"));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{ObjectMapper.class}));
        if (metricsCapability.isPresent() && metricsCapability.get().metricsSupported("micrometer")) {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)"io.quarkiverse.operatorsdk.runtime.MicrometerMetricsProvider"));
        } else {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(NoOpMetricsProvider.class));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void updateControllerConfigurations(ConfigurationServiceRecorder recorder, RunTimeOperatorConfiguration runTimeConfiguration, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, GeneratedCRDInfoBuildItem generatedCRDs, ConfigurationServiceBuildItem serviceBuildItem) {
        Supplier supplier = recorder.configurationServiceSupplier(serviceBuildItem.getVersion(), serviceBuildItem.getControllerConfigs(), generatedCRDs.getCRDGenerationInfo(), runTimeConfiguration);
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(QuarkusConfigurationService.class).scope(Singleton.class)).addType(ConfigurationService.class)).setRuntimeInit().supplier(supplier).done());
    }

    @BuildStep
    ConfigurationServiceBuildItem createConfigurationServiceAndOperator(OutputTargetBuildItem outputTarget, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectionClasses, BuildProducer<ForceNonWeakReflectiveClassBuildItem> forcedReflectionClasses, BuildProducer<GeneratedCRDInfoBuildItem> generatedCRDInfo, LiveReloadBuildItem liveReload) {
        CRDConfiguration crdConfig = this.buildTimeConfiguration.crd;
        boolean validateCustomResources = ConfigurationUtils.shouldValidateCustomResources((Optional)this.buildTimeConfiguration.checkCRDAndValidateLocalModel, (boolean)this.buildTimeConfiguration.crd.validate, (Logger)log);
        CRDGeneration crdGeneration = new CRDGeneration(crdConfig.generate != false || crdConfig.apply != false);
        IndexView index = combinedIndexBuildItem.getIndex();
        List<QuarkusControllerConfiguration> controllerConfigs = ClassUtils.getKnownResourceControllers((IndexView)index, (Logger)log).map(ci -> this.createControllerConfiguration((ClassInfo)ci, additionalBeans, reflectionClasses, forcedReflectionClasses, index, crdGeneration, liveReload)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        ContextStoredCRDInfos storedCRDInfos = (ContextStoredCRDInfos)liveReload.getContextObject(ContextStoredCRDInfos.class);
        if (storedCRDInfos == null) {
            storedCRDInfos = new ContextStoredCRDInfos();
        }
        CRDGenerationInfo crdInfo = crdGeneration.generate(outputTarget, crdConfig, validateCustomResources, storedCRDInfos.getExisting());
        storedCRDInfos.putAll(crdInfo.getCrds());
        liveReload.setContextObject(ContextStoredCRDInfos.class, (Object)storedCRDInfos);
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(OperatorProducer.class));
        if (index.getAllKnownImplementors(DotName.createSimple((String)QuarkusApplication.class.getName())).isEmpty()) {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(AppEventListener.class).setDefaultScope(DotName.createSimple((String)Singleton.class.getName())).setUnremovable().build());
        }
        generatedCRDInfo.produce((BuildItem)new GeneratedCRDInfoBuildItem(crdInfo));
        return new ConfigurationServiceBuildItem(Version.loadFromProperties(), controllerConfigs);
    }

    @BuildStep
    public void addRBACForCustomResources(BuildProducer<DecoratorBuildItem> decorators, GeneratedCRDInfoBuildItem generatedCRDs, ConfigurationServiceBuildItem configurations) {
        Map mappings = generatedCRDs.getCRDGenerationInfo().getControllerToCustomResourceMappings();
        List<QuarkusControllerConfiguration> controllerConfigs = configurations.getControllerConfigs();
        HashMap<String, QuarkusControllerConfiguration> configs = new HashMap<String, QuarkusControllerConfiguration>(controllerConfigs.size());
        controllerConfigs.forEach(c -> configs.put(c.getName(), (QuarkusControllerConfiguration)c));
        decorators.produce((BuildItem)new DecoratorBuildItem((Object)new AddClusterRolesDecorator(mappings, this.buildTimeConfiguration.crd.validate)));
        decorators.produce((BuildItem)new DecoratorBuildItem((Object)new AddRoleBindingsDecorator(configs, this.buildTimeConfiguration.crd.validate)));
    }

    private ResultHandle getHandleFromCDI(MethodCreator mc, MethodDescriptor selectMethod, MethodDescriptor getMethod, AssignableResultHandle cdiVar, Class<?> handleClass, String optionalImplClass) {
        ResultHandle operatorInstance = mc.invokeVirtualMethod(selectMethod, (ResultHandle)cdiVar, new ResultHandle[]{optionalImplClass != null ? mc.loadClass(optionalImplClass) : mc.loadClass(handleClass), mc.newArray(Annotation.class, 0)});
        ResultHandle operator = mc.checkCast(mc.invokeInterfaceMethod(getMethod, operatorInstance, new ResultHandle[0]), handleClass);
        return operator;
    }

    private Optional<QuarkusControllerConfiguration> createControllerConfiguration(ClassInfo info, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectionClasses, BuildProducer<ForceNonWeakReflectiveClassBuildItem> forcedReflectionClasses, IndexView index, CRDGeneration crdGeneration, LiveReloadBuildItem liveReload) {
        String crType = ((Type)JandexUtil.resolveTypeParameters((DotName)info.name(), (DotName)Constants.RESOURCE_CONTROLLER, (IndexView)index).get(0)).name().toString();
        String controllerClassName = info.name().toString();
        AnnotationInstance controllerAnnotation = info.classAnnotation(Constants.CONTROLLER);
        String name = ConfigurationUtils.getControllerName((String)controllerClassName, (AnnotationInstance)controllerAnnotation);
        if (crType == null || crType.equals(CUSTOM_RESOURCE_DOTNAME_AS_STRING)) {
            log.infov("Skipped processing of ''{0}'' controller as it's not parameterized with a CustomResource sub-class", (Object)controllerClassName);
            return Optional.empty();
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(controllerClassName).setUnremovable().setDefaultScope(DotNames.APPLICATION_SCOPED).build());
        this.registerForReflection(reflectionClasses, crType);
        forcedReflectionClasses.produce((BuildItem)new ForceNonWeakReflectiveClassBuildItem(crType));
        List crParamTypes = JandexUtil.resolveTypeParameters((DotName)DotName.createSimple((String)crType), (DotName)Constants.CUSTOM_RESOURCE, (IndexView)index);
        this.registerForReflection(reflectionClasses, ((Type)crParamTypes.get(0)).name().toString());
        this.registerForReflection(reflectionClasses, ((Type)crParamTypes.get(1)).name().toString());
        Class crClass = null;
        String crdName = null;
        ClassChangeInformation changeInformation = liveReload.getChangeInformation();
        if (crdGeneration.wantCRDGenerated()) {
            ContextStoredCRDInfos storedCRDInfos = (ContextStoredCRDInfos)liveReload.getContextObject(ContextStoredCRDInfos.class);
            boolean[] generateCurrent = new boolean[]{true};
            crClass = ClassUtils.loadClass((String)crType);
            crdName = CustomResource.getCRDName((Class)crClass);
            if (liveReload.isLiveReload() && storedCRDInfos != null) {
                String finalCrdName = crdName;
                Map<String, CRDInfo> crdInfos = storedCRDInfos.getCRDInfosFor(crdName);
                this.buildTimeConfiguration.crd.versions.forEach(v -> {
                    CRDInfo crd = (CRDInfo)crdInfos.get(v);
                    if (crd == null) {
                        return;
                    }
                    if (changeInformation != null) {
                        for (String changedClass : changeInformation.getChangedClasses()) {
                            if (!crd.getDependentClassNames().contains(changedClass)) continue;
                            return;
                        }
                    }
                    generateCurrent[0] = false;
                    log.infov("''{0}'' CRD generation was skipped for ''{1}'' because no changes impacting the CRD were detected", v, (Object)finalCrdName);
                });
            }
            if (generateCurrent[0]) {
                crdGeneration.withCustomResource(crClass, crdName, name);
            }
        }
        QuarkusControllerConfiguration configuration = null;
        boolean regenerateConfig = true;
        ContextStoredControllerConfigurations storedConfigurations = (ContextStoredControllerConfigurations)liveReload.getContextObject(ContextStoredControllerConfigurations.class);
        if (liveReload.isLiveReload() && storedConfigurations != null && (configuration = storedConfigurations.getConfigurations().get(controllerClassName)) != null) {
            Set changedClasses = changeInformation == null ? Collections.emptySet() : changeInformation.getChangedClasses();
            boolean bl = regenerateConfig = changedClasses.contains(controllerClassName) || changedClasses.contains(crType) || liveReload.getChangedResources().contains("application.properties");
        }
        if (regenerateConfig) {
            AnnotationInstance delayedRegistrationAnnotation = info.classAnnotation(DELAY_REGISTRATION);
            BuildTimeHybridControllerConfiguration configExtractor = new BuildTimeHybridControllerConfiguration(this.buildTimeConfiguration, (BuildTimeControllerConfiguration)this.buildTimeConfiguration.controllers.get(name), controllerAnnotation, delayedRegistrationAnnotation);
            if (crdName == null) {
                crClass = ClassUtils.loadClass((String)crType);
                crdName = CustomResource.getCRDName((Class)crClass);
            }
            String crVersion = HasMetadata.getVersion((Class)crClass);
            configuration = new QuarkusControllerConfiguration(controllerClassName, name, crdName, crVersion, configExtractor.generationAware(), crType, configExtractor.delayedRegistration(), this.getNamespaces(controllerAnnotation), this.getFinalizer(controllerAnnotation, crdName), this.getLabelSelector(controllerAnnotation));
            log.infov("Processed ''{0}'' controller named ''{1}'' for ''{2}'' CR (version ''{3}'')", new Object[]{controllerClassName, name, crdName, HasMetadata.getApiVersion((Class)crClass)});
        } else {
            log.infov("Skipped configuration reload for ''{0}'' controller as no changes were detected", (Object)controllerClassName);
        }
        if (storedConfigurations == null) {
            storedConfigurations = new ContextStoredControllerConfigurations();
        }
        storedConfigurations.getConfigurations().put(controllerClassName, configuration);
        liveReload.setContextObject(ContextStoredControllerConfigurations.class, (Object)storedConfigurations);
        return Optional.of(configuration);
    }

    private Set<String> getNamespaces(AnnotationInstance controllerAnnotation) {
        return QuarkusControllerConfiguration.asSet((String[])((String[])ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"namespaces", AnnotationValue::asStringArray, () -> new String[0])));
    }

    private String getFinalizer(AnnotationInstance controllerAnnotation, String crdName) {
        return (String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"finalizerName", AnnotationValue::asString, () -> ControllerUtils.getDefaultFinalizerName((String)crdName));
    }

    private String getLabelSelector(AnnotationInstance controllerAnnotation) {
        return (String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"labelSelector", AnnotationValue::asString, () -> null);
    }

    private void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectionClasses, String className) {
        Optional.ofNullable(className).filter(s -> !Void.TYPE.getName().equals(className)).ifPresent(cn -> {
            reflectionClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{cn}));
            log.infov("Registered ''{0}'' for reflection", cn);
        });
    }

    @BuildStep
    void createDelayedRegistrationObservers(CombinedIndexBuildItem combinedIndexBuildItem, ObserverRegistrationPhaseBuildItem observerRegistrationPhase, BuildProducer<ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem> observerConfigurators) {
        IndexView index = combinedIndexBuildItem.getIndex();
        ClassUtils.getKnownResourceControllers((IndexView)index, (Logger)log).forEach(info -> {
            AnnotationInstance controllerAnnotation;
            String controllerClassName = info.name().toString();
            String name = ConfigurationUtils.getControllerName((String)controllerClassName, (AnnotationInstance)(controllerAnnotation = info.classAnnotation(Constants.CONTROLLER)));
            BuildTimeHybridControllerConfiguration configExtractor = new BuildTimeHybridControllerConfiguration(this.buildTimeConfiguration, (BuildTimeControllerConfiguration)this.buildTimeConfiguration.controllers.get(name), controllerAnnotation, info.classAnnotation(DELAY_REGISTRATION));
            if (configExtractor.delayedRegistration()) {
                ObserverConfigurator configurator = observerRegistrationPhase.getContext().configure().observedType(configExtractor.eventType()).beanClass(info.name()).notify(mc -> {
                    MethodDescriptor cdiMethod = MethodDescriptor.ofMethod(CDI.class, (String)"current", CDI.class, (Class[])new Class[0]);
                    MethodDescriptor selectMethod = MethodDescriptor.ofMethod(CDI.class, (String)"select", Instance.class, (Class[])new Class[]{Class.class, Annotation[].class});
                    MethodDescriptor getMethod = MethodDescriptor.ofMethod(Instance.class, (String)"get", Object.class, (Class[])new Class[0]);
                    AssignableResultHandle cdiVar = mc.createVariable(CDI.class);
                    mc.assign(cdiVar, mc.invokeStaticMethod(cdiMethod, new ResultHandle[0]));
                    ResultHandle operator = this.getHandleFromCDI((MethodCreator)mc, selectMethod, getMethod, cdiVar, Operator.class, null);
                    ResultHandle resource = this.getHandleFromCDI((MethodCreator)mc, selectMethod, getMethod, cdiVar, ResourceController.class, controllerClassName);
                    ResultHandle config = this.getHandleFromCDI((MethodCreator)mc, selectMethod, getMethod, cdiVar, QuarkusConfigurationService.class, null);
                    mc.invokeStaticMethod(MethodDescriptor.ofMethod(OperatorProducer.class, (String)"applyCRDIfNeededAndRegister", Void.TYPE, (Class[])new Class[]{Operator.class, ResourceController.class, QuarkusConfigurationService.class}), new ResultHandle[]{operator, resource, config});
                    mc.returnValue(null);
                });
                observerConfigurators.produce((BuildItem)new ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem(new ObserverConfigurator[]{configurator}));
            }
        });
    }
}

