/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.quarkiverse.operatorsdk.common.ClassUtils;
import io.quarkiverse.operatorsdk.common.ConfigurationUtils;
import io.quarkiverse.operatorsdk.common.Constants;
import io.quarkiverse.operatorsdk.common.ResourceInfo;
import io.quarkiverse.operatorsdk.deployment.AddClusterRolesDecorator;
import io.quarkiverse.operatorsdk.deployment.AddRoleBindingsDecorator;
import io.quarkiverse.operatorsdk.deployment.BuildTimeHybridControllerConfiguration;
import io.quarkiverse.operatorsdk.deployment.CRDGeneration;
import io.quarkiverse.operatorsdk.deployment.ConfigurationServiceBuildItem;
import io.quarkiverse.operatorsdk.deployment.ContextStoredCRDInfos;
import io.quarkiverse.operatorsdk.deployment.ContextStoredControllerConfigurations;
import io.quarkiverse.operatorsdk.deployment.GeneratedCRDInfoBuildItem;
import io.quarkiverse.operatorsdk.runtime.AppEventListener;
import io.quarkiverse.operatorsdk.runtime.BuildTimeControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.CRDConfiguration;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import io.quarkiverse.operatorsdk.runtime.CRDInfo;
import io.quarkiverse.operatorsdk.runtime.ConfigurationServiceRecorder;
import io.quarkiverse.operatorsdk.runtime.DelayRegistrationUntil;
import io.quarkiverse.operatorsdk.runtime.NoOpMetricsProvider;
import io.quarkiverse.operatorsdk.runtime.OperatorProducer;
import io.quarkiverse.operatorsdk.runtime.QuarkusConfigurationService;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.RunTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.Version;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.ObserverRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.ObserverConfigurator;
import io.quarkus.bootstrap.app.ClassChangeInformation;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ForceNonWeakReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.runtime.QuarkusApplication;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class OperatorSDKProcessor {
    static final Logger log = Logger.getLogger((String)OperatorSDKProcessor.class.getName());
    private static final String FEATURE = "operator-sdk";
    private static final DotName DELAY_REGISTRATION = DotName.createSimple((String)DelayRegistrationUntil.class.getName());
    private BuildTimeOperatorConfiguration buildTimeConfiguration;

    OperatorSDKProcessor() {
    }

    @BuildStep
    void setup(BuildProducer<IndexDependencyBuildItem> indexDependency, BuildProducer<FeatureBuildItem> features, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, Optional<MetricsCapabilityBuildItem> metricsCapability, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        features.produce((BuildItem)new FeatureBuildItem(FEATURE));
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("io.javaoperatorsdk", "operator-framework-core"));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{ObjectMapper.class}));
        if (metricsCapability.isPresent() && metricsCapability.get().metricsSupported("micrometer")) {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)"io.quarkiverse.operatorsdk.runtime.MicrometerMetricsProvider"));
        } else {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(NoOpMetricsProvider.class));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void updateControllerConfigurations(ConfigurationServiceRecorder recorder, RunTimeOperatorConfiguration runTimeConfiguration, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, GeneratedCRDInfoBuildItem generatedCRDs, ConfigurationServiceBuildItem serviceBuildItem) {
        Supplier supplier = recorder.configurationServiceSupplier(serviceBuildItem.getVersion(), serviceBuildItem.getControllerConfigs(), generatedCRDs.getCRDGenerationInfo(), runTimeConfiguration, this.buildTimeConfiguration);
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(QuarkusConfigurationService.class).scope(Singleton.class)).addType(ConfigurationService.class)).setRuntimeInit().supplier(supplier).done());
    }

    @BuildStep
    ConfigurationServiceBuildItem createConfigurationServiceAndOperator(OutputTargetBuildItem outputTarget, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectionClasses, BuildProducer<ForceNonWeakReflectiveClassBuildItem> forcedReflectionClasses, BuildProducer<GeneratedCRDInfoBuildItem> generatedCRDInfo, LiveReloadBuildItem liveReload) {
        CRDConfiguration crdConfig = this.buildTimeConfiguration.crd;
        boolean validateCustomResources = ConfigurationUtils.shouldValidateCustomResources((Optional)this.buildTimeConfiguration.checkCRDAndValidateLocalModel, (boolean)this.buildTimeConfiguration.crd.validate, (Logger)log);
        CRDGeneration crdGeneration = new CRDGeneration(crdConfig.generate != false || crdConfig.apply != false);
        IndexView index = combinedIndexBuildItem.getIndex();
        List<QuarkusControllerConfiguration> controllerConfigs = ClassUtils.getKnownReconcilers((IndexView)index, (Logger)log).map(ci -> this.createControllerConfiguration((ClassInfo)ci, additionalBeans, reflectionClasses, forcedReflectionClasses, index, crdGeneration, liveReload)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        ContextStoredCRDInfos storedCRDInfos = (ContextStoredCRDInfos)liveReload.getContextObject(ContextStoredCRDInfos.class);
        if (storedCRDInfos == null) {
            storedCRDInfos = new ContextStoredCRDInfos();
        }
        CRDGenerationInfo crdInfo = crdGeneration.generate(outputTarget, crdConfig, validateCustomResources, storedCRDInfos.getExisting());
        storedCRDInfos.putAll(crdInfo.getCrds());
        liveReload.setContextObject(ContextStoredCRDInfos.class, (Object)storedCRDInfos);
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(OperatorProducer.class));
        if (index.getAllKnownImplementors(DotName.createSimple((String)QuarkusApplication.class.getName())).isEmpty()) {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(AppEventListener.class).setDefaultScope(DotName.createSimple((String)Singleton.class.getName())).setUnremovable().build());
        }
        generatedCRDInfo.produce((BuildItem)new GeneratedCRDInfoBuildItem(crdInfo));
        return new ConfigurationServiceBuildItem(Version.loadFromProperties(), controllerConfigs);
    }

    @BuildStep(onlyIf={IsRBACEnabled.class})
    public void addRBACForResources(BuildProducer<DecoratorBuildItem> decorators, ConfigurationServiceBuildItem configurations) {
        Map<String, QuarkusControllerConfiguration> configs = configurations.getControllerConfigs();
        HashMap<String, ResourceInfo> mappings = new HashMap<String, ResourceInfo>(configs.size());
        configs.forEach((controllerName, config) -> {
            ResourceInfo augmented = ResourceInfo.createFrom((Class)config.getResourceClass(), (String)config.getResourceTypeName(), (String)controllerName, (Optional)config.getSpecClassName(), (Optional)config.getStatusClassName());
            mappings.put((String)controllerName, augmented);
        });
        decorators.produce((BuildItem)new DecoratorBuildItem((Object)new AddClusterRolesDecorator(mappings, this.buildTimeConfiguration.crd.validate)));
        decorators.produce((BuildItem)new DecoratorBuildItem((Object)new AddRoleBindingsDecorator(configs, this.buildTimeConfiguration.crd.validate)));
    }

    private ResultHandle getHandleFromCDI(MethodCreator mc, MethodDescriptor selectMethod, MethodDescriptor getMethod, AssignableResultHandle cdiVar, Class<?> handleClass, String optionalImplClass) {
        ResultHandle operatorInstance = mc.invokeVirtualMethod(selectMethod, (ResultHandle)cdiVar, new ResultHandle[]{optionalImplClass != null ? mc.loadClass(optionalImplClass) : mc.loadClass(handleClass), mc.newArray(Annotation.class, 0)});
        return mc.checkCast(mc.invokeInterfaceMethod(getMethod, operatorInstance, new ResultHandle[0]), handleClass);
    }

    private Optional<QuarkusControllerConfiguration> createControllerConfiguration(ClassInfo info, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectionClasses, BuildProducer<ForceNonWeakReflectiveClassBuildItem> forcedReflectionClasses, IndexView index, CRDGeneration crdGeneration, LiveReloadBuildItem liveReload) {
        Type primaryType = (Type)JandexUtil.resolveTypeParameters((DotName)info.name(), (DotName)Constants.RECONCILER, (IndexView)index).get(0);
        DotName primaryTypeDN = primaryType.name();
        String primaryTypeName = primaryTypeDN.toString();
        String reconcilerClassName = info.name().toString();
        AnnotationInstance controllerAnnotation = info.classAnnotation(Constants.CONTROLLER_CONFIGURATION);
        String name = ConfigurationUtils.getReconcilerName((String)reconcilerClassName, (AnnotationInstance)controllerAnnotation);
        if (primaryTypeName == null || Constants.CUSTOM_RESOURCE.equals((Object)primaryTypeDN)) {
            log.infov("Skipped processing of ''{0}'' controller as it's not parameterized with a CustomResource sub-class", (Object)reconcilerClassName);
            return Optional.empty();
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(reconcilerClassName).setUnremovable().setDefaultScope(DotNames.APPLICATION_SCOPED).build());
        this.registerForReflection(reflectionClasses, primaryTypeName);
        forcedReflectionClasses.produce((BuildItem)new ForceNonWeakReflectiveClassBuildItem(primaryTypeName));
        ClassInfo primaryCI = index.getClassByName(primaryTypeDN);
        boolean isCR = false;
        if (primaryCI == null) {
            log.warnv("''{0}'' has not been found in the Jandex index so it cannot be introspected. Assumed not to be a CustomResource implementation. If you believe this is wrong, please index your classes with Jandex.", (Object)primaryTypeDN);
        } else {
            try {
                isCR = JandexUtil.isSubclassOf((IndexView)index, (ClassInfo)primaryCI, (DotName)Constants.CUSTOM_RESOURCE);
            }
            catch (BuildException e) {
                log.errorv("Couldn't ascertain if ''{0}'' is a CustomResource subclass. Assumed not to be.", (Object)e);
            }
        }
        String specClassName = null;
        String statusClassName = null;
        if (isCR) {
            List crParamTypes = JandexUtil.resolveTypeParameters((DotName)primaryTypeDN, (DotName)Constants.CUSTOM_RESOURCE, (IndexView)index);
            specClassName = ((Type)crParamTypes.get(0)).name().toString();
            statusClassName = ((Type)crParamTypes.get(1)).name().toString();
            this.registerForReflection(reflectionClasses, specClassName);
            this.registerForReflection(reflectionClasses, statusClassName);
        }
        Class resourceClass = null;
        String resourceFullName = null;
        ClassChangeInformation changeInformation = liveReload.getChangeInformation();
        if (isCR && crdGeneration.wantCRDGenerated()) {
            Class crClass;
            ContextStoredCRDInfos storedCRDInfos = (ContextStoredCRDInfos)liveReload.getContextObject(ContextStoredCRDInfos.class);
            boolean[] generateCurrent = new boolean[]{true};
            resourceClass = crClass = ClassUtils.loadClass((String)primaryTypeName);
            resourceFullName = this.getFullResourceName(crClass);
            if (liveReload.isLiveReload() && storedCRDInfos != null) {
                String finalCrdName = resourceFullName;
                Map<String, CRDInfo> crdInfos = storedCRDInfos.getCRDInfosFor(resourceFullName);
                this.buildTimeConfiguration.crd.versions.forEach(v -> {
                    CRDInfo crd = (CRDInfo)crdInfos.get(v);
                    if (crd == null) {
                        return;
                    }
                    if (changeInformation != null) {
                        for (String changedClass : changeInformation.getChangedClasses()) {
                            if (!crd.getDependentClassNames().contains(changedClass)) continue;
                            return;
                        }
                    }
                    generateCurrent[0] = false;
                    log.infov("''{0}'' CRD generation was skipped for ''{1}'' because no changes impacting the CRD were detected", v, (Object)finalCrdName);
                });
            }
            if (generateCurrent[0]) {
                crdGeneration.withCustomResource(crClass, resourceFullName, name);
            }
        }
        QuarkusControllerConfiguration configuration = null;
        boolean regenerateConfig = true;
        ContextStoredControllerConfigurations storedConfigurations = (ContextStoredControllerConfigurations)liveReload.getContextObject(ContextStoredControllerConfigurations.class);
        if (liveReload.isLiveReload() && storedConfigurations != null && (configuration = storedConfigurations.getConfigurations().get(reconcilerClassName)) != null) {
            Set changedClasses = changeInformation == null ? Collections.emptySet() : changeInformation.getChangedClasses();
            boolean bl = regenerateConfig = changedClasses.contains(reconcilerClassName) || changedClasses.contains(primaryTypeName) || liveReload.getChangedResources().contains("application.properties");
        }
        if (regenerateConfig) {
            AnnotationInstance delayedRegistrationAnnotation = info.classAnnotation(DELAY_REGISTRATION);
            BuildTimeHybridControllerConfiguration configExtractor = new BuildTimeHybridControllerConfiguration(this.buildTimeConfiguration, (BuildTimeControllerConfiguration)this.buildTimeConfiguration.controllers.get(name), controllerAnnotation, delayedRegistrationAnnotation);
            if (resourceFullName == null) {
                resourceClass = ClassUtils.loadClass((String)primaryTypeName);
                resourceFullName = this.getFullResourceName(resourceClass);
            }
            String crVersion = HasMetadata.getVersion((Class)resourceClass);
            configuration = new QuarkusControllerConfiguration(reconcilerClassName, name, resourceFullName, crVersion, configExtractor.generationAware(), primaryTypeName, configExtractor.delayedRegistration(), configExtractor.namespaces(name), this.getFinalizer(controllerAnnotation, resourceFullName), this.getLabelSelector(controllerAnnotation), Optional.ofNullable(specClassName), Optional.ofNullable(statusClassName));
            log.infov("Processed ''{0}'' reconciler named ''{1}'' for ''{2}'' resource (version ''{3}'')", new Object[]{reconcilerClassName, name, resourceFullName, HasMetadata.getApiVersion((Class)resourceClass)});
        } else {
            log.infov("Skipped configuration reload for ''{0}'' reconciler as no changes were detected", (Object)reconcilerClassName);
        }
        if (storedConfigurations == null) {
            storedConfigurations = new ContextStoredControllerConfigurations();
        }
        storedConfigurations.getConfigurations().put(reconcilerClassName, configuration);
        liveReload.setContextObject(ContextStoredControllerConfigurations.class, (Object)storedConfigurations);
        return Optional.of(configuration);
    }

    private String getFullResourceName(Class<? extends HasMetadata> crClass) {
        return ReconcilerUtils.getResourceTypeName(crClass);
    }

    private String getFinalizer(AnnotationInstance controllerAnnotation, String crdName) {
        return (String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"finalizerName", AnnotationValue::asString, () -> ReconcilerUtils.getDefaultFinalizerName((String)crdName));
    }

    private String getLabelSelector(AnnotationInstance controllerAnnotation) {
        return (String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"labelSelector", AnnotationValue::asString, () -> null);
    }

    private void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectionClasses, String className) {
        Optional.ofNullable(className).filter(s -> !Void.TYPE.getName().equals(className)).ifPresent(cn -> {
            reflectionClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{cn}));
            log.infov("Registered ''{0}'' for reflection", cn);
        });
    }

    @BuildStep
    void createDelayedRegistrationObservers(CombinedIndexBuildItem combinedIndexBuildItem, ObserverRegistrationPhaseBuildItem observerRegistrationPhase, BuildProducer<ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem> observerConfigurators) {
        IndexView index = combinedIndexBuildItem.getIndex();
        ClassUtils.getKnownReconcilers((IndexView)index, (Logger)log).forEach(info -> {
            AnnotationInstance controllerAnnotation;
            String controllerClassName = info.name().toString();
            String name = ConfigurationUtils.getReconcilerName((String)controllerClassName, (AnnotationInstance)(controllerAnnotation = info.classAnnotation(Constants.CONTROLLER_CONFIGURATION)));
            BuildTimeHybridControllerConfiguration configExtractor = new BuildTimeHybridControllerConfiguration(this.buildTimeConfiguration, (BuildTimeControllerConfiguration)this.buildTimeConfiguration.controllers.get(name), controllerAnnotation, info.classAnnotation(DELAY_REGISTRATION));
            if (configExtractor.delayedRegistration()) {
                ObserverConfigurator configurator = observerRegistrationPhase.getContext().configure().observedType(configExtractor.eventType()).beanClass(info.name()).notify(mc -> {
                    MethodDescriptor cdiMethod = MethodDescriptor.ofMethod(CDI.class, (String)"current", CDI.class, (Class[])new Class[0]);
                    MethodDescriptor selectMethod = MethodDescriptor.ofMethod(CDI.class, (String)"select", Instance.class, (Class[])new Class[]{Class.class, Annotation[].class});
                    MethodDescriptor getMethod = MethodDescriptor.ofMethod(Instance.class, (String)"get", Object.class, (Class[])new Class[0]);
                    AssignableResultHandle cdiVar = mc.createVariable(CDI.class);
                    mc.assign(cdiVar, mc.invokeStaticMethod(cdiMethod, new ResultHandle[0]));
                    ResultHandle operator = this.getHandleFromCDI((MethodCreator)mc, selectMethod, getMethod, cdiVar, Operator.class, null);
                    ResultHandle resource = this.getHandleFromCDI((MethodCreator)mc, selectMethod, getMethod, cdiVar, Reconciler.class, controllerClassName);
                    ResultHandle config = this.getHandleFromCDI((MethodCreator)mc, selectMethod, getMethod, cdiVar, QuarkusConfigurationService.class, null);
                    mc.invokeStaticMethod(MethodDescriptor.ofMethod(OperatorProducer.class, (String)"applyCRDIfNeededAndRegister", Void.TYPE, (Class[])new Class[]{Operator.class, Reconciler.class, QuarkusConfigurationService.class}), new ResultHandle[]{operator, resource, config});
                    mc.returnValue(null);
                });
                observerConfigurators.produce((BuildItem)new ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem(new ObserverConfigurator[]{configurator}));
            }
        });
    }

    private static class IsRBACEnabled
    implements BooleanSupplier {
        private BuildTimeOperatorConfiguration config;

        private IsRBACEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.config.disableRbacGeneration == false;
        }
    }
}

