/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleFluent;
import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import io.fabric8.kubernetes.api.model.rbac.PolicyRuleBuilder;
import io.quarkiverse.operatorsdk.common.ResourceInfo;
import java.util.Map;

public class AddClusterRolesDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    public static final String[] ALL_VERBS = new String[]{"get", "list", "watch", "create", "delete", "patch", "update"};
    static final String JOSDK_CRD_VALIDATING_CLUSTER_ROLE = "josdk-crd-validating-cluster-role";
    private final Map<String, ResourceInfo> controllerToCustomResourceMappings;
    private final boolean validateCRDs;

    public AddClusterRolesDecorator(Map<String, ResourceInfo> controllerToCustomResourceMappings, boolean validateCRDs) {
        this.controllerToCustomResourceMappings = controllerToCustomResourceMappings;
        this.validateCRDs = validateCRDs;
    }

    public void visit(KubernetesListBuilder list) {
        this.controllerToCustomResourceMappings.forEach((controller, cri) -> {
            PolicyRuleBuilder rule = new PolicyRuleBuilder();
            String plural = cri.getPlural();
            rule.addNewResource(plural);
            cri.getStatusClassName().ifPresent(statusClass -> {
                if (!"java.lang.Void".equals(statusClass)) {
                    rule.addNewResource(plural + "/status");
                }
            });
            rule.addNewResource(plural + "/finalizers");
            ((PolicyRuleBuilder)((PolicyRuleBuilder)rule.addNewApiGroup(cri.getGroup())).addToVerbs(ALL_VERBS)).build();
            ClusterRoleBuilder clusterRoleBuilder = (ClusterRoleBuilder)((ClusterRoleBuilder)((ClusterRoleFluent.MetadataNested)new ClusterRoleBuilder().withNewMetadata().withName(AddClusterRolesDecorator.getClusterRoleName(controller))).endMetadata()).addToRules(new PolicyRule[]{rule.build()});
            list.addToItems(new HasMetadata[]{clusterRoleBuilder.build()});
        });
        if (this.validateCRDs) {
            String crName = JOSDK_CRD_VALIDATING_CLUSTER_ROLE;
            if (!this.contains(list, HasMetadata.getApiVersion(ClusterRole.class), HasMetadata.getKind(ClusterRole.class), JOSDK_CRD_VALIDATING_CLUSTER_ROLE)) {
                list.addToItems((VisitableBuilder)((ClusterRoleBuilder)((ClusterRoleFluent.MetadataNested)new ClusterRoleBuilder().withNewMetadata().withName(JOSDK_CRD_VALIDATING_CLUSTER_ROLE)).endMetadata()).addToRules(new PolicyRule[]{((PolicyRuleBuilder)((PolicyRuleBuilder)((PolicyRuleBuilder)new PolicyRuleBuilder().addNewApiGroup("apiextensions.k8s.io")).addNewResource("customresourcedefinitions")).addToVerbs(new String[]{"get", "list"})).build()}));
            }
        }
    }

    static String getClusterRoleName(String controller) {
        return controller + "-cluster-role";
    }
}

