/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class ContextStoredControllerConfigurations {
    private final Map<String, QuarkusControllerConfiguration> configurations = new HashMap<String, QuarkusControllerConfiguration>();

    ContextStoredControllerConfigurations() {
    }

    Map<String, QuarkusControllerConfiguration> getConfigurations() {
        return Collections.unmodifiableMap(this.configurations);
    }

    void recordConfiguration(QuarkusControllerConfiguration configuration) {
        if (configuration != null) {
            this.configurations.put(configuration.getAssociatedReconcilerClassName(), configuration);
        }
    }

    public QuarkusControllerConfiguration<?> configurationOrNullIfNeedGeneration(String reconcilerClassName, Set<String> changedClasses, Set<String> changedResources) {
        QuarkusControllerConfiguration configuration = this.configurations.get(reconcilerClassName);
        return configuration != null && this.shouldRegenerate(reconcilerClassName, changedClasses, changedResources, configuration) ? null : configuration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldRegenerate(String reconcilerClassName, Set<String> changedClasses, Set<String> changedResources, QuarkusControllerConfiguration<?> configuration) {
        if (changedClasses.contains(reconcilerClassName)) return true;
        if (changedClasses.contains(configuration.getResourceTypeName())) return true;
        if (changedResources.contains("application.properties")) return true;
        if (!configuration.getDependentResources().stream().map(dr -> dr.getDependentResourceClass().getCanonicalName()).anyMatch(changedClasses::contains)) return false;
        return true;
    }
}

