/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.reconciler.Constants;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Condition;
import io.javaoperatorsdk.operator.processing.event.rate.LinearRateLimiter;
import io.javaoperatorsdk.operator.processing.event.rate.RateLimiter;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceEventFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.GenericFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnAddFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnDeleteFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import io.javaoperatorsdk.operator.processing.retry.GenericRetry;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import io.quarkiverse.operatorsdk.common.AnnotationConfigurableAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ClassLoadingUtils;
import io.quarkiverse.operatorsdk.common.ConfigurationUtils;
import io.quarkiverse.operatorsdk.common.DependentResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconciledAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconciledResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconcilerAugmentedClassInfo;
import io.quarkiverse.operatorsdk.deployment.BuildTimeHybridControllerConfiguration;
import io.quarkiverse.operatorsdk.deployment.ContextStoredControllerConfigurations;
import io.quarkiverse.operatorsdk.runtime.BuildTimeControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.QuarkusDependentResourceSpec;
import io.quarkiverse.operatorsdk.runtime.QuarkusKubernetesDependentResourceConfig;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.bootstrap.app.ClassChangeInformation;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class QuarkusControllerConfigurationBuilder {
    static final Logger log = Logger.getLogger((String)QuarkusControllerConfigurationBuilder.class.getName());
    private final BuildProducer<AdditionalBeanBuildItem> additionalBeans;
    private final IndexView index;
    private final LiveReloadBuildItem liveReload;
    private final BuildTimeOperatorConfiguration buildTimeConfiguration;

    public QuarkusControllerConfigurationBuilder(BuildProducer<AdditionalBeanBuildItem> additionalBeans, IndexView index, LiveReloadBuildItem liveReload, BuildTimeOperatorConfiguration buildTimeConfiguration) {
        this.additionalBeans = additionalBeans;
        this.index = index;
        this.liveReload = liveReload;
        this.buildTimeConfiguration = buildTimeConfiguration;
    }

    QuarkusControllerConfiguration build(ReconcilerAugmentedClassInfo reconcilerInfo, Map<String, AnnotationConfigurableAugmentedClassInfo> configurableInfos) {
        ClassInfo info = reconcilerInfo.classInfo();
        String reconcilerClassName = info.toString();
        String name = reconcilerInfo.nameOrFailIfUnset();
        this.additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(reconcilerClassName).setUnremovable().setDefaultScope(DotNames.APPLICATION_SCOPED).build());
        ClassChangeInformation changeInformation = this.liveReload.getChangeInformation();
        QuarkusControllerConfiguration configuration = null;
        ContextStoredControllerConfigurations storedConfigurations = (ContextStoredControllerConfigurations)this.liveReload.getContextObject(ContextStoredControllerConfigurations.class);
        if (this.liveReload.isLiveReload() && storedConfigurations != null) {
            Set changedClasses = changeInformation == null ? Collections.emptySet() : changeInformation.getChangedClasses();
            Set changedResources = this.liveReload.getChangedResources();
            configuration = storedConfigurations.configurationOrNullIfNeedGeneration(reconcilerClassName, changedClasses, changedResources);
        }
        if (configuration == null) {
            List dependentResources;
            boolean wereNamespacesSet;
            Set namespaces;
            Type[] eventFilterTypes;
            AnnotationInstance controllerAnnotation = info.classAnnotation(io.quarkiverse.operatorsdk.common.Constants.CONTROLLER_CONFIGURATION);
            BuildTimeHybridControllerConfiguration configExtractor = new BuildTimeHybridControllerConfiguration(this.buildTimeConfiguration, (BuildTimeControllerConfiguration)this.buildTimeConfiguration.controllers.get(name), controllerAnnotation);
            ResourceEventFilter finalFilter = null;
            for (Type filterType : eventFilterTypes = (Type[])ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"eventFilters", AnnotationValue::asClassArray, () -> new Type[0])) {
                Class filterClass = ClassLoadingUtils.loadClass((String)filterType.name().toString(), ResourceEventFilter.class);
                ResourceEventFilter filter = (ResourceEventFilter)ClassLoadingUtils.instantiate((Class)filterClass);
                finalFilter = finalFilter == null ? filter : finalFilter.and(filter);
            }
            Duration maxReconciliationInterval = null;
            OnAddFilter onAddFilter = null;
            OnUpdateFilter onUpdateFilter = null;
            GenericFilter genericFilter = null;
            Retry retry = null;
            Class<?> retryConfigurationClass = null;
            RateLimiter rateLimiter = null;
            Class<?> rateLimiterConfigurationClass = null;
            if (controllerAnnotation != null) {
                AnnotationInstance intervalFromAnnotation = (AnnotationInstance)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"maxReconciliationInterval", AnnotationValue::asNested, () -> null);
                Long interval = (Long)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)intervalFromAnnotation, (String)"interval", AnnotationValue::asLong, () -> 10L);
                TimeUnit timeUnit = (TimeUnit)((Object)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)intervalFromAnnotation, (String)"timeUnit", av -> TimeUnit.valueOf(av.asEnum()), () -> TimeUnit.HOURS));
                if (interval > 0L) {
                    maxReconciliationInterval = Duration.of(interval, timeUnit.toChronoUnit());
                }
                onAddFilter = (OnAddFilter)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)controllerAnnotation, (String)"onAddFilter", OnAddFilter.class, OnAddFilter.class, (boolean)true, (IndexView)this.index);
                onUpdateFilter = (OnUpdateFilter)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)controllerAnnotation, (String)"onUpdateFilter", OnUpdateFilter.class, OnUpdateFilter.class, (boolean)true, (IndexView)this.index);
                genericFilter = (GenericFilter)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)controllerAnnotation, (String)"genericFilter", GenericFilter.class, GenericFilter.class, (boolean)true, (IndexView)this.index);
                retry = (Retry)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)controllerAnnotation, (String)"retry", Retry.class, GenericRetry.class, (boolean)true, (IndexView)this.index);
                Class retryClass = retry != null ? retry.getClass() : GenericRetry.class;
                AnnotationConfigurableAugmentedClassInfo retryConfigurableInfo = configurableInfos.get(retryClass.getName());
                retryConfigurationClass = QuarkusControllerConfigurationBuilder.getConfigurationClass(reconcilerInfo, retryConfigurableInfo);
                rateLimiter = (RateLimiter)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)controllerAnnotation, (String)"rateLimiter", RateLimiter.class, QuarkusControllerConfiguration.DefaultRateLimiter.class, (boolean)true, (IndexView)this.index);
                Class rateLimiterClass = rateLimiter != null ? rateLimiter.getClass() : LinearRateLimiter.class;
                AnnotationConfigurableAugmentedClassInfo rateLimiterConfigurableInfo = configurableInfos.get(rateLimiterClass.getName());
                rateLimiterConfigurationClass = QuarkusControllerConfigurationBuilder.getConfigurationClass(reconcilerInfo, rateLimiterConfigurableInfo);
            }
            if ((namespaces = configExtractor.namespaces(name)) == null) {
                namespaces = Constants.DEFAULT_NAMESPACES_SET;
                wereNamespacesSet = false;
            } else {
                wereNamespacesSet = true;
            }
            Set finalNamespaces = namespaces;
            Collection dependentResourceInfos = reconcilerInfo.getDependentResourceInfos();
            if (!dependentResourceInfos.isEmpty()) {
                dependentResources = new ArrayList(dependentResourceInfos.size());
                dependentResourceInfos.forEach(dependent -> {
                    dependentResources.add(this.createDependentResourceSpec((DependentResourceAugmentedClassInfo)dependent, this.index, finalNamespaces));
                    String dependentTypeName = dependent.classInfo().name().toString();
                    this.additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(dependentTypeName).setUnremovable().setDefaultScope(DotNames.APPLICATION_SCOPED).build());
                });
            } else {
                dependentResources = Collections.emptyList();
            }
            ReconciledAugmentedClassInfo primaryInfo = reconcilerInfo.associatedResourceInfo();
            ReconciledResourceAugmentedClassInfo primaryAsResource = primaryInfo.asResourceTargeting();
            Class resourceClass = primaryInfo.loadAssociatedClass();
            String resourceFullName = primaryAsResource.fullResourceName();
            configuration = new QuarkusControllerConfiguration(reconcilerClassName, name, resourceFullName, primaryAsResource.version(), configExtractor.generationAware(), resourceClass, namespaces, wereNamespacesSet, this.getFinalizer(controllerAnnotation, resourceFullName), this.getLabelSelector(controllerAnnotation), primaryAsResource.hasNonVoidStatus(), dependentResources, finalFilter, maxReconciliationInterval, onAddFilter, onUpdateFilter, genericFilter, retry, retryConfigurationClass, rateLimiter, rateLimiterConfigurationClass);
            log.infov("Processed ''{0}'' reconciler named ''{1}'' for ''{2}'' resource (version ''{3}'')", new Object[]{reconcilerClassName, name, resourceFullName, HasMetadata.getApiVersion((Class)resourceClass)});
        } else {
            log.infov("Skipped configuration reload for ''{0}'' reconciler as no changes were detected", (Object)reconcilerClassName);
        }
        if (storedConfigurations == null) {
            storedConfigurations = new ContextStoredControllerConfigurations();
        }
        storedConfigurations.recordConfiguration(configuration);
        this.liveReload.setContextObject(ContextStoredControllerConfigurations.class, (Object)storedConfigurations);
        return configuration;
    }

    private static Class<?> getConfigurationClass(ReconcilerAugmentedClassInfo reconcilerInfo, AnnotationConfigurableAugmentedClassInfo configurableInfo) {
        if (configurableInfo != null) {
            DotName associatedConfigurationClass = configurableInfo.getAssociatedConfigurationClass();
            if (reconcilerInfo.classInfo().annotations().containsKey(associatedConfigurationClass)) {
                return ClassLoadingUtils.loadClass((String)associatedConfigurationClass.toString(), Object.class);
            }
        }
        return null;
    }

    private QuarkusDependentResourceSpec createDependentResourceSpec(DependentResourceAugmentedClassInfo dependent, IndexView index, Set<String> namespaces) {
        boolean isKubernetesDependent;
        ClassInfo dependentType = dependent.classInfo();
        String dependentTypeName = dependentType.name().toString();
        try {
            isKubernetesDependent = JandexUtil.isSubclassOf((IndexView)index, (ClassInfo)dependentType, (DotName)io.quarkiverse.operatorsdk.common.Constants.KUBERNETES_DEPENDENT_RESOURCE);
        }
        catch (BuildException e) {
            throw new IllegalStateException("DependentResource " + dependentType + " is not indexed", e);
        }
        QuarkusKubernetesDependentResourceConfig cfg = null;
        if (isKubernetesDependent) {
            Optional<String[]> nonDefaultNS;
            AnnotationInstance kubeDepConfig = dependentType.classAnnotation(io.quarkiverse.operatorsdk.common.Constants.KUBERNETES_DEPENDENT);
            String labelSelector = this.getLabelSelector(kubeDepConfig);
            Set<String> dependentNamespaces = namespaces;
            boolean configuredNS = false;
            if (kubeDepConfig != null && (nonDefaultNS = Optional.ofNullable(kubeDepConfig.value("namespaces")).map(AnnotationValue::asStringArray).filter(v -> !Arrays.equals(KubernetesDependent.DEFAULT_NAMESPACES, v))).isPresent()) {
                configuredNS = true;
                dependentNamespaces = nonDefaultNS.map(Set::of).orElse(namespaces);
            }
            OnAddFilter onAddFilter = (OnAddFilter)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)kubeDepConfig, (String)"onAddFilter", OnAddFilter.class, OnAddFilter.class, (boolean)true, (IndexView)index);
            OnUpdateFilter onUpdateFilter = (OnUpdateFilter)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)kubeDepConfig, (String)"onUpdateFilter", OnUpdateFilter.class, OnUpdateFilter.class, (boolean)true, (IndexView)index);
            OnDeleteFilter onDeleteFilter = (OnDeleteFilter)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)kubeDepConfig, (String)"onDeleteFilter", OnDeleteFilter.class, OnDeleteFilter.class, (boolean)true, (IndexView)index);
            GenericFilter genericFilter = (GenericFilter)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)kubeDepConfig, (String)"genericFilter", GenericFilter.class, GenericFilter.class, (boolean)true, (IndexView)index);
            cfg = new QuarkusKubernetesDependentResourceConfig(dependentNamespaces, labelSelector, configuredNS, onAddFilter, onUpdateFilter, onDeleteFilter, genericFilter);
        }
        Class dependentClass = ClassLoadingUtils.loadClass((String)dependentTypeName, DependentResource.class);
        AnnotationInstance dependentConfig = dependent.getDependentAnnotationFromController();
        AnnotationValue dependsOnField = dependentConfig.value("dependsOn");
        Set dependsOn = Optional.ofNullable(dependsOnField).map(AnnotationValue::asStringArray).filter(array -> ((String[])array).length > 0).map(Set::of).orElse(Collections.emptySet());
        Condition readyCondition = (Condition)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)dependentConfig, (String)"readyPostcondition", Condition.class, Condition.class, (boolean)true, (IndexView)index);
        Condition reconcilePrecondition = (Condition)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)dependentConfig, (String)"reconcilePrecondition", Condition.class, Condition.class, (boolean)true, (IndexView)index);
        Condition deletePostcondition = (Condition)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)dependentConfig, (String)"deletePostcondition", Condition.class, Condition.class, (boolean)true, (IndexView)index);
        return new QuarkusDependentResourceSpec(dependentClass, (Object)cfg, dependent.nameOrFailIfUnset(), dependsOn, readyCondition, reconcilePrecondition, deletePostcondition);
    }

    private String getFinalizer(AnnotationInstance controllerAnnotation, String crdName) {
        return (String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"finalizerName", AnnotationValue::asString, () -> ReconcilerUtils.getDefaultFinalizerName((String)crdName));
    }

    private String getLabelSelector(AnnotationInstance controllerAnnotation) {
        return (String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"labelSelector", AnnotationValue::asString, () -> null);
    }
}

