/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleFluent;
import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import io.fabric8.kubernetes.api.model.rbac.PolicyRuleBuilder;
import io.javaoperatorsdk.operator.api.reconciler.dependent.Deleter;
import io.javaoperatorsdk.operator.processing.dependent.Creator;
import io.javaoperatorsdk.operator.processing.dependent.Updater;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class AddClusterRolesDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    public static final String[] READ_VERBS = new String[]{"get", "list", "watch"};
    public static final String[] UPDATE_VERBS = new String[]{"patch", "update"};
    public static final String CREATE_VERB = "create";
    public static final String DELETE_VERB = "delete";
    public static final String[] ALL_VERBS;
    static final String JOSDK_CRD_VALIDATING_CLUSTER_ROLE = "josdk-crd-validating-cluster-role";
    private final Map<String, QuarkusControllerConfiguration> configs;
    private final boolean validateCRDs;

    public AddClusterRolesDecorator(Map<String, QuarkusControllerConfiguration> configs, boolean validateCRDs) {
        this.configs = configs;
        this.validateCRDs = validateCRDs;
    }

    public void visit(KubernetesListBuilder list) {
        this.configs.forEach((controller, cri) -> {
            PolicyRuleBuilder rule = new PolicyRuleBuilder();
            Class resourceClass = cri.getResourceClass();
            String plural = HasMetadata.getPlural((Class)resourceClass);
            rule.addToResources(new String[]{plural});
            if (cri.isStatusPresentAndNotVoid()) {
                rule.addToResources(new String[]{plural + "/status"});
            }
            rule.addToResources(new String[]{plural + "/finalizers"});
            ((PolicyRuleBuilder)((PolicyRuleBuilder)rule.addToApiGroups(new String[]{HasMetadata.getGroup((Class)resourceClass)})).addToVerbs(ALL_VERBS)).build();
            ClusterRoleBuilder clusterRoleBuilder = (ClusterRoleBuilder)((ClusterRoleBuilder)((ClusterRoleFluent.MetadataNested)new ClusterRoleBuilder().withNewMetadata().withName(AddClusterRolesDecorator.getClusterRoleName(controller))).endMetadata()).addToRules(new PolicyRule[]{rule.build()});
            Map dependentsMetadata = cri.getDependentsMetadata();
            dependentsMetadata.forEach((name, spec) -> {
                Class dependentResourceClass = spec.getDependentResourceClass();
                Class associatedResourceClass = spec.getDependentType();
                if (HasMetadata.class.isAssignableFrom(associatedResourceClass)) {
                    PolicyRuleBuilder dependentRule = (PolicyRuleBuilder)((PolicyRuleBuilder)((PolicyRuleBuilder)new PolicyRuleBuilder().addToApiGroups(new String[]{HasMetadata.getGroup((Class)associatedResourceClass)})).addToResources(new String[]{HasMetadata.getPlural((Class)associatedResourceClass)})).addToVerbs(READ_VERBS);
                    if (Creator.class.isAssignableFrom(dependentResourceClass)) {
                        dependentRule.addToVerbs(new String[]{CREATE_VERB});
                    }
                    if (Updater.class.isAssignableFrom(dependentResourceClass)) {
                        dependentRule.addToVerbs(UPDATE_VERBS);
                    }
                    if (Deleter.class.isAssignableFrom(dependentResourceClass)) {
                        dependentRule.addToVerbs(new String[]{DELETE_VERB});
                    }
                    clusterRoleBuilder.addToRules(new PolicyRule[]{dependentRule.build()});
                }
            });
            list.addToItems(new HasMetadata[]{clusterRoleBuilder.build()});
        });
        if (this.validateCRDs) {
            String crName = JOSDK_CRD_VALIDATING_CLUSTER_ROLE;
            if (!this.contains(list, HasMetadata.getApiVersion(ClusterRole.class), HasMetadata.getKind(ClusterRole.class), JOSDK_CRD_VALIDATING_CLUSTER_ROLE)) {
                list.addToItems((VisitableBuilder)((ClusterRoleBuilder)((ClusterRoleFluent.MetadataNested)new ClusterRoleBuilder().withNewMetadata().withName(JOSDK_CRD_VALIDATING_CLUSTER_ROLE)).endMetadata()).addToRules(new PolicyRule[]{((PolicyRuleBuilder)((PolicyRuleBuilder)((PolicyRuleBuilder)new PolicyRuleBuilder().addToApiGroups(new String[]{"apiextensions.k8s.io"})).addToResources(new String[]{"customresourcedefinitions"})).addToVerbs(new String[]{"get", "list"})).build()}));
            }
        }
    }

    public static String getClusterRoleName(String controller) {
        return controller + "-cluster-role";
    }

    static {
        ArrayList<String> verbs = new ArrayList<String>(READ_VERBS.length + UPDATE_VERBS.length + 2);
        verbs.addAll(Arrays.asList(READ_VERBS));
        verbs.addAll(Arrays.asList(UPDATE_VERBS));
        verbs.add(CREATE_VERB);
        verbs.add(DELETE_VERB);
        ALL_VERBS = verbs.toArray(new String[0]);
    }
}

