/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.javaoperatorsdk.operator.api.reconciler.Constants;
import io.quarkiverse.operatorsdk.common.ConfigurationUtils;
import io.quarkiverse.operatorsdk.common.RuntimeConfigurationUtils;
import io.quarkiverse.operatorsdk.runtime.BuildTimeControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

class BuildTimeHybridControllerConfiguration {
    private final BuildTimeOperatorConfiguration operatorConfiguration;
    private final BuildTimeControllerConfiguration externalConfiguration;
    private final AnnotationInstance controllerAnnotation;

    public BuildTimeHybridControllerConfiguration(BuildTimeOperatorConfiguration operatorConfiguration, BuildTimeControllerConfiguration externalConfiguration, AnnotationInstance controllerAnnotation) {
        this.operatorConfiguration = operatorConfiguration;
        this.externalConfiguration = externalConfiguration;
        this.controllerAnnotation = controllerAnnotation;
    }

    boolean generationAware() {
        return (Boolean)ConfigurationUtils.extract((Object)this.externalConfiguration, (AnnotationInstance)this.controllerAnnotation, c -> c.generationAware, (String)"generationAwareEventProcessing", AnnotationValue::asBoolean, () -> this.operatorConfiguration.generationAware.orElse(true));
    }

    Set<String> namespaces(String controllerName) {
        Set namespaces = RuntimeConfigurationUtils.namespacesFromConfigurationFor((String)controllerName);
        if (namespaces != null && !namespaces.isEmpty()) {
            return namespaces;
        }
        return (Set)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)this.controllerAnnotation, (String)"namespaces", v -> new HashSet<String>(Arrays.asList(v.asStringArray())), () -> Constants.DEFAULT_NAMESPACES_SET);
    }
}

