/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluent;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingBuilder;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent;
import io.quarkiverse.operatorsdk.deployment.AddClusterRolesDecorator;
import io.quarkiverse.operatorsdk.deployment.OperatorSDKProcessor;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.microprofile.config.ConfigProvider;

public class AddRoleBindingsDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    protected static final String RBAC_AUTHORIZATION_GROUP = "rbac.authorization.k8s.io";
    protected static final String CLUSTER_ROLE = "ClusterRole";
    protected static final String SERVICE_ACCOUNT = "ServiceAccount";
    private final Map<String, QuarkusControllerConfiguration> configs;
    private final boolean validateCRDs;
    private static final ConcurrentMap<String, Object> alreadyLogged = new ConcurrentHashMap<String, Object>();
    private static final Optional<String> deployNamespace = ConfigProvider.getConfig().getOptionalValue("quarkus.kubernetes.namespace", String.class);

    public AddRoleBindingsDecorator(Map<String, QuarkusControllerConfiguration> configs, boolean validateCRDs) {
        this.configs = configs;
        this.validateCRDs = validateCRDs;
    }

    public void visit(KubernetesListBuilder list) {
        String serviceAccountName = this.getMandatoryDeploymentMetadata(list).getName();
        for (Map.Entry<String, QuarkusControllerConfiguration> entry : this.configs.entrySet()) {
            String controllerName = entry.getKey();
            QuarkusControllerConfiguration config = entry.getValue();
            if (config.watchCurrentNamespace()) {
                list.addToItems(new HasMetadata[]{((RoleBindingBuilder)((RoleBindingBuilder)((RoleBindingBuilder)((RoleBindingFluent.MetadataNested)new RoleBindingBuilder().withNewMetadata().withName(controllerName + "-role-binding")).endMetadata()).withNewRoleRef(RBAC_AUTHORIZATION_GROUP, CLUSTER_ROLE, AddClusterRolesDecorator.getClusterRoleName(controllerName))).addNewSubject(null, SERVICE_ACCOUNT, serviceAccountName, null)).build()});
            } else if (config.watchAllNamespaces()) {
                this.handleClusterRoleBinding(list, serviceAccountName, controllerName, controllerName + "-cluster-role-binding", "watch all namespaces", AddClusterRolesDecorator.getClusterRoleName(controllerName));
            } else {
                config.getEffectiveNamespaces().forEach(ns -> list.addToItems(new HasMetadata[]{((RoleBindingBuilder)((RoleBindingBuilder)((RoleBindingBuilder)((RoleBindingFluent.MetadataNested)((RoleBindingFluent.MetadataNested)new RoleBindingBuilder().withNewMetadata().withName(controllerName + "-role-binding")).withNamespace(ns)).endMetadata()).withNewRoleRef(RBAC_AUTHORIZATION_GROUP, CLUSTER_ROLE, AddClusterRolesDecorator.getClusterRoleName(controllerName))).addNewSubject(null, SERVICE_ACCOUNT, serviceAccountName, (String)deployNamespace.orElse(null))).build()}));
            }
            if (!this.validateCRDs) continue;
            String crBindingName = controllerName + "-crd-validating-role-binding";
            this.handleClusterRoleBinding(list, serviceAccountName, controllerName, crBindingName, "validate CRDs", "josdk-crd-validating-cluster-role");
        }
    }

    private void handleClusterRoleBinding(KubernetesListBuilder list, String serviceAccountName, String controllerName, String bindingName, String controllerConfMessage, String clusterRoleName) {
        this.outputWarningIfNeeded(controllerName, bindingName, controllerConfMessage);
        list.addToItems(new HasMetadata[]{((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.SubjectsNested)((ClusterRoleBindingFluent.SubjectsNested)((ClusterRoleBindingFluent.SubjectsNested)((ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.MetadataNested)new ClusterRoleBindingBuilder().withNewMetadata().withName(bindingName)).endMetadata()).withNewRoleRef(RBAC_AUTHORIZATION_GROUP, CLUSTER_ROLE, clusterRoleName)).addNewSubject().withKind(SERVICE_ACCOUNT)).withName(serviceAccountName)).withNamespace((String)deployNamespace.orElse(null))).endSubject()).build()});
    }

    private void outputWarningIfNeeded(String controllerName, String crBindingName, String controllerConfMessage) {
        if (deployNamespace.isEmpty() && alreadyLogged.putIfAbsent(controllerName + crBindingName, new Object()) == null) {
            OperatorSDKProcessor.log.warnv("''{0}'' controller is configured to " + controllerConfMessage + ", this requires a ClusterRoleBinding for which we MUST specify the namespace of the operator ServiceAccount. This can be specified by setting the ''quarkus.kubernetes.namespace'' property. However, as this property is not set, we are leaving the namespace blank to be provided by the user by editing the ''{1}'' ClusterRoleBinding to provide the namespace in which the operator will be deployed.", (Object)controllerName, (Object)crBindingName);
        }
    }
}

