/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.fabric8.crd.generator.CRDGenerationInfo;
import io.fabric8.crd.generator.CRDGenerator;
import io.fabric8.crd.generator.CustomResourceInfo;
import io.fabric8.kubernetes.client.CustomResource;
import io.quarkiverse.operatorsdk.common.CustomResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.deployment.OperatorSDKProcessor;
import io.quarkiverse.operatorsdk.deployment.ResourceControllerMapping;
import io.quarkiverse.operatorsdk.runtime.CRDConfiguration;
import io.quarkiverse.operatorsdk.runtime.CRDInfo;
import io.quarkiverse.operatorsdk.runtime.ResourceInfo;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class CRDGeneration {
    private final CRDGenerator generator = new CRDGenerator();
    private final boolean generate;
    private final LaunchMode mode;
    private final CRDConfiguration crdConfiguration;
    private boolean needGeneration;
    private final ResourceControllerMapping crMappings = new ResourceControllerMapping();

    public CRDGeneration(CRDConfiguration crdConfig, LaunchMode mode) {
        this.crdConfiguration = crdConfig;
        this.mode = mode;
        this.generate = CRDGeneration.shouldGenerate(crdConfig.generate, crdConfig.apply, mode);
    }

    static boolean shouldGenerate(Optional<Boolean> configuredGenerate, Optional<Boolean> configuredApply, LaunchMode launchMode) {
        return CRDGeneration.shouldApply(configuredApply, launchMode) || configuredGenerate.orElse(true) != false;
    }

    static boolean shouldApply(Optional<Boolean> configuredApply, LaunchMode launchMode) {
        if (launchMode == null || !launchMode.isDevOrTest()) {
            return false;
        }
        return configuredApply.orElse(true);
    }

    boolean shouldApply() {
        return CRDGeneration.shouldApply(this.crdConfiguration.apply, this.mode);
    }

    public boolean wantCRDGenerated() {
        return this.generate;
    }

    io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo generate(OutputTargetBuildItem outputTarget, boolean validateCustomResources, Map<String, Map<String, CRDInfo>> existing) {
        HashMap<String, Map<String, CRDInfo>> converted = new HashMap<String, Map<String, CRDInfo>>(existing);
        HashSet generated = new HashSet();
        if (this.needGeneration) {
            String outputDirName = this.crdConfiguration.outputDirectory;
            File outputDir = outputTarget.getOutputDirectory().resolve(outputDirName).toFile();
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                throw new IllegalArgumentException("Couldn't create " + outputDir.getAbsolutePath());
            }
            CRDGenerationInfo info = this.generator.forCRDVersions(this.crdConfiguration.versions).inOutputDir(outputDir).detailedGenerate();
            Map crdDetailsPerNameAndVersion = info.getCRDDetailsPerNameAndVersion();
            crdDetailsPerNameAndVersion.forEach((crdName, initialVersionToCRDInfoMap) -> {
                OperatorSDKProcessor.log.infov("Generated {0} CRD:", crdName);
                generated.add(crdName);
                Map<String, ResourceInfo> versions = this.crMappings.getResourceInfos((String)crdName);
                Map versionToCRDInfo = converted.computeIfAbsent((String)crdName, s -> new HashMap());
                initialVersionToCRDInfoMap.forEach((version, crdInfo) -> {
                    String filePath = crdInfo.getFilePath();
                    OperatorSDKProcessor.log.infov("  - {0} -> {1}", version, (Object)filePath);
                    versionToCRDInfo.put(version, new CRDInfo(crdInfo.getCrdName(), version, filePath, crdInfo.getDependentClassNames(), versions));
                });
            });
        }
        return new io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo(this.shouldApply(), validateCustomResources, converted, generated);
    }

    private boolean needsGeneration(Map<String, CRDInfo> existingCRDInfos, Set<String> changedClassNames, String targetCRName) {
        boolean[] generateCurrent = new boolean[]{true};
        this.crdConfiguration.versions.forEach(v -> {
            CRDInfo crd = (CRDInfo)existingCRDInfos.get(v);
            if (crd == null) {
                return;
            }
            if (changedClassNames != null && !changedClassNames.isEmpty()) {
                for (String changedClass : changedClassNames) {
                    if (!crd.getDependentClassNames().contains(changedClass)) continue;
                    return;
                }
            }
            OperatorSDKProcessor.log.infov("''{0}'' CRD generation was skipped for ''{1}'' because no changes impacting the CRD were detected", v, (Object)targetCRName);
            generateCurrent[0] = false;
        });
        return generateCurrent[0];
    }

    boolean scheduleForGenerationIfNeeded(CustomResourceAugmentedClassInfo crInfo, Map<String, CRDInfo> existingCRDInfos, Set<String> changedClasses) {
        boolean scheduleCurrent = true;
        String targetCRName = crInfo.asResourceTargeting().fullResourceName();
        if (existingCRDInfos != null && !existingCRDInfos.isEmpty()) {
            scheduleCurrent = this.needsGeneration(existingCRDInfos, changedClasses, targetCRName);
        }
        if (scheduleCurrent) {
            this.withCustomResource(crInfo.loadAssociatedClass(), targetCRName, crInfo.getAssociatedReconcilerName().orElse(null));
        }
        return scheduleCurrent;
    }

    public void withCustomResource(Class<? extends CustomResource> crClass, String crdName, String associatedControllerName) {
        try {
            CustomResourceInfo info = CustomResourceInfo.fromClass(crClass);
            this.crMappings.add(info, crdName, associatedControllerName);
            this.generator.customResources(new CustomResourceInfo[]{info});
            this.needGeneration = true;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot process " + crClass.getName() + " custom resource" + (String)(associatedControllerName != null ? " for controller '" + associatedControllerName + "'" : ""), e);
        }
    }
}

