/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.client.Version;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.LeaderElectionConfiguration;
import io.javaoperatorsdk.operator.api.monitoring.Metrics;
import io.quarkiverse.operatorsdk.common.AnnotationConfigurableAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ClassUtils;
import io.quarkiverse.operatorsdk.common.ConfigurationUtils;
import io.quarkiverse.operatorsdk.common.Constants;
import io.quarkiverse.operatorsdk.common.CustomResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconciledResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconcilerAugmentedClassInfo;
import io.quarkiverse.operatorsdk.deployment.AddClusterRolesDecorator;
import io.quarkiverse.operatorsdk.deployment.AddRoleBindingsDecorator;
import io.quarkiverse.operatorsdk.deployment.CRDGeneration;
import io.quarkiverse.operatorsdk.deployment.ConfigurationServiceBuildItem;
import io.quarkiverse.operatorsdk.deployment.ContextStoredCRDInfos;
import io.quarkiverse.operatorsdk.deployment.GeneratedCRDInfoBuildItem;
import io.quarkiverse.operatorsdk.deployment.QuarkusControllerConfigurationBuilder;
import io.quarkiverse.operatorsdk.runtime.AppEventListener;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.CRDConfiguration;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import io.quarkiverse.operatorsdk.runtime.CRDInfo;
import io.quarkiverse.operatorsdk.runtime.ConfigurationServiceRecorder;
import io.quarkiverse.operatorsdk.runtime.KubernetesClientSerializationCustomizer;
import io.quarkiverse.operatorsdk.runtime.NoOpMetricsProvider;
import io.quarkiverse.operatorsdk.runtime.OperatorHealthCheck;
import io.quarkiverse.operatorsdk.runtime.OperatorProducer;
import io.quarkiverse.operatorsdk.runtime.QuarkusConfigurationService;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.RunTimeOperatorConfiguration;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.bootstrap.app.ClassChangeInformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ForceNonWeakReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.kubernetes.client.spi.KubernetesClientBuildItem;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.Quarkus;
import io.quarkus.runtime.QuarkusApplication;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

class OperatorSDKProcessor {
    static final Logger log = Logger.getLogger((String)OperatorSDKProcessor.class.getName());
    private static final String FEATURE = "operator-sdk";
    private static final String DEFAULT_METRIC_BINDER_CLASS_NAME = "io.quarkiverse.operatorsdk.runtime.MicrometerMetricsProvider";
    private BuildTimeOperatorConfiguration buildTimeConfiguration;

    OperatorSDKProcessor() {
    }

    @BuildStep
    void setup(BuildProducer<IndexDependencyBuildItem> indexDependency, BuildProducer<FeatureBuildItem> features, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, Optional<MetricsCapabilityBuildItem> metricsCapability, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        features.produce((BuildItem)new FeatureBuildItem(FEATURE));
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("io.javaoperatorsdk", "operator-framework-core"));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{ObjectMapper.class}));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{Metrics.class}));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{LeaderElectionConfiguration.class}));
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(KubernetesClientSerializationCustomizer.class));
        if (metricsCapability.map(m -> m.metricsSupported("micrometer")).orElse(false).booleanValue()) {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)DEFAULT_METRIC_BINDER_CLASS_NAME));
        } else {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(NoOpMetricsProvider.class));
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(OperatorHealthCheck.class));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void updateControllerConfigurations(ConfigurationServiceRecorder recorder, RunTimeOperatorConfiguration runTimeConfiguration, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, GeneratedCRDInfoBuildItem generatedCRDs, ConfigurationServiceBuildItem serviceBuildItem, LaunchModeBuildItem launchMode) {
        Supplier supplier = recorder.configurationServiceSupplier(serviceBuildItem.getVersion(), serviceBuildItem.getControllerConfigs(), generatedCRDs.getCRDGenerationInfo(), runTimeConfiguration, this.buildTimeConfiguration, launchMode.getLaunchMode());
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(QuarkusConfigurationService.class).scope(Singleton.class)).addType(ConfigurationService.class)).setRuntimeInit().supplier(supplier).done());
    }

    private void checkVersionCompatibility(String found, String expected, String name) {
        if (!found.equals(expected)) {
            String message = "Incompatible " + name + " version found: \"" + found + "\", expected: \"" + expected + "\"";
            if (this.buildTimeConfiguration.failOnVersionCheck.booleanValue()) {
                throw new RuntimeException(message);
            }
            log.warn((Object)message);
        }
    }

    @BuildStep
    ConfigurationServiceBuildItem createConfigurationServiceAndOperator(OutputTargetBuildItem outputTarget, CombinedIndexBuildItem combinedIndexBuildItem, KubernetesClientBuildItem kubernetesClientBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectionClasses, BuildProducer<ForceNonWeakReflectiveClassBuildItem> forcedReflectionClasses, BuildProducer<GeneratedCRDInfoBuildItem> generatedCRDInfo, LiveReloadBuildItem liveReload, LaunchModeBuildItem launchMode, BuildProducer<RunTimeConfigurationDefaultBuildItem> runtimeConfig) {
        io.quarkiverse.operatorsdk.runtime.Version version = io.quarkiverse.operatorsdk.runtime.Version.loadFromProperties();
        String runtimeQuarkusVersion = Quarkus.class.getPackage().getImplementationVersion();
        this.checkVersionCompatibility(runtimeQuarkusVersion, version.getQuarkusVersion(), "Quarkus");
        String runtimeFabric8Version = Version.clientVersion();
        this.checkVersionCompatibility(runtimeFabric8Version, version.getKubernetesClientVersion(), "JOSDK Fabric8 Kubernetes Client");
        CRDConfiguration crdConfig = this.buildTimeConfiguration.crd;
        boolean validateCustomResources = ConfigurationUtils.shouldValidateCustomResources((boolean)this.buildTimeConfiguration.crd.validate);
        LaunchMode mode = launchMode.getLaunchMode();
        CRDGeneration crdGeneration = new CRDGeneration(crdConfig, mode);
        IndexView index = combinedIndexBuildItem.getIndex();
        HashSet<String> registerForReflection = new HashSet<String>();
        Map configurableInfos = ClassUtils.getProcessableImplementationsOf((DotName)Constants.ANNOTATION_CONFIGURABLE, (IndexView)index, (Logger)log, Collections.emptyMap()).map(AnnotationConfigurableAugmentedClassInfo.class::cast).peek(ci -> registerForReflection.addAll(ci.getClassNamesToRegisterForReflection())).collect(Collectors.toMap(ac -> ac.classInfo().name().toString(), Function.identity()));
        index.getAnnotations(Constants.CONFIGURED).forEach(ai -> registerForReflection.add(ai.value("with").asClass().name().toString()));
        ContextStoredCRDInfos stored = (ContextStoredCRDInfos)liveReload.getContextObject(ContextStoredCRDInfos.class);
        if (stored == null) {
            stored = new ContextStoredCRDInfos();
        }
        ContextStoredCRDInfos storedCRDInfos = stored;
        Set changedClasses = liveReload.isLiveReload() ? Optional.ofNullable(liveReload.getChangeInformation()).map(ClassChangeInformation::getChangedClasses).orElse(Collections.emptySet()) : Collections.emptySet();
        boolean wantCRDGenerated = crdGeneration.wantCRDGenerated();
        HashSet scheduledForGeneration = new HashSet(7);
        QuarkusControllerConfigurationBuilder builder = new QuarkusControllerConfigurationBuilder(additionalBeans, index, liveReload, this.buildTimeConfiguration);
        List<QuarkusControllerConfiguration> controllerConfigs = ClassUtils.getKnownReconcilers((IndexView)index, (Logger)log).map(raci -> {
            registerForReflection.addAll(raci.getClassNamesToRegisterForReflection());
            ClassChangeInformation changeInformation = liveReload.getChangeInformation();
            if (wantCRDGenerated && raci.associatedResourceInfo().isCR()) {
                ReconciledResourceAugmentedClassInfo crInfo = raci.associatedResourceInfo().asResourceTargeting();
                Map<String, CRDInfo> crdInfos = Collections.emptyMap();
                String targetCRName = crInfo.fullResourceName();
                if (liveReload.isLiveReload()) {
                    crdInfos = storedCRDInfos.getCRDInfosFor(targetCRName);
                }
                if (crdGeneration.scheduleForGenerationIfNeeded((CustomResourceAugmentedClassInfo)crInfo, crdInfos, changedClasses)) {
                    scheduledForGeneration.add(targetCRName);
                }
            }
            QuarkusControllerConfiguration configuration = builder.build((ReconcilerAugmentedClassInfo)raci, configurableInfos);
            String namespaces = String.join((CharSequence)",", configuration.getNamespaces());
            runtimeConfig.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("quarkus.operator-sdk.controllers." + configuration.getName() + ".namespaces", namespaces));
            return configuration;
        }).collect(Collectors.toList());
        if (wantCRDGenerated && crdConfig.generateAll.booleanValue()) {
            ClassUtils.getProcessableSubClassesOf((DotName)Constants.CUSTOM_RESOURCE, (IndexView)index, (Logger)log, Map.of("existing-crds-key", scheduledForGeneration)).map(CustomResourceAugmentedClassInfo.class::cast).forEach(cr -> {
                String targetCRName = cr.fullResourceName();
                crdGeneration.withCustomResource(cr.loadAssociatedClass(), targetCRName, null);
                log.infov("Will generate CRD for non-reconciler bound resource: {0}", (Object)targetCRName);
            });
        }
        CRDGenerationInfo crdInfo = crdGeneration.generate(outputTarget, validateCustomResources, storedCRDInfos.getExisting());
        Map generatedCRDs = crdInfo.getCrds();
        storedCRDInfos.putAll(generatedCRDs);
        liveReload.setContextObject(ContextStoredCRDInfos.class, (Object)storedCRDInfos);
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(OperatorProducer.class));
        if (index.getAllKnownImplementors(DotName.createSimple((String)QuarkusApplication.class.getName())).isEmpty()) {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(AppEventListener.class).setDefaultScope(DotName.createSimple((String)Singleton.class.getName())).setUnremovable().build());
        }
        this.registerAssociatedClassesForReflection(reflectionClasses, forcedReflectionClasses, registerForReflection);
        generatedCRDInfo.produce((BuildItem)new GeneratedCRDInfoBuildItem(crdInfo));
        return new ConfigurationServiceBuildItem(version, controllerConfigs);
    }

    private void registerAssociatedClassesForReflection(BuildProducer<ReflectiveClassBuildItem> reflectionClasses, BuildProducer<ForceNonWeakReflectiveClassBuildItem> forcedReflectionClasses, Set<String> classNamesToRegister) {
        classNamesToRegister.forEach(cn -> {
            reflectionClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{cn}));
            forcedReflectionClasses.produce((BuildItem)new ForceNonWeakReflectiveClassBuildItem(cn));
            log.infov("Registered ''{0}'' for reflection", cn);
        });
    }

    @BuildStep(onlyIf={IsRBACEnabled.class})
    public void addRBACForResources(BuildProducer<DecoratorBuildItem> decorators, ConfigurationServiceBuildItem configurations) {
        Map<String, QuarkusControllerConfiguration> configs = configurations.getControllerConfigs();
        decorators.produce((BuildItem)new DecoratorBuildItem((Object)new AddClusterRolesDecorator(configs, this.buildTimeConfiguration.crd.validate)));
        decorators.produce((BuildItem)new DecoratorBuildItem((Object)new AddRoleBindingsDecorator(configs, this.buildTimeConfiguration.crd.validate)));
    }

    private ResultHandle getHandleFromCDI(MethodCreator mc, MethodDescriptor selectMethod, MethodDescriptor getMethod, AssignableResultHandle cdiVar, Class<?> handleClass, String optionalImplClass) {
        ResultHandle operatorInstance = mc.invokeVirtualMethod(selectMethod, (ResultHandle)cdiVar, new ResultHandle[]{optionalImplClass != null ? mc.loadClass(optionalImplClass) : mc.loadClass(handleClass), mc.newArray(Annotation.class, 0)});
        return mc.checkCast(mc.invokeInterfaceMethod(getMethod, operatorInstance, new ResultHandle[0]), handleClass);
    }

    private static class IsRBACEnabled
    implements BooleanSupplier {
        private BuildTimeOperatorConfiguration config;

        private IsRBACEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.config.disableRbacGeneration == false;
        }
    }
}

