/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.dependent.ConfigurationConverter;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceConfigurationResolver;
import io.javaoperatorsdk.operator.api.reconciler.Constants;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentConverter;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResourceConfig;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Condition;
import io.javaoperatorsdk.operator.processing.dependent.workflow.ManagedWorkflow;
import io.javaoperatorsdk.operator.processing.dependent.workflow.ManagedWorkflowFactory;
import io.javaoperatorsdk.operator.processing.event.rate.RateLimiter;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceEventFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.GenericFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnAddFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import io.javaoperatorsdk.operator.processing.retry.GenericRetry;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import io.quarkiverse.operatorsdk.common.AnnotationConfigurableAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ClassLoadingUtils;
import io.quarkiverse.operatorsdk.common.ConfigurationUtils;
import io.quarkiverse.operatorsdk.common.DependentResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconciledAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconciledResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconcilerAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.SelectiveAugmentedClassInfo;
import io.quarkiverse.operatorsdk.deployment.BuildTimeHybridControllerConfiguration;
import io.quarkiverse.operatorsdk.deployment.ContextStoredControllerConfigurations;
import io.quarkiverse.operatorsdk.runtime.BuildTimeControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.DependentResourceSpecMetadata;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.QuarkusKubernetesDependentResourceConfig;
import io.quarkiverse.operatorsdk.runtime.QuarkusManagedWorkflow;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.bootstrap.app.ClassChangeInformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class QuarkusControllerConfigurationBuilder {
    static final Logger log = Logger.getLogger((String)QuarkusControllerConfigurationBuilder.class.getName());
    private static final KubernetesDependentConverter KUBERNETES_DEPENDENT_CONVERTER = new KubernetesDependentConverter(){

        public KubernetesDependentResourceConfig configFrom(KubernetesDependent configAnnotation, ControllerConfiguration parentConfiguration, Class originatingClass) {
            KubernetesDependentResourceConfig original = super.configFrom(configAnnotation, parentConfiguration, originatingClass);
            return new QuarkusKubernetesDependentResourceConfig(original.namespaces(), original.labelSelector(), original.wereNamespacesConfigured(), original.getResourceDiscriminator(), original.onAddFilter(), original.onUpdateFilter(), original.onDeleteFilter(), original.genericFilter());
        }
    };
    private final BuildProducer<AdditionalBeanBuildItem> additionalBeans;
    private final IndexView index;
    private final LiveReloadBuildItem liveReload;
    private final BuildTimeOperatorConfiguration buildTimeConfiguration;

    public QuarkusControllerConfigurationBuilder(BuildProducer<AdditionalBeanBuildItem> additionalBeans, IndexView index, LiveReloadBuildItem liveReload, BuildTimeOperatorConfiguration buildTimeConfiguration) {
        this.additionalBeans = additionalBeans;
        this.index = index;
        this.liveReload = liveReload;
        this.buildTimeConfiguration = buildTimeConfiguration;
    }

    QuarkusControllerConfiguration build(ReconcilerAugmentedClassInfo reconcilerInfo, Map<String, AnnotationConfigurableAugmentedClassInfo> configurableInfos) {
        ClassInfo info = reconcilerInfo.classInfo();
        String reconcilerClassName = info.toString();
        String name = reconcilerInfo.nameOrFailIfUnset();
        this.additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(reconcilerClassName).setUnremovable().setDefaultScope(DotNames.APPLICATION_SCOPED).build());
        ClassChangeInformation changeInformation = this.liveReload.getChangeInformation();
        QuarkusControllerConfiguration configuration = null;
        ContextStoredControllerConfigurations storedConfigurations = (ContextStoredControllerConfigurations)this.liveReload.getContextObject(ContextStoredControllerConfigurations.class);
        if (this.liveReload.isLiveReload() && storedConfigurations != null) {
            Set changedClasses = changeInformation == null ? Collections.emptySet() : changeInformation.getChangedClasses();
            Set changedResources = this.liveReload.getChangedResources();
            configuration = storedConfigurations.configurationOrNullIfNeedGeneration(reconcilerClassName, changedClasses, changedResources);
        }
        if (configuration == null) {
            ManagedWorkflow workflow;
            boolean wereNamespacesSet;
            Set namespaces;
            Type[] eventFilterTypes;
            AnnotationInstance controllerAnnotation = info.declaredAnnotation(io.quarkiverse.operatorsdk.common.Constants.CONTROLLER_CONFIGURATION);
            BuildTimeHybridControllerConfiguration configExtractor = new BuildTimeHybridControllerConfiguration(this.buildTimeConfiguration, (BuildTimeControllerConfiguration)this.buildTimeConfiguration.controllers.get(name), controllerAnnotation);
            ResourceEventFilter finalFilter = null;
            for (Type filterType : eventFilterTypes = (Type[])ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"eventFilters", AnnotationValue::asClassArray, () -> new Type[0])) {
                Class filterClass = ClassLoadingUtils.loadClass((String)filterType.name().toString(), ResourceEventFilter.class);
                ResourceEventFilter filter = (ResourceEventFilter)ClassLoadingUtils.instantiate((Class)filterClass);
                finalFilter = finalFilter == null ? filter : finalFilter.and(filter);
            }
            Duration maxReconciliationInterval = null;
            OnAddFilter onAddFilter = null;
            OnUpdateFilter onUpdateFilter = null;
            GenericFilter genericFilter = null;
            Class retryClass = GenericRetry.class;
            Class<?> retryConfigurationClass = null;
            Class rateLimiterClass = QuarkusControllerConfiguration.DefaultRateLimiter.class;
            Class<?> rateLimiterConfigurationClass = null;
            if (controllerAnnotation != null) {
                AnnotationInstance intervalFromAnnotation = (AnnotationInstance)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"maxReconciliationInterval", AnnotationValue::asNested, () -> null);
                Long interval = (Long)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)intervalFromAnnotation, (String)"interval", AnnotationValue::asLong, () -> 10L);
                TimeUnit timeUnit = (TimeUnit)((Object)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)intervalFromAnnotation, (String)"timeUnit", av -> TimeUnit.valueOf(av.asEnum()), () -> TimeUnit.HOURS));
                if (interval > 0L) {
                    maxReconciliationInterval = Duration.of(interval, timeUnit.toChronoUnit());
                }
                onAddFilter = (OnAddFilter)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)controllerAnnotation, (String)"onAddFilter", OnAddFilter.class, OnAddFilter.class, (boolean)true, (IndexView)this.index);
                onUpdateFilter = (OnUpdateFilter)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)controllerAnnotation, (String)"onUpdateFilter", OnUpdateFilter.class, OnUpdateFilter.class, (boolean)true, (IndexView)this.index);
                genericFilter = (GenericFilter)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)controllerAnnotation, (String)"genericFilter", GenericFilter.class, GenericFilter.class, (boolean)true, (IndexView)this.index);
                retryClass = (Class)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"retry", av -> ClassLoadingUtils.loadClass((String)av.asClass().name().toString(), Retry.class), () -> GenericRetry.class);
                AnnotationConfigurableAugmentedClassInfo retryConfigurableInfo = configurableInfos.get(retryClass.getName());
                retryConfigurationClass = QuarkusControllerConfigurationBuilder.getConfigurationAnnotationClass((SelectiveAugmentedClassInfo)reconcilerInfo, retryConfigurableInfo);
                rateLimiterClass = (Class)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"rateLimiter", av -> ClassLoadingUtils.loadClass((String)av.asClass().name().toString(), RateLimiter.class), () -> QuarkusControllerConfiguration.DefaultRateLimiter.class);
                AnnotationConfigurableAugmentedClassInfo rateLimiterConfigurableInfo = configurableInfos.get(rateLimiterClass.getName());
                rateLimiterConfigurationClass = QuarkusControllerConfigurationBuilder.getConfigurationAnnotationClass((SelectiveAugmentedClassInfo)reconcilerInfo, rateLimiterConfigurableInfo);
            }
            if ((namespaces = configExtractor.namespaces()) == null) {
                namespaces = Constants.DEFAULT_NAMESPACES_SET;
                wereNamespacesSet = false;
            } else {
                wereNamespacesSet = true;
            }
            ReconciledAugmentedClassInfo primaryInfo = reconcilerInfo.associatedResourceInfo();
            ReconciledResourceAugmentedClassInfo primaryAsResource = primaryInfo.asResourceTargeting();
            Class resourceClass = primaryInfo.loadAssociatedClass();
            String resourceFullName = primaryAsResource.fullResourceName();
            Collection dependentResourceInfos = reconcilerInfo.getDependentResourceInfos();
            boolean hasDependents = !dependentResourceInfos.isEmpty();
            Map dependentResources = hasDependents ? new HashMap(dependentResourceInfos.size()) : Collections.emptyMap();
            configuration = new QuarkusControllerConfiguration(reconcilerClassName, name, resourceFullName, primaryAsResource.version(), configExtractor.generationAware(), resourceClass, namespaces, wereNamespacesSet, this.getFinalizer(controllerAnnotation, resourceFullName), this.getLabelSelector(controllerAnnotation), primaryAsResource.hasNonVoidStatus(), finalFilter, maxReconciliationInterval, onAddFilter, onUpdateFilter, genericFilter, retryClass, retryConfigurationClass, rateLimiterClass, rateLimiterConfigurationClass, dependentResources, null);
            if (hasDependents) {
                QuarkusControllerConfiguration finalConfiguration = configuration;
                dependentResourceInfos.forEach(dependent -> {
                    DependentResourceSpecMetadata spec = this.createDependentResourceSpec((DependentResourceAugmentedClassInfo)dependent, this.index, finalConfiguration);
                    DotName dependentName = dependent.classInfo().name();
                    dependentResources.put(dependentName.toString(), spec);
                    String dependentTypeName = dependentName.toString();
                    this.additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(dependentTypeName).setUnremovable().setDefaultScope(DotNames.APPLICATION_SCOPED).build());
                });
            }
            if (hasDependents) {
                ManagedWorkflow original = ManagedWorkflowFactory.DEFAULT.workflowFor((ControllerConfiguration)configuration);
                workflow = new QuarkusManagedWorkflow(original.getOrderedSpecs(), original.hasCleaner());
            } else {
                workflow = QuarkusManagedWorkflow.noOpManagedWorkflow;
            }
            configuration.setWorkflow(workflow);
            log.infov("Processed ''{0}'' reconciler named ''{1}'' for ''{2}'' resource (version ''{3}'')", new Object[]{reconcilerClassName, name, resourceFullName, HasMetadata.getApiVersion((Class)resourceClass)});
        } else {
            log.infov("Skipped configuration reload for ''{0}'' reconciler as no changes were detected", (Object)reconcilerClassName);
            if (configuration.needsDependentBeansCreation()) {
                log.debugv("Created dependent beans for ''{0}'' reconciler", (Object)reconcilerClassName);
                reconcilerInfo.getDependentResourceInfos().forEach(dependent -> this.additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(dependent.classInfo().name().toString()).setUnremovable().setDefaultScope(DotNames.APPLICATION_SCOPED).build()));
            }
        }
        if (storedConfigurations == null) {
            storedConfigurations = new ContextStoredControllerConfigurations();
        }
        storedConfigurations.recordConfiguration(configuration);
        this.liveReload.setContextObject(ContextStoredControllerConfigurations.class, (Object)storedConfigurations);
        return configuration;
    }

    private static Class<?> getConfigurationAnnotationClass(SelectiveAugmentedClassInfo configurationTargetInfo, AnnotationConfigurableAugmentedClassInfo configurableInfo) {
        if (configurableInfo != null) {
            DotName associatedConfigurationClass = configurableInfo.getAssociatedConfigurationClass();
            if (configurationTargetInfo.classInfo().annotationsMap().containsKey(associatedConfigurationClass)) {
                return ClassLoadingUtils.loadClass((String)associatedConfigurationClass.toString(), Object.class);
            }
        }
        return null;
    }

    private DependentResourceSpecMetadata createDependentResourceSpec(DependentResourceAugmentedClassInfo dependent, IndexView index, QuarkusControllerConfiguration configuration) {
        ClassInfo dependentResourceType = dependent.classInfo();
        DotName drTypeName = dependentResourceType.name();
        List types = JandexUtil.resolveTypeParameters((DotName)drTypeName, (DotName)io.quarkiverse.operatorsdk.common.Constants.DEPENDENT_RESOURCE, (IndexView)index);
        if (types.size() != 2) {
            throw new IllegalArgumentException("Improperly parameterized DependentResource implementation: " + drTypeName.toString());
        }
        String resourceTypeName = ((Type)types.get(0)).name().toString();
        String dependentTypeName = drTypeName.toString();
        Class dependentClass = ClassLoadingUtils.loadClass((String)dependentTypeName, DependentResource.class);
        Object cfg = DependentResourceConfigurationResolver.extractConfigurationFromConfigured((Class)dependentClass, (ControllerConfiguration)configuration);
        AnnotationInstance dependentConfig = dependent.getDependentAnnotationFromController();
        AnnotationValue dependsOnField = dependentConfig.value("dependsOn");
        Set dependsOn = Optional.ofNullable(dependsOnField).map(AnnotationValue::asStringArray).filter(array -> ((String[])array).length > 0).map(Set::of).orElse(Collections.emptySet());
        Condition readyCondition = (Condition)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)dependentConfig, (String)"readyPostcondition", Condition.class, Condition.class, (boolean)true, (IndexView)index);
        Condition reconcilePrecondition = (Condition)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)dependentConfig, (String)"reconcilePrecondition", Condition.class, Condition.class, (boolean)true, (IndexView)index);
        Condition deletePostcondition = (Condition)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)dependentConfig, (String)"deletePostcondition", Condition.class, Condition.class, (boolean)true, (IndexView)index);
        String useEventSourceWithName = (String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)dependentConfig, (String)"useEventSourceWithName", AnnotationValue::asString, () -> null);
        return new DependentResourceSpecMetadata(dependentClass, cfg, dependent.nameOrFailIfUnset(), dependsOn, readyCondition, reconcilePrecondition, deletePostcondition, useEventSourceWithName, resourceTypeName);
    }

    private String getFinalizer(AnnotationInstance controllerAnnotation, String crdName) {
        return (String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"finalizerName", AnnotationValue::asString, () -> ReconcilerUtils.getDefaultFinalizerName((String)crdName));
    }

    private String getLabelSelector(AnnotationInstance controllerAnnotation) {
        return (String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"labelSelector", AnnotationValue::asString, () -> null);
    }

    static {
        DependentResourceConfigurationResolver.registerConverter(KubernetesDependentResource.class, (ConfigurationConverter)KUBERNETES_DEPENDENT_CONVERTER);
    }
}

