/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.quarkiverse.operatorsdk.common.ClassUtils;
import io.quarkiverse.operatorsdk.common.ConfigurationUtils;
import io.quarkiverse.operatorsdk.common.Constants;
import io.quarkiverse.operatorsdk.common.CustomResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconciledAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconciledResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.deployment.CRDGeneration;
import io.quarkiverse.operatorsdk.deployment.ContextStoredCRDInfos;
import io.quarkiverse.operatorsdk.deployment.GeneratedCRDInfoBuildItem;
import io.quarkiverse.operatorsdk.deployment.ReconcilerInfosBuildItem;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.CRDConfiguration;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import io.quarkiverse.operatorsdk.runtime.CRDInfo;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.runtime.LaunchMode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

class CRDGenerationBuildStep {
    static final Logger log = Logger.getLogger((String)CRDGenerationBuildStep.class.getName());
    private BuildTimeOperatorConfiguration operatorConfiguration;

    CRDGenerationBuildStep() {
    }

    @BuildStep
    GeneratedCRDInfoBuildItem generateCRDs(ReconcilerInfosBuildItem reconcilers, LaunchModeBuildItem launchModeBuildItem, LiveReloadBuildItem liveReload, OutputTargetBuildItem outputTarget, CombinedIndexBuildItem combinedIndexBuildItem) {
        CRDConfiguration crdConfig = this.operatorConfiguration.crd;
        boolean validateCustomResources = ConfigurationUtils.shouldValidateCustomResources((boolean)crdConfig.validate);
        LaunchMode launchMode = launchModeBuildItem.getLaunchMode();
        CRDGeneration crdGeneration = new CRDGeneration(crdConfig, launchMode);
        ContextStoredCRDInfos stored = (ContextStoredCRDInfos)liveReload.getContextObject(ContextStoredCRDInfos.class);
        if (stored == null) {
            stored = new ContextStoredCRDInfos();
        }
        boolean generate = CRDGeneration.shouldGenerate(crdConfig.generate, crdConfig.apply, launchMode);
        ContextStoredCRDInfos storedCRDInfos = stored;
        Set changedClasses = ConfigurationUtils.getChangedClasses((LiveReloadBuildItem)liveReload);
        HashSet scheduledForGeneration = new HashSet(7);
        if (generate) {
            reconcilers.getReconcilers().values().forEach(raci -> {
                ReconciledAugmentedClassInfo associatedResource = raci.associatedResourceInfo();
                if (associatedResource.isCR()) {
                    ReconciledResourceAugmentedClassInfo crInfo = associatedResource.asResourceTargeting();
                    String targetCRName = crInfo.fullResourceName();
                    if (!this.operatorConfiguration.isControllerOwningPrimary(raci.nameOrFailIfUnset())) {
                        scheduledForGeneration.add(targetCRName);
                    } else {
                        Map<String, CRDInfo> crdInfos = Collections.emptyMap();
                        if (liveReload.isLiveReload()) {
                            crdInfos = storedCRDInfos.getCRDInfosFor(targetCRName);
                        }
                        if (crdGeneration.scheduleForGenerationIfNeeded((CustomResourceAugmentedClassInfo)crInfo, crdInfos, changedClasses)) {
                            scheduledForGeneration.add(targetCRName);
                        }
                    }
                }
            });
            if (crdConfig.generateAll.booleanValue()) {
                ClassUtils.getProcessableSubClassesOf((DotName)Constants.CUSTOM_RESOURCE, (IndexView)combinedIndexBuildItem.getIndex(), (Logger)log, Map.of("existing-crds-key", scheduledForGeneration)).map(CustomResourceAugmentedClassInfo.class::cast).forEach(cr -> {
                    String targetCRName = cr.fullResourceName();
                    crdGeneration.withCustomResource(cr.loadAssociatedClass(), targetCRName, null);
                    log.infov("Will generate CRD for non-reconciler bound resource: {0}", (Object)targetCRName);
                });
            }
        }
        CRDGenerationInfo crdInfo = crdGeneration.generate(outputTarget, validateCustomResources, storedCRDInfos.getExisting());
        Map generatedCRDs = crdInfo.getCrds();
        storedCRDInfos.putAll(generatedCRDs);
        liveReload.setContextObject(ContextStoredCRDInfos.class, (Object)storedCRDInfos);
        return new GeneratedCRDInfoBuildItem(crdInfo);
    }
}

