/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import io.fabric8.kubernetes.api.model.rbac.PolicyRuleBuilder;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.dependent.ConfigurationConverter;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceConfigurationResolver;
import io.javaoperatorsdk.operator.api.reconciler.Constants;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentConverter;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResourceConfig;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Condition;
import io.javaoperatorsdk.operator.processing.dependent.workflow.ManagedWorkflow;
import io.javaoperatorsdk.operator.processing.dependent.workflow.ManagedWorkflowFactory;
import io.javaoperatorsdk.operator.processing.event.rate.RateLimiter;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceEventFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.GenericFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnAddFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import io.javaoperatorsdk.operator.processing.retry.GenericRetry;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import io.quarkiverse.operatorsdk.common.AnnotationConfigurableAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ClassLoadingUtils;
import io.quarkiverse.operatorsdk.common.ConfigurationUtils;
import io.quarkiverse.operatorsdk.common.DependentResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconciledAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconciledResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconcilerAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.SelectiveAugmentedClassInfo;
import io.quarkiverse.operatorsdk.deployment.AnnotationConfigurablesBuildItem;
import io.quarkiverse.operatorsdk.deployment.BuildTimeHybridControllerConfiguration;
import io.quarkiverse.operatorsdk.deployment.ContextStoredControllerConfigurations;
import io.quarkiverse.operatorsdk.deployment.ControllerConfigurationsBuildItem;
import io.quarkiverse.operatorsdk.deployment.ReconcilerInfosBuildItem;
import io.quarkiverse.operatorsdk.runtime.BuildTimeControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.DependentResourceSpecMetadata;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.QuarkusKubernetesDependentResourceConfig;
import io.quarkiverse.operatorsdk.runtime.QuarkusManagedWorkflow;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class QuarkusControllerConfigurationBuildStep {
    static final Logger log = Logger.getLogger((String)QuarkusControllerConfigurationBuildStep.class.getName());
    private static final KubernetesDependentConverter KUBERNETES_DEPENDENT_CONVERTER = new KubernetesDependentConverter(){

        public KubernetesDependentResourceConfig configFrom(KubernetesDependent configAnnotation, ControllerConfiguration parentConfiguration, Class originatingClass) {
            KubernetesDependentResourceConfig original = super.configFrom(configAnnotation, parentConfiguration, originatingClass);
            return new QuarkusKubernetesDependentResourceConfig(original.namespaces(), original.labelSelector(), original.wereNamespacesConfigured(), original.getResourceDiscriminator(), original.onAddFilter(), original.onUpdateFilter(), original.onDeleteFilter(), original.genericFilter());
        }
    };

    QuarkusControllerConfigurationBuildStep() {
    }

    @BuildStep
    ControllerConfigurationsBuildItem createControllerConfigurations(ReconcilerInfosBuildItem reconcilers, AnnotationConfigurablesBuildItem annotationConfigurables, BuildTimeOperatorConfiguration buildTimeConfiguration, CombinedIndexBuildItem combinedIndexBuildItem, LiveReloadBuildItem liveReload) {
        ContextStoredControllerConfigurations maybeStoredConfigurations = (ContextStoredControllerConfigurations)liveReload.getContextObject(ContextStoredControllerConfigurations.class);
        ContextStoredControllerConfigurations storedConfigurations = maybeStoredConfigurations != null ? maybeStoredConfigurations : new ContextStoredControllerConfigurations();
        liveReload.setContextObject(ContextStoredControllerConfigurations.class, (Object)storedConfigurations);
        Set changedClasses = ConfigurationUtils.getChangedClasses((LiveReloadBuildItem)liveReload);
        Set changedResources = liveReload.getChangedResources();
        List<QuarkusControllerConfiguration> collect = reconcilers.getReconcilers().values().stream().map(reconcilerInfo -> {
            ClassInfo info = reconcilerInfo.classInfo();
            String reconcilerClassName = info.toString();
            QuarkusControllerConfiguration configuration = null;
            if (liveReload.isLiveReload()) {
                configuration = storedConfigurations.configurationOrNullIfNeedGeneration(reconcilerClassName, changedClasses, changedResources);
            }
            if (configuration == null) {
                configuration = QuarkusControllerConfigurationBuildStep.createConfiguration(reconcilerInfo, annotationConfigurables.getConfigurableInfos(), buildTimeConfiguration, combinedIndexBuildItem.getIndex());
            }
            storedConfigurations.recordConfiguration(configuration);
            return configuration;
        }).collect(Collectors.toList());
        liveReload.setContextObject(ContextStoredControllerConfigurations.class, (Object)storedConfigurations);
        return new ControllerConfigurationsBuildItem(collect);
    }

    static QuarkusControllerConfiguration createConfiguration(ReconcilerAugmentedClassInfo reconcilerInfo, Map<String, AnnotationConfigurableAugmentedClassInfo> configurableInfos, BuildTimeOperatorConfiguration buildTimeConfiguration, IndexView index) {
        ManagedWorkflow workflow;
        boolean wereNamespacesSet;
        Type[] eventFilterTypes;
        ClassInfo info = reconcilerInfo.classInfo();
        String reconcilerClassName = info.toString();
        String name = reconcilerInfo.nameOrFailIfUnset();
        AnnotationInstance controllerAnnotation = info.declaredAnnotation(io.quarkiverse.operatorsdk.common.Constants.CONTROLLER_CONFIGURATION);
        BuildTimeControllerConfiguration externalConfiguration = (BuildTimeControllerConfiguration)buildTimeConfiguration.controllers.get(name);
        BuildTimeHybridControllerConfiguration configExtractor = new BuildTimeHybridControllerConfiguration(buildTimeConfiguration, externalConfiguration, controllerAnnotation);
        ResourceEventFilter finalFilter = null;
        for (Type filterType : eventFilterTypes = (Type[])ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"eventFilters", AnnotationValue::asClassArray, () -> new Type[0])) {
            Class filterClass = ClassLoadingUtils.loadClass((String)filterType.name().toString(), ResourceEventFilter.class);
            ResourceEventFilter filter = (ResourceEventFilter)ClassLoadingUtils.instantiate((Class)filterClass);
            finalFilter = finalFilter == null ? filter : finalFilter.and(filter);
        }
        Duration maxReconciliationInterval = null;
        OnAddFilter onAddFilter = null;
        OnUpdateFilter onUpdateFilter = null;
        GenericFilter genericFilter = null;
        Class retryClass = GenericRetry.class;
        Class<?> retryConfigurationClass = null;
        Class rateLimiterClass = QuarkusControllerConfiguration.DefaultRateLimiter.class;
        Class<?> rateLimiterConfigurationClass = null;
        Long nullableInformerListLimit = null;
        if (controllerAnnotation != null) {
            AnnotationInstance intervalFromAnnotation = (AnnotationInstance)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"maxReconciliationInterval", AnnotationValue::asNested, () -> null);
            Long interval = (Long)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)intervalFromAnnotation, (String)"interval", AnnotationValue::asLong, () -> 10L);
            TimeUnit timeUnit = (TimeUnit)((Object)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)intervalFromAnnotation, (String)"timeUnit", av -> TimeUnit.valueOf(av.asEnum()), () -> TimeUnit.HOURS));
            if (interval > 0L) {
                maxReconciliationInterval = Duration.of(interval, timeUnit.toChronoUnit());
            }
            onAddFilter = (OnAddFilter)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)controllerAnnotation, (String)"onAddFilter", OnAddFilter.class, OnAddFilter.class, (boolean)true, (IndexView)index);
            onUpdateFilter = (OnUpdateFilter)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)controllerAnnotation, (String)"onUpdateFilter", OnUpdateFilter.class, OnUpdateFilter.class, (boolean)true, (IndexView)index);
            genericFilter = (GenericFilter)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)controllerAnnotation, (String)"genericFilter", GenericFilter.class, GenericFilter.class, (boolean)true, (IndexView)index);
            retryClass = (Class)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"retry", av -> ClassLoadingUtils.loadClass((String)av.asClass().name().toString(), Retry.class), () -> GenericRetry.class);
            AnnotationConfigurableAugmentedClassInfo retryConfigurableInfo = configurableInfos.get(retryClass.getName());
            retryConfigurationClass = QuarkusControllerConfigurationBuildStep.getConfigurationAnnotationClass((SelectiveAugmentedClassInfo)reconcilerInfo, retryConfigurableInfo);
            rateLimiterClass = (Class)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"rateLimiter", av -> ClassLoadingUtils.loadClass((String)av.asClass().name().toString(), RateLimiter.class), () -> QuarkusControllerConfiguration.DefaultRateLimiter.class);
            AnnotationConfigurableAugmentedClassInfo rateLimiterConfigurableInfo = configurableInfos.get(rateLimiterClass.getName());
            rateLimiterConfigurationClass = QuarkusControllerConfigurationBuildStep.getConfigurationAnnotationClass((SelectiveAugmentedClassInfo)reconcilerInfo, rateLimiterConfigurableInfo);
            nullableInformerListLimit = (Long)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"informerListLimit", AnnotationValue::asLong, () -> null);
        }
        List<PolicyRule> additionalRBACRules = QuarkusControllerConfigurationBuildStep.extractAdditionalRBACRules(info);
        Set<String> namespaces = null;
        if (controllerAnnotation != null) {
            namespaces = Optional.ofNullable(controllerAnnotation.value("namespaces")).map(v -> new HashSet<String>(Arrays.asList(v.asStringArray()))).orElse(null);
        }
        if (namespaces == null) {
            namespaces = Constants.DEFAULT_NAMESPACES_SET;
            wereNamespacesSet = false;
        } else {
            wereNamespacesSet = true;
        }
        Set<String> buildTimeNamespaces = configExtractor.generateWithWatchedNamespaces(wereNamespacesSet);
        if (buildTimeNamespaces != null) {
            namespaces = buildTimeNamespaces;
        }
        ReconciledAugmentedClassInfo primaryInfo = reconcilerInfo.associatedResourceInfo();
        ReconciledResourceAugmentedClassInfo primaryAsResource = primaryInfo.asResourceTargeting();
        Class resourceClass = primaryInfo.loadAssociatedClass();
        String resourceFullName = primaryAsResource.fullResourceName();
        Collection dependentResourceInfos = reconcilerInfo.getDependentResourceInfos();
        boolean hasDependents = !dependentResourceInfos.isEmpty();
        Map dependentResources = hasDependents ? new HashMap(dependentResourceInfos.size()) : Collections.emptyMap();
        QuarkusControllerConfiguration configuration = new QuarkusControllerConfiguration(reconcilerClassName, name, resourceFullName, primaryAsResource.version(), configExtractor.generationAware(), resourceClass, nullableInformerListLimit, namespaces, wereNamespacesSet, QuarkusControllerConfigurationBuildStep.getFinalizer(controllerAnnotation, resourceFullName), QuarkusControllerConfigurationBuildStep.getLabelSelector(controllerAnnotation), primaryAsResource.hasNonVoidStatus(), finalFilter, maxReconciliationInterval, onAddFilter, onUpdateFilter, genericFilter, retryClass, retryConfigurationClass, rateLimiterClass, rateLimiterConfigurationClass, dependentResources, null, additionalRBACRules);
        if (hasDependents) {
            dependentResourceInfos.forEach(dependent -> {
                DependentResourceSpecMetadata spec = QuarkusControllerConfigurationBuildStep.createDependentResourceSpec(dependent, index, configuration);
                DotName dependentName = dependent.classInfo().name();
                dependentResources.put(dependentName.toString(), spec);
            });
        }
        if (hasDependents) {
            ManagedWorkflow original = ManagedWorkflowFactory.DEFAULT.workflowFor((ControllerConfiguration)configuration);
            workflow = new QuarkusManagedWorkflow(original.getOrderedSpecs(), original.hasCleaner());
        } else {
            workflow = QuarkusManagedWorkflow.noOpManagedWorkflow;
        }
        configuration.setWorkflow(workflow);
        log.infov("Processed ''{0}'' reconciler named ''{1}'' for ''{2}'' resource (version ''{3}'')", new Object[]{reconcilerClassName, name, resourceFullName, HasMetadata.getApiVersion((Class)resourceClass)});
        return configuration;
    }

    private static List<PolicyRule> extractAdditionalRBACRules(ClassInfo info) {
        AnnotationInstance rbacRuleAnnotation;
        AnnotationInstance[] additionalRuleAnnotations = (AnnotationInstance[])ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)info.declaredAnnotation(io.quarkiverse.operatorsdk.common.Constants.ADDITIONAL_RBAC_RULES), (String)"value", AnnotationValue::asNestedArray, () -> null);
        List<PolicyRule> additionalRBACRules = Collections.emptyList();
        if (additionalRuleAnnotations != null && additionalRuleAnnotations.length > 0) {
            additionalRBACRules = new ArrayList<PolicyRule>(additionalRuleAnnotations.length);
            for (AnnotationInstance ruleAnnotation : additionalRuleAnnotations) {
                additionalRBACRules.add(QuarkusControllerConfigurationBuildStep.extractRule(ruleAnnotation));
            }
        }
        if ((rbacRuleAnnotation = info.declaredAnnotation(io.quarkiverse.operatorsdk.common.Constants.RBAC_RULE)) != null) {
            additionalRBACRules = List.of(QuarkusControllerConfigurationBuildStep.extractRule(rbacRuleAnnotation));
        }
        return additionalRBACRules;
    }

    private static PolicyRule extractRule(AnnotationInstance ruleAnnotation) {
        PolicyRuleBuilder builder = new PolicyRuleBuilder();
        builder.withApiGroups((String[])ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)ruleAnnotation, (String)"apiGroups", AnnotationValue::asStringArray, () -> null));
        builder.withVerbs((String[])ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)ruleAnnotation, (String)"verbs", AnnotationValue::asStringArray, () -> null));
        builder.withResources((String[])ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)ruleAnnotation, (String)"resources", AnnotationValue::asStringArray, () -> null));
        builder.withResourceNames((String[])ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)ruleAnnotation, (String)"resourceNames", AnnotationValue::asStringArray, () -> null));
        builder.withNonResourceURLs((String[])ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)ruleAnnotation, (String)"nonResourceURLs", AnnotationValue::asStringArray, () -> null));
        return builder.build();
    }

    private static Class<?> getConfigurationAnnotationClass(SelectiveAugmentedClassInfo configurationTargetInfo, AnnotationConfigurableAugmentedClassInfo configurableInfo) {
        if (configurableInfo != null) {
            DotName associatedConfigurationClass = configurableInfo.getAssociatedConfigurationClass();
            if (configurationTargetInfo.classInfo().annotationsMap().containsKey(associatedConfigurationClass)) {
                return ClassLoadingUtils.loadClass((String)associatedConfigurationClass.toString(), Object.class);
            }
        }
        return null;
    }

    private static DependentResourceSpecMetadata createDependentResourceSpec(DependentResourceAugmentedClassInfo dependent, IndexView index, QuarkusControllerConfiguration configuration) {
        ClassInfo dependentResourceType = dependent.classInfo();
        DotName drTypeName = dependentResourceType.name();
        List types = JandexUtil.resolveTypeParameters((DotName)drTypeName, (DotName)io.quarkiverse.operatorsdk.common.Constants.DEPENDENT_RESOURCE, (IndexView)index);
        if (types.size() != 2) {
            throw new IllegalArgumentException("Improperly parameterized DependentResource implementation: " + drTypeName.toString());
        }
        String resourceTypeName = ((Type)types.get(0)).name().toString();
        String dependentTypeName = drTypeName.toString();
        Class dependentClass = ClassLoadingUtils.loadClass((String)dependentTypeName, DependentResource.class);
        Object cfg = DependentResourceConfigurationResolver.extractConfigurationFromConfigured((Class)dependentClass, (ControllerConfiguration)configuration);
        AnnotationInstance dependentConfig = dependent.getDependentAnnotationFromController();
        AnnotationValue dependsOnField = dependentConfig.value("dependsOn");
        Set dependsOn = Optional.ofNullable(dependsOnField).map(AnnotationValue::asStringArray).filter(array -> ((String[])array).length > 0).map(Set::of).orElse(Collections.emptySet());
        Condition readyCondition = (Condition)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)dependentConfig, (String)"readyPostcondition", Condition.class, Condition.class, (boolean)true, (IndexView)index);
        Condition reconcilePrecondition = (Condition)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)dependentConfig, (String)"reconcilePrecondition", Condition.class, Condition.class, (boolean)true, (IndexView)index);
        Condition deletePostcondition = (Condition)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)dependentConfig, (String)"deletePostcondition", Condition.class, Condition.class, (boolean)true, (IndexView)index);
        String useEventSourceWithName = (String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)dependentConfig, (String)"useEventSourceWithName", AnnotationValue::asString, () -> null);
        return new DependentResourceSpecMetadata(dependentClass, cfg, dependent.nameOrFailIfUnset(), dependsOn, readyCondition, reconcilePrecondition, deletePostcondition, useEventSourceWithName, resourceTypeName);
    }

    private static String getFinalizer(AnnotationInstance controllerAnnotation, String crdName) {
        return (String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"finalizerName", AnnotationValue::asString, () -> ReconcilerUtils.getDefaultFinalizerName((String)crdName));
    }

    private static String getLabelSelector(AnnotationInstance controllerAnnotation) {
        return (String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"labelSelector", AnnotationValue::asString, () -> null);
    }

    static {
        DependentResourceConfigurationResolver.registerConverter(KubernetesDependentResource.class, (ConfigurationConverter)KUBERNETES_DEPENDENT_CONVERTER);
    }
}

