/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.fabric8.crd.generator.CustomResourceInfo;
import io.quarkiverse.operatorsdk.common.ClassUtils;
import io.quarkiverse.operatorsdk.runtime.ResourceInfo;
import java.util.HashMap;
import java.util.Map;

public class ResourceControllerMapping {
    private final Map<String, Map<String, ResourceInfo>> resourceFullNameToVersionToInfos = new HashMap<String, Map<String, ResourceInfo>>(7);

    public Map<String, ResourceInfo> getResourceInfos(String resourceFullName) {
        Map<String, ResourceInfo> infos = this.resourceFullNameToVersionToInfos.get(resourceFullName);
        if (infos == null) {
            throw new IllegalStateException("Should have information associated with '" + resourceFullName + "'");
        }
        return infos;
    }

    public void add(CustomResourceInfo info, String crdName, String associatedControllerName) {
        String version = info.version();
        Map versionsForCR = this.resourceFullNameToVersionToInfos.computeIfAbsent(crdName, s -> new HashMap());
        ResourceInfo cri = (ResourceInfo)versionsForCR.get(version);
        if (cri != null) {
            String msg = "Cannot add CustomResource '" + crdName + "' with version " + version + " for processing";
            if (associatedControllerName != null) {
                msg = msg + " by " + associatedControllerName;
            }
            msg = msg + " because it's already been added previously";
            String existing = cri.getControllerName();
            if (existing != null) {
                msg = msg + " to be processed by the controller named '" + existing + "'";
            }
            throw new IllegalStateException(msg);
        }
        ResourceInfo converted = ResourceControllerMapping.augment(info, crdName, associatedControllerName);
        versionsForCR.put(version, converted);
    }

    private static ResourceInfo augment(CustomResourceInfo info, String crdName, String associatedControllerName) {
        return new ResourceInfo(info.group(), info.version(), info.kind(), info.singular(), info.plural(), info.shortNames(), info.storage(), info.served(), info.scope(), info.crClassName(), info.statusClassName().map(ClassUtils::isStatusNotVoid).orElse(false).booleanValue(), crdName, associatedControllerName);
    }
}

