/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment.helm;

import io.dekorate.helm.model.Chart;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.quarkiverse.operatorsdk.common.FileUtils;
import io.quarkiverse.operatorsdk.common.GeneratedResourcesUtils;
import io.quarkiverse.operatorsdk.deployment.AddClusterRolesDecorator;
import io.quarkiverse.operatorsdk.deployment.ControllerConfigurationsBuildItem;
import io.quarkiverse.operatorsdk.deployment.GeneratedCRDInfoBuildItem;
import io.quarkiverse.operatorsdk.deployment.helm.DisableDefaultHelmListener;
import io.quarkiverse.operatorsdk.deployment.helm.Values;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.CRDInfo;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.kubernetes.spi.ConfiguratorBuildItem;
import io.quarkus.kubernetes.spi.GeneratedKubernetesResourceBuildItem;
import io.quarkus.qute.Qute;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class HelmChartProcessor {
    private static final Logger log = Logger.getLogger(HelmChartProcessor.class);
    private static final String TEMPLATES_DIR = "templates";
    private static final String HELM_TEMPLATES_STATIC_DIR = "/helm/static/";
    private static final String[] TEMPLATE_FILES = new String[]{"generic-crd-cluster-role.yaml", "generic-crd-cluster-role-binding.yaml", "service.yaml", "serviceaccount.yaml"};
    private static final String[] ROOT_STATIC_FILES = new String[]{"README.md", "values.schema.json"};
    public static final String CHART_YAML_FILENAME = "Chart.yaml";
    public static final String VALUES_YAML_FILENAME = "values.yaml";
    public static final String CRD_DIR = "crds";
    public static final String CRD_ROLE_BINDING_TEMPLATE_PATH = "/helm/crd-role-binding-template.yaml";

    @BuildStep
    public void handleHelmCharts(BuildProducer<ArtifactResultBuildItem> dummy, List<GeneratedKubernetesResourceBuildItem> generatedResources, ControllerConfigurationsBuildItem controllerConfigurations, BuildTimeOperatorConfiguration buildTimeConfiguration, GeneratedCRDInfoBuildItem generatedCRDInfoBuildItem, OutputTargetBuildItem outputTarget, ApplicationInfoBuildItem appInfo, ContainerImageInfoBuildItem containerImageInfoBuildItem) {
        if (buildTimeConfiguration.helm.enabled.booleanValue()) {
            File helmDir = outputTarget.getOutputDirectory().resolve("helm").toFile();
            log.infov("Generating helm chart to {0}", (Object)helmDir);
            Collection<QuarkusControllerConfiguration> controllerConfigs = controllerConfigurations.getControllerConfigs().values();
            this.createRelatedDirectories(helmDir);
            this.addTemplateFiles(helmDir);
            this.addClusterRolesForReconcilers(helmDir, controllerConfigs);
            this.addPrimaryClusterRoleBindings(helmDir, controllerConfigs);
            this.addGeneratedDeployment(helmDir, generatedResources, controllerConfigurations, appInfo);
            this.addChartYaml(helmDir, appInfo.getName(), appInfo.getVersion());
            this.addValuesYaml(helmDir, containerImageInfoBuildItem.getTag());
            this.addReadmeAndSchema(helmDir);
            this.addCRDs(new File(helmDir, CRD_DIR), generatedCRDInfoBuildItem);
        } else {
            log.debug((Object)"Generating helm chart is disabled");
        }
    }

    private void addTemplateFiles(File helmDir) {
        this.copyTemplates(helmDir.toPath().resolve(TEMPLATES_DIR), TEMPLATE_FILES);
    }

    private void addGeneratedDeployment(File helmDir, List<GeneratedKubernetesResourceBuildItem> generatedResources, ControllerConfigurationsBuildItem controllerConfigurations, ApplicationInfoBuildItem appInfo) {
        List resources = GeneratedResourcesUtils.loadFrom(generatedResources);
        Deployment deployment = (Deployment)resources.stream().filter(Deployment.class::isInstance).findFirst().orElseThrow();
        this.addActualNamespaceConfigPlaceholderToDeployment(deployment, controllerConfigurations);
        String template = FileUtils.asYaml((Object)deployment);
        String res = template.replace("\"{watchNamespaces}\"", "{{ .Values.watchNamespaces }}");
        res = res.replaceAll(appInfo.getVersion(), "{{ .Values.version }}");
        try {
            Files.writeString(Path.of(helmDir.getPath(), TEMPLATES_DIR, "deployment.yaml"), (CharSequence)res, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void addActualNamespaceConfigPlaceholderToDeployment(Deployment deployment, ControllerConfigurationsBuildItem controllerConfigurations) {
        controllerConfigurations.getControllerConfigs().values().forEach(c -> {
            List envs = ((Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getEnv();
            envs.add(new EnvVar("QUARKUS_OPERATOR_SDK_CONTROLLERS_" + c.getName().toUpperCase() + "_NAMESPACES", "{watchNamespaces}", null));
        });
    }

    private void addPrimaryClusterRoleBindings(File helmDir, Collection<QuarkusControllerConfiguration> controllerConfigs) {
        try (InputStream file = Thread.currentThread().getContextClassLoader().getResourceAsStream(CRD_ROLE_BINDING_TEMPLATE_PATH);){
            if (file == null) {
                throw new IllegalArgumentException("Template file /helm/crd-role-binding-template.yaml doesn't exist");
            }
            String template = new String(file.readAllBytes(), StandardCharsets.UTF_8);
            controllerConfigs.forEach(config -> {
                try {
                    String name = config.getName();
                    String res = Qute.fmt((String)template, Map.of("reconciler-name", name));
                    Files.writeString(Path.of(helmDir.getPath(), TEMPLATES_DIR, name + "-crd-role-binding.yaml"), (CharSequence)res, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void addClusterRolesForReconcilers(File helmDir, Collection<QuarkusControllerConfiguration> controllerConfigurations) {
        controllerConfigurations.forEach(cc -> {
            try {
                ClusterRole clusterRole = AddClusterRolesDecorator.createClusterRole(cc);
                String yaml = Serialization.asYaml((Object)clusterRole);
                Files.writeString(Path.of(helmDir.getPath(), TEMPLATES_DIR, cc.getName() + "-crd-cluster-role.yaml"), (CharSequence)yaml, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private void addCRDs(File crdDir, GeneratedCRDInfoBuildItem generatedCRDInfoBuildItem) {
        List<CRDInfo> crdInfos = generatedCRDInfoBuildItem.getCRDGenerationInfo().getCrds().values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toList());
        crdInfos.forEach(crdInfo -> {
            try {
                Path generateCrdPath = Path.of(crdInfo.getFilePath(), new String[0]);
                Files.copy(generateCrdPath, Path.of(crdDir.getPath(), generateCrdPath.getFileName().toString()), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private void addValuesYaml(File helmDir, String tag) {
        try {
            Values values = new Values();
            values.setVersion(tag);
            String valuesYaml = FileUtils.asYaml((Object)values);
            Files.writeString(Path.of(helmDir.getPath(), VALUES_YAML_FILENAME), (CharSequence)valuesYaml, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void addReadmeAndSchema(File helmDir) {
        this.copyTemplates(helmDir.toPath(), ROOT_STATIC_FILES);
    }

    private void addChartYaml(File helmDir, String name, String version) {
        try {
            Chart chart = new Chart();
            chart.setName(name);
            chart.setVersion(version);
            chart.setApiVersion("v2");
            String chartYaml = FileUtils.asYaml((Object)chart);
            Files.writeString(Path.of(helmDir.getPath(), CHART_YAML_FILENAME), (CharSequence)chartYaml, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void copyTemplates(Path path, String[] staticTemplateFiles) {
        for (String template : staticTemplateFiles) {
            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(HELM_TEMPLATES_STATIC_DIR + template);){
                if (is == null) {
                    throw new IllegalArgumentException("Template file " + template + " doesn't exist");
                }
                Files.copy(is, path.resolve(template), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void createRelatedDirectories(File helmDir) {
        FileUtils.ensureDirectoryExists((File)helmDir);
        FileUtils.ensureDirectoryExists((File)new File(helmDir, TEMPLATES_DIR));
        FileUtils.ensureDirectoryExists((File)new File(helmDir, CRD_DIR));
    }

    @BuildStep
    void disableDefaultHelmListener(BuildProducer<ConfiguratorBuildItem> helmConfiguration) {
        helmConfiguration.produce((BuildItem)new ConfiguratorBuildItem((Object)new DisableDefaultHelmListener()));
    }
}

