/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleFluent;
import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import io.fabric8.kubernetes.api.model.rbac.PolicyRuleBuilder;
import io.javaoperatorsdk.operator.api.reconciler.dependent.Deleter;
import io.javaoperatorsdk.operator.processing.dependent.Creator;
import io.javaoperatorsdk.operator.processing.dependent.Updater;
import io.quarkiverse.operatorsdk.annotations.RBACVerbs;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import java.util.Collection;
import java.util.Map;

public class AddClusterRolesDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    public static final String JOSDK_CRD_VALIDATING_CLUSTER_ROLE_NAME = "josdk-crd-validating-cluster-role";
    private static final ClusterRoleBuilder CRD_VALIDATING_CLUSTER_ROLE_BUILDER = (ClusterRoleBuilder)((ClusterRoleBuilder)((ClusterRoleFluent.MetadataNested)new ClusterRoleBuilder().withNewMetadata().withName("josdk-crd-validating-cluster-role")).endMetadata()).addToRules(new PolicyRule[]{((PolicyRuleBuilder)((PolicyRuleBuilder)((PolicyRuleBuilder)new PolicyRuleBuilder().addToApiGroups(new String[]{"apiextensions.k8s.io"})).addToResources(new String[]{"customresourcedefinitions"})).addToVerbs(new String[]{"get", "list"})).build()});
    private static final String CR_API_VERSION = HasMetadata.getApiVersion(ClusterRole.class);
    private static final String CR_KIND = HasMetadata.getKind(ClusterRole.class);
    private final Collection<QuarkusControllerConfiguration<?>> configs;
    private final boolean validateCRDs;

    public AddClusterRolesDecorator(Collection<QuarkusControllerConfiguration<?>> configs, boolean validateCRDs) {
        this.configs = configs;
        this.validateCRDs = validateCRDs;
    }

    public void visit(KubernetesListBuilder list) {
        this.configs.forEach(cri -> {
            ClusterRole clusterRole = AddClusterRolesDecorator.createClusterRole(cri);
            list.addToItems(new HasMetadata[]{clusterRole});
        });
        if (this.validateCRDs && !this.contains(list, CR_API_VERSION, CR_KIND, JOSDK_CRD_VALIDATING_CLUSTER_ROLE_NAME)) {
            list.addToItems((VisitableBuilder)CRD_VALIDATING_CLUSTER_ROLE_BUILDER);
        }
    }

    public static ClusterRole createClusterRole(QuarkusControllerConfiguration<?> cri) {
        PolicyRuleBuilder rule = new PolicyRuleBuilder();
        Class resourceClass = cri.getResourceClass();
        String plural = HasMetadata.getPlural((Class)resourceClass);
        rule.addToResources(new String[]{plural});
        if (cri.isStatusPresentAndNotVoid()) {
            rule.addToResources(new String[]{plural + "/status"});
        }
        rule.addToResources(new String[]{plural + "/finalizers"});
        ((PolicyRuleBuilder)((PolicyRuleBuilder)rule.addToApiGroups(new String[]{HasMetadata.getGroup((Class)resourceClass)})).addToVerbs(RBACVerbs.ALL_COMMON_VERBS)).build();
        ClusterRoleBuilder clusterRoleBuilder = (ClusterRoleBuilder)((ClusterRoleBuilder)((ClusterRoleFluent.MetadataNested)new ClusterRoleBuilder().withNewMetadata().withName(AddClusterRolesDecorator.getClusterRoleName(cri.getName()))).endMetadata()).addToRules(new PolicyRule[]{rule.build()});
        Map dependentsMetadata = cri.getDependentsMetadata();
        dependentsMetadata.forEach((name, spec) -> {
            Class dependentResourceClass = spec.getDependentResourceClass();
            Class associatedResourceClass = spec.getDependentType();
            if (HasMetadata.class.isAssignableFrom(associatedResourceClass)) {
                PolicyRuleBuilder dependentRule = (PolicyRuleBuilder)((PolicyRuleBuilder)((PolicyRuleBuilder)new PolicyRuleBuilder().addToApiGroups(new String[]{HasMetadata.getGroup((Class)associatedResourceClass)})).addToResources(new String[]{HasMetadata.getPlural((Class)associatedResourceClass)})).addToVerbs(RBACVerbs.READ_VERBS);
                if (Updater.class.isAssignableFrom(dependentResourceClass)) {
                    dependentRule.addToVerbs(RBACVerbs.UPDATE_VERBS);
                }
                if (Deleter.class.isAssignableFrom(dependentResourceClass)) {
                    dependentRule.addToVerbs(new String[]{"delete"});
                }
                if (Creator.class.isAssignableFrom(dependentResourceClass)) {
                    dependentRule.addToVerbs(new String[]{"create"});
                    if (!dependentRule.getVerbs().contains("patch")) {
                        dependentRule.addToVerbs(new String[]{"patch"});
                    }
                }
                clusterRoleBuilder.addToRules(new PolicyRule[]{dependentRule.build()});
            }
        });
        clusterRoleBuilder.addAllToRules((Collection)cri.getAdditionalRBACRules());
        return clusterRoleBuilder.build();
    }

    public static String getClusterRoleName(String controller) {
        return controller + "-cluster-role";
    }
}

