/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment.helm;

import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.quarkiverse.operatorsdk.common.ConfigurationUtils;
import io.quarkiverse.operatorsdk.common.DeserializedKubernetesResourcesBuildItem;
import io.quarkiverse.operatorsdk.common.FileUtils;
import io.quarkiverse.operatorsdk.deployment.AddClusterRolesDecorator;
import io.quarkiverse.operatorsdk.deployment.AddRoleBindingsDecorator;
import io.quarkiverse.operatorsdk.deployment.ControllerConfigurationsBuildItem;
import io.quarkiverse.operatorsdk.deployment.GeneratedCRDInfoBuildItem;
import io.quarkiverse.operatorsdk.deployment.helm.HelmGenerationEnabled;
import io.quarkiverse.operatorsdk.deployment.helm.HelmTargetDirectoryBuildItem;
import io.quarkiverse.operatorsdk.deployment.helm.Values;
import io.quarkiverse.operatorsdk.deployment.helm.model.Chart;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.kubernetes.deployment.KubernetesConfig;
import io.quarkus.kubernetes.deployment.PlatformConfiguration;
import io.quarkus.kubernetes.deployment.ResourceNameUtil;
import io.quarkus.qute.Qute;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={HelmGenerationEnabled.class})
public class HelmChartProcessor {
    private static final Logger log = Logger.getLogger(HelmChartProcessor.class);
    static final String TEMPLATES_DIR = "templates";
    private static final String HELM_TEMPLATES_STATIC_DIR = "/helm/static/";
    private static final String[] TEMPLATE_FILES = new String[]{"generic-crd-cluster-role.yaml", "generic-crd-cluster-role-binding.yaml", "service.yaml", "serviceaccount.yaml"};
    private static final String[] ROOT_STATIC_FILES = new String[]{"README.md", "values.schema.json"};
    public static final String CHART_YAML_FILENAME = "Chart.yaml";
    public static final String VALUES_YAML_FILENAME = "values.yaml";
    public static final String CRD_DIR = "crds";
    public static final String CRD_ROLE_BINDING_TEMPLATE_PATH = "/helm/crd-role-binding-template.yaml";
    public static final String CRD_ADDITIONAL_ROLE_BINDING_TEMPLATE_PATH = "/helm/additional-crd-role-binding-template.yaml";
    public static final String ADDITIONAL_CRD_ROLE_BINDING_YAML = "additional-crd-role-binding.yaml";

    @BuildStep
    HelmTargetDirectoryBuildItem createRelatedDirectories(OutputTargetBuildItem outputTarget) {
        File helmDir = outputTarget.getOutputDirectory().resolve("helm").toFile();
        log.infov("Generating helm chart to {0}", (Object)helmDir);
        FileUtils.ensureDirectoryExists((File)helmDir);
        FileUtils.ensureDirectoryExists((File)new File(helmDir, TEMPLATES_DIR));
        FileUtils.ensureDirectoryExists((File)new File(helmDir, CRD_DIR));
        return new HelmTargetDirectoryBuildItem(helmDir);
    }

    @BuildStep
    @Produce(value=ArtifactResultBuildItem.class)
    void addPrimaryClusterRoleBindings(HelmTargetDirectoryBuildItem helmTargetDirectoryBuildItem, ControllerConfigurationsBuildItem controllerConfigurations) {
        Collection<QuarkusControllerConfiguration<?>> controllerConfigs = controllerConfigurations.getControllerConfigs().values();
        if (!controllerConfigs.isEmpty()) {
            String template;
            try (InputStream file = Thread.currentThread().getContextClassLoader().getResourceAsStream(CRD_ROLE_BINDING_TEMPLATE_PATH);){
                if (file == null) {
                    throw new IllegalArgumentException("Template file /helm/crd-role-binding-template.yaml doesn't exist");
                }
                template = new String(file.readAllBytes(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            Path templatesDir = helmTargetDirectoryBuildItem.getPathToTemplatesDir();
            controllerConfigs.forEach(cc -> {
                try {
                    String name = cc.getName();
                    String res = Qute.fmt((String)template, Map.of("reconciler-name", name));
                    Files.writeString(templatesDir.resolve(name + "-crd-role-binding.yaml"), (CharSequence)res, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
    }

    @BuildStep
    @Produce(value=ArtifactResultBuildItem.class)
    void addSecondaryClusterRoleBindings(HelmTargetDirectoryBuildItem helmTargetDirectoryBuildItem, ControllerConfigurationsBuildItem controllerConfigurations) {
        Collection<QuarkusControllerConfiguration<?>> controllerConfigs = controllerConfigurations.getControllerConfigs().values();
        if (!controllerConfigs.isEmpty()) {
            try (InputStream file = Thread.currentThread().getContextClassLoader().getResourceAsStream(CRD_ADDITIONAL_ROLE_BINDING_TEMPLATE_PATH);){
                if (file == null) {
                    throw new IllegalArgumentException("Template file /helm/additional-crd-role-binding-template.yaml doesn't exist");
                }
                String template = new String(file.readAllBytes(), StandardCharsets.UTF_8);
                Path templatesDir = helmTargetDirectoryBuildItem.getPathToTemplatesDir();
                StringBuilder stringBuilder = new StringBuilder();
                controllerConfigs.forEach(cc -> cc.getAdditionalRBACRoleRefs().forEach(roleRef -> {
                    String bindingName = AddRoleBindingsDecorator.getSpecificRoleBindingName(cc.getName(), roleRef);
                    stringBuilder.append(Qute.fmt((String)template, Map.of("role-binding-name", bindingName, "role-ref-kind", roleRef.getKind(), "role-ref-api-group", roleRef.getApiGroup(), "role-ref-name", roleRef.getName())));
                }));
                Files.writeString(templatesDir.resolve(ADDITIONAL_CRD_ROLE_BINDING_YAML), (CharSequence)stringBuilder.toString(), new OpenOption[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @BuildStep
    @Produce(value=ArtifactResultBuildItem.class)
    void addClusterRolesForReconcilers(HelmTargetDirectoryBuildItem helmTargetDirectoryBuildItem, ControllerConfigurationsBuildItem controllerConfigurations) {
        Collection<QuarkusControllerConfiguration<?>> controllerConfigs = controllerConfigurations.getControllerConfigs().values();
        Path templatesDir = helmTargetDirectoryBuildItem.getPathToTemplatesDir();
        controllerConfigs.forEach(cc -> {
            try {
                String name = cc.getName();
                ClusterRole clusterRole = AddClusterRolesDecorator.createClusterRole(cc);
                String yaml = FileUtils.asYaml((Object)clusterRole);
                Files.writeString(templatesDir.resolve(name + "-crd-cluster-role.yaml"), (CharSequence)yaml, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    @BuildStep
    @Produce(value=ArtifactResultBuildItem.class)
    void addExplicitlyAddedKubernetesResources(DeserializedKubernetesResourcesBuildItem generatedKubernetesResources, HelmTargetDirectoryBuildItem helmDirBI, ApplicationInfoBuildItem appInfo, KubernetesConfig kubernetesConfig) {
        List<HasMetadata> resources = generatedKubernetesResources.getResources();
        if (!(resources = this.filterOutStandardResources(resources, ResourceNameUtil.getResourceName((PlatformConfiguration)kubernetesConfig, (ApplicationInfoBuildItem)appInfo))).isEmpty()) {
            Path kubernetesManifest = helmDirBI.getPathToTemplatesDir().resolve("kubernetes.yml");
            String yaml = resources.stream().map(FileUtils::asYaml).collect(Collectors.joining());
            try {
                Files.writeString(kubernetesManifest, (CharSequence)yaml, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private List<HasMetadata> filterOutStandardResources(List<HasMetadata> resources, String operatorName) {
        return resources.stream().filter(r -> {
            if (r instanceof ClusterRole) {
                return !r.getMetadata().getName().endsWith("-cluster-role");
            }
            if (r instanceof ClusterRoleBinding) {
                return !r.getMetadata().getName().endsWith("-crd-validating-role-binding") && !r.getMetadata().getName().endsWith("-cluster-role-binding");
            }
            if (r instanceof RoleBinding) {
                return !r.getMetadata().getName().equals(operatorName + "-view") && !r.getMetadata().getName().endsWith("-role-binding");
            }
            if (r instanceof Service || r instanceof Deployment || r instanceof ServiceAccount) {
                return !r.getMetadata().getName().equals(operatorName);
            }
            return true;
        }).toList();
    }

    @BuildStep
    @Produce(value=ArtifactResultBuildItem.class)
    private void addTemplateFiles(HelmTargetDirectoryBuildItem helmDirBI) {
        this.copyTemplates(helmDirBI.getPathToTemplatesDir(), TEMPLATE_FILES);
    }

    @BuildStep
    @Produce(value=ArtifactResultBuildItem.class)
    void addGeneratedDeployment(HelmTargetDirectoryBuildItem helmDirBI, DeserializedKubernetesResourcesBuildItem deserializedKubernetesResources, ControllerConfigurationsBuildItem controllerConfigurations, ApplicationInfoBuildItem appInfo) {
        Deployment deployment = (Deployment)deserializedKubernetesResources.getResources().stream().filter(Deployment.class::isInstance).findFirst().orElseThrow();
        PodSpecFluent.ContainersNested firstContainer = deployment.edit().editSpec().editTemplate().editSpec().editFirstContainer();
        controllerConfigurations.getControllerConfigs().forEach((name, unused) -> ((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)firstContainer.addNewEnv().withName(ConfigurationUtils.getNamespacesPropertyName((String)name, (boolean)true))).withValue("{watchNamespaces}")).endEnv());
        deployment = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)firstContainer.endContainer()).endSpec()).endTemplate()).endSpec()).build();
        String template = FileUtils.asYaml((Object)deployment);
        String res = template.replace("\"{watchNamespaces}\"", "{{ .Values.watchNamespaces }}");
        res = res.replaceAll(appInfo.getVersion(), "{{ .Chart.AppVersion }}");
        try {
            Files.writeString(helmDirBI.getPathToTemplatesDir().resolve("deployment.yaml"), (CharSequence)res, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @BuildStep
    @Produce(value=ArtifactResultBuildItem.class)
    private void addCRDs(HelmTargetDirectoryBuildItem helmDirBI, GeneratedCRDInfoBuildItem generatedCRDInfoBuildItem) {
        List crdInfos = generatedCRDInfoBuildItem.getCRDGenerationInfo().getCrds().values().stream().flatMap(m -> m.values().stream()).toList();
        Path crdDir = helmDirBI.getPathToHelmDir().resolve(CRD_DIR);
        crdInfos.forEach(crdInfo -> {
            try {
                Path generateCrdPath = Path.of(crdInfo.getFilePath(), new String[0]);
                Files.copy(generateCrdPath, crdDir.resolve(generateCrdPath.getFileName().toString()), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    @BuildStep
    @Produce(value=ArtifactResultBuildItem.class)
    private void addValuesYaml(HelmTargetDirectoryBuildItem helmTargetDirectoryBuildItem) {
        try {
            Values values = new Values();
            String valuesYaml = FileUtils.asYaml((Object)values);
            Path valuesFile = helmTargetDirectoryBuildItem.getPathToHelmDir().resolve(VALUES_YAML_FILENAME);
            Files.writeString(valuesFile, (CharSequence)valuesYaml, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @BuildStep
    @Produce(value=ArtifactResultBuildItem.class)
    private void addReadmeAndSchema(HelmTargetDirectoryBuildItem helmDirBI) {
        this.copyTemplates(helmDirBI.getPathToHelmDir(), ROOT_STATIC_FILES);
    }

    @BuildStep
    @Produce(value=ArtifactResultBuildItem.class)
    void addChartYaml(HelmTargetDirectoryBuildItem helmTargetDirectoryBuildItem, ApplicationInfoBuildItem appInfo) {
        try {
            Chart chart = new Chart();
            chart.setName(appInfo.getName());
            chart.setVersion(appInfo.getVersion());
            chart.setAppVersion(appInfo.getVersion());
            chart.setApiVersion("v2");
            String chartYaml = FileUtils.asYaml((Object)chart);
            Path chartFile = helmTargetDirectoryBuildItem.getPathToHelmDir().resolve(CHART_YAML_FILENAME);
            Files.writeString(chartFile, (CharSequence)chartYaml, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void copyTemplates(Path path, String[] staticTemplateFiles) {
        for (String template : staticTemplateFiles) {
            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(HELM_TEMPLATES_STATIC_DIR + template);){
                if (is == null) {
                    throw new IllegalArgumentException("Template file " + template + " doesn't exist");
                }
                Files.copy(is, path.resolve(template), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

