/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleFluent;
import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import io.fabric8.kubernetes.api.model.rbac.PolicyRuleBuilder;
import io.javaoperatorsdk.operator.api.config.Utils;
import io.javaoperatorsdk.operator.api.reconciler.dependent.Deleter;
import io.javaoperatorsdk.operator.processing.dependent.Creator;
import io.javaoperatorsdk.operator.processing.dependent.Updater;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.GenericKubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.GroupVersionKindPlural;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResourceConfig;
import io.quarkiverse.operatorsdk.annotations.RBACVerbs;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class AddClusterRolesDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    public static final String JOSDK_CRD_VALIDATING_CLUSTER_ROLE_NAME = "josdk-crd-validating-cluster-role";
    private static final ClusterRoleBuilder CRD_VALIDATING_CLUSTER_ROLE_BUILDER = (ClusterRoleBuilder)((ClusterRoleBuilder)((ClusterRoleFluent.MetadataNested)new ClusterRoleBuilder().withNewMetadata().withName("josdk-crd-validating-cluster-role")).endMetadata()).addToRules(new PolicyRule[]{((PolicyRuleBuilder)((PolicyRuleBuilder)((PolicyRuleBuilder)new PolicyRuleBuilder().addToApiGroups(new String[]{"apiextensions.k8s.io"})).addToResources(new String[]{"customresourcedefinitions"})).addToVerbs(new String[]{"get", "list"})).build()});
    private static final String CR_API_VERSION = HasMetadata.getApiVersion(ClusterRole.class);
    private static final String CR_KIND = HasMetadata.getKind(ClusterRole.class);
    private static final Logger log = Logger.getLogger(AddClusterRolesDecorator.class);
    private static final String ADD_CLUSTER_ROLES_DECORATOR = "AddClusterRolesDecorator";
    private final Collection<QuarkusControllerConfiguration<?>> configs;
    private final boolean validateCRDs;

    public AddClusterRolesDecorator(Collection<QuarkusControllerConfiguration<?>> configs, boolean validateCRDs) {
        this.configs = configs;
        this.validateCRDs = validateCRDs;
    }

    public void visit(KubernetesListBuilder list) {
        this.configs.forEach(cri -> {
            ClusterRole clusterRole = AddClusterRolesDecorator.createClusterRole(cri);
            list.addToItems(new HasMetadata[]{clusterRole});
        });
        if (this.validateCRDs && !this.contains(list, CR_API_VERSION, CR_KIND, JOSDK_CRD_VALIDATING_CLUSTER_ROLE_NAME)) {
            list.addToItems((VisitableBuilder)CRD_VALIDATING_CLUSTER_ROLE_BUILDER);
        }
    }

    public static ClusterRole createClusterRole(QuarkusControllerConfiguration<?> cri) {
        LinkedHashMap<String, PolicyRule> rules = new LinkedHashMap<String, PolicyRule>();
        PolicyRule clusterRolePolicyRuleFromPrimaryResource = AddClusterRolesDecorator.getClusterRolePolicyRuleFromPrimaryResource(cri);
        String primaryRuleKey = AddClusterRolesDecorator.getKeyFor(clusterRolePolicyRuleFromPrimaryResource);
        rules.put(primaryRuleKey, clusterRolePolicyRuleFromPrimaryResource);
        AddClusterRolesDecorator.collectAndMergeIfNeededRulesFrom(AddClusterRolesDecorator.getClusterRolePolicyRulesFromDependentResources(cri), rules);
        AddClusterRolesDecorator.collectAndMergeIfNeededRulesFrom(cri.getAdditionalRBACRules(), rules);
        return ((ClusterRoleBuilder)((ClusterRoleBuilder)((ClusterRoleFluent.MetadataNested)new ClusterRoleBuilder().withNewMetadata().withName(AddClusterRolesDecorator.getClusterRoleName(cri.getName()))).endMetadata()).addAllToRules(rules.values())).build();
    }

    private static void collectAndMergeIfNeededRulesFrom(Collection<PolicyRule> newRules, Map<String, PolicyRule> existingRules) {
        newRules.forEach(newPolicyRule -> {
            String key = AddClusterRolesDecorator.getKeyFor(newPolicyRule);
            existingRules.merge(key, (PolicyRule)newPolicyRule, (existing, npr) -> {
                TreeSet verbs1 = new TreeSet(existing.getVerbs());
                verbs1.addAll(npr.getVerbs());
                existing.setVerbs(new ArrayList(verbs1));
                return existing;
            });
        });
    }

    private static String getKeyFor(PolicyRule rule) {
        return rule.getApiGroups().stream().sorted().collect(Collectors.joining("-")) + "/" + rule.getResources().stream().sorted().collect(Collectors.joining("-"));
    }

    private static Set<PolicyRule> getClusterRolePolicyRulesFromDependentResources(QuarkusControllerConfiguration<?> cri) {
        LinkedHashSet<PolicyRule> rules = new LinkedHashSet<PolicyRule>();
        Map dependentsMetadata = cri.getDependentsMetadata();
        dependentsMetadata.forEach((name, spec) -> {
            Class dependentResourceClass = spec.getDependentResourceClass();
            Class associatedResourceClass = spec.getDependentType();
            if (HasMetadata.class.isAssignableFrom(associatedResourceClass)) {
                boolean isCreator;
                Class asHasMetadataClass = associatedResourceClass;
                String resourceGroup = HasMetadata.getGroup((Class)asHasMetadataClass);
                String resourcePlural = HasMetadata.getPlural((Class)asHasMetadataClass);
                TreeSet<String> verbs = new TreeSet<String>(List.of(RBACVerbs.READ_VERBS));
                if (Updater.class.isAssignableFrom(dependentResourceClass)) {
                    verbs.addAll(List.of(RBACVerbs.UPDATE_VERBS));
                }
                if (Deleter.class.isAssignableFrom(dependentResourceClass)) {
                    verbs.add("delete");
                }
                if (isCreator = Creator.class.isAssignableFrom(dependentResourceClass)) {
                    verbs.add("create");
                }
                boolean ignore = false;
                if (KubernetesDependentResource.class.isAssignableFrom(dependentResourceClass)) {
                    Class asKubeDRClass = dependentResourceClass;
                    if (isCreator && cri.getConfigurationService().shouldUseSSA(asKubeDRClass, asHasMetadataClass, (KubernetesDependentResourceConfig)spec.getDependentResourceConfig())) {
                        verbs.add("patch");
                    }
                    try {
                        KubernetesDependentResource kubeResource = (KubernetesDependentResource)Utils.instantiate((Class)asKubeDRClass, KubernetesDependentResource.class, (String)ADD_CLUSTER_ROLES_DECORATOR);
                        if (kubeResource instanceof GenericKubernetesDependentResource) {
                            GenericKubernetesDependentResource genericKubeRes = (GenericKubernetesDependentResource)kubeResource;
                            GroupVersionKindPlural gvk = genericKubeRes.getGroupVersionKind();
                            resourceGroup = gvk.getGroup();
                            resourcePlural = gvk.getPluralOrDefault();
                        }
                    }
                    catch (Exception e) {
                        ignore = true;
                        log.warn((Object)(" Ignoring dependent " + dependentResourceClass.getName() + " because it couldn't be instantiated as it doesn't provide a no-arg constructor, preventing its group and plural from being determined."));
                    }
                }
                if (!ignore) {
                    PolicyRuleBuilder dependentRule = (PolicyRuleBuilder)((PolicyRuleBuilder)new PolicyRuleBuilder().addToApiGroups(new String[]{resourceGroup})).addToResources(new String[]{resourcePlural});
                    dependentRule.addToVerbs((String[])verbs.toArray(String[]::new));
                    rules.add(dependentRule.build());
                }
            }
        });
        return rules;
    }

    private static PolicyRule getClusterRolePolicyRuleFromPrimaryResource(QuarkusControllerConfiguration<?> cri) {
        PolicyRuleBuilder rule = new PolicyRuleBuilder();
        Class resourceClass = cri.getResourceClass();
        String plural = HasMetadata.getPlural((Class)resourceClass);
        rule.addToResources(new String[]{plural});
        if (cri.isStatusPresentAndNotVoid()) {
            rule.addToResources(new String[]{plural + "/status"});
        }
        rule.addToResources(new String[]{plural + "/finalizers"});
        ((PolicyRuleBuilder)((PolicyRuleBuilder)rule.addToApiGroups(new String[]{HasMetadata.getGroup((Class)resourceClass)})).addToVerbs(RBACVerbs.ALL_COMMON_VERBS)).build();
        return rule.build();
    }

    public static String getClusterRoleName(String controller) {
        return controller + "-cluster-role";
    }
}

