/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.fabric8.crdv2.generator.CRDGenerationInfo;
import io.fabric8.crdv2.generator.CRDGenerator;
import io.fabric8.crdv2.generator.CustomResourceInfo;
import io.fabric8.kubernetes.client.CustomResource;
import io.quarkiverse.operatorsdk.common.CustomResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.FileUtils;
import io.quarkiverse.operatorsdk.runtime.CRDConfiguration;
import io.quarkiverse.operatorsdk.runtime.CRDInfo;
import io.quarkiverse.operatorsdk.runtime.CRDInfos;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.logging.Logger;

class CRDGeneration {
    private static final Logger log = Logger.getLogger((String)CRDGeneration.class.getName());
    private final LaunchMode mode;
    private final CRDConfiguration crdConfiguration;
    private CRDGenerator generator;
    private boolean needGeneration;

    CRDGeneration(CRDConfiguration crdConfig, LaunchMode mode) {
        this.crdConfiguration = crdConfig;
        this.mode = mode;
    }

    static boolean shouldGenerate(Optional<Boolean> configuredGenerate, Optional<Boolean> configuredApply, LaunchMode launchMode) {
        return CRDGeneration.shouldApply(configuredApply, launchMode) || configuredGenerate.orElse(true) != false;
    }

    static boolean shouldApply(Optional<Boolean> configuredApply, LaunchMode launchMode) {
        if (launchMode == null || !launchMode.isDevOrTest()) {
            return false;
        }
        return configuredApply.orElse(true);
    }

    boolean shouldApply() {
        return CRDGeneration.shouldApply(this.crdConfiguration.apply(), this.mode);
    }

    io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo generate(OutputTargetBuildItem outputTarget, boolean validateCustomResources, CRDInfos existing) {
        CRDInfos converted = new CRDInfos(existing);
        HashSet generated = new HashSet();
        if (this.needGeneration) {
            Path targetDirectory = this.crdConfiguration.outputDirectory().map(d -> Paths.get("", new String[0]).toAbsolutePath().resolve((String)d)).orElse(outputTarget.getOutputDirectory().resolve("kubernetes"));
            File outputDir = targetDirectory.toFile();
            FileUtils.ensureDirectoryExists((File)outputDir);
            CRDGenerationInfo info = this.generator.forCRDVersions(this.crdConfiguration.versions()).inOutputDir(outputDir).detailedGenerate();
            Map crdDetailsPerNameAndVersion = info.getCRDDetailsPerNameAndVersion();
            crdDetailsPerNameAndVersion.forEach((crdName, initialVersionToCRDInfoMap) -> {
                log.infov("Generated {0} CRD:", crdName);
                generated.add(crdName);
                initialVersionToCRDInfoMap.forEach((crdSpecVersion, crdInfo) -> {
                    String filePath = crdInfo.getFilePath();
                    log.infov("  - {0} -> {1}", crdSpecVersion, (Object)filePath);
                    converted.addCRDInfo(new CRDInfo(crdName, crdSpecVersion, filePath, crdInfo.getDependentClassNames()));
                });
            });
        }
        return new io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo(this.shouldApply(), validateCustomResources, converted, generated);
    }

    private boolean needsGeneration(Map<String, CRDInfo> existingCRDInfos, Set<String> changedClassNames) {
        boolean[] generateCurrent = new boolean[]{true};
        this.crdConfiguration.versions().forEach(v -> {
            CRDInfo crd = (CRDInfo)existingCRDInfos.get(v);
            if (crd == null) {
                return;
            }
            if (changedClassNames != null && !changedClassNames.isEmpty()) {
                for (String changedClass : changedClassNames) {
                    if (!crd.getDependentClassNames().contains(changedClass)) continue;
                    return;
                }
            }
            log.infov("''{0}'' CRD generation was skipped for ''{1}'' because no changes impacting the CRD were detected", v, (Object)crd.getCrdName());
            generateCurrent[0] = false;
        });
        return generateCurrent[0];
    }

    boolean scheduleForGenerationIfNeeded(CustomResourceAugmentedClassInfo crInfo, Map<String, CRDInfo> existingCRDInfos, Set<String> changedClasses) {
        boolean scheduleCurrent = true;
        if (existingCRDInfos != null && !existingCRDInfos.isEmpty()) {
            scheduleCurrent = this.needsGeneration(existingCRDInfos, changedClasses);
        }
        if (scheduleCurrent) {
            this.withCustomResource(crInfo.loadAssociatedClass(), crInfo.getAssociatedReconcilerName().orElse(null));
        }
        return scheduleCurrent;
    }

    void withCustomResource(Class<? extends CustomResource<?, ?>> crClass, String associatedControllerName) {
        try {
            if (this.generator == null) {
                this.generator = new CRDGenerator().withParallelGenerationEnabled(this.crdConfiguration.generateInParallel().booleanValue());
            }
            CustomResourceInfo info = CustomResourceInfo.fromClass(crClass);
            this.generator.customResources(new CustomResourceInfo[]{info});
            this.needGeneration = true;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot process " + crClass.getName() + " custom resource" + (String)(associatedControllerName != null ? " for controller '" + associatedControllerName + "'" : ""), e);
        }
    }
}

