/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.quarkiverse.operatorsdk.common.ClassUtils;
import io.quarkiverse.operatorsdk.common.ConfigurationUtils;
import io.quarkiverse.operatorsdk.common.Constants;
import io.quarkiverse.operatorsdk.common.CustomResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconciledAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconciledResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ResourceAssociatedAugmentedClassInfo;
import io.quarkiverse.operatorsdk.deployment.CRDGeneration;
import io.quarkiverse.operatorsdk.deployment.GeneratedCRDInfoBuildItem;
import io.quarkiverse.operatorsdk.deployment.ReconcilerInfosBuildItem;
import io.quarkiverse.operatorsdk.deployment.UnownedCRDInfoBuildItem;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.CRDConfiguration;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import io.quarkiverse.operatorsdk.runtime.CRDInfo;
import io.quarkiverse.operatorsdk.runtime.CRDInfos;
import io.quarkiverse.operatorsdk.runtime.CRDUtils;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.runtime.LaunchMode;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

class CRDGenerationBuildStep {
    static final Logger log = Logger.getLogger((String)CRDGenerationBuildStep.class.getName());
    private static final String excludedCause = "it was explicitly excluded from generation";
    private static final String externalCause = "it is associated with an externally provided CRD";

    CRDGenerationBuildStep() {
    }

    @BuildStep
    GeneratedCRDInfoBuildItem generateCRDs(BuildTimeOperatorConfiguration operatorConfiguration, ReconcilerInfosBuildItem reconcilers, LaunchModeBuildItem launchModeBuildItem, LiveReloadBuildItem liveReload, OutputTargetBuildItem outputTarget, CombinedIndexBuildItem combinedIndexBuildItem, UnownedCRDInfoBuildItem unownedCRDInfo) {
        CRDConfiguration crdConfig = operatorConfiguration.crd();
        boolean validateCustomResources = ConfigurationUtils.shouldValidateCustomResources((boolean)crdConfig.validate());
        LaunchMode launchMode = launchModeBuildItem.getLaunchMode();
        CRDGeneration crdGeneration = new CRDGeneration(crdConfig, launchMode);
        CRDInfos stored = (CRDInfos)liveReload.getContextObject(CRDInfos.class);
        if (stored == null) {
            stored = new CRDInfos();
        }
        boolean generate = CRDGeneration.shouldGenerate(crdConfig.generate(), crdConfig.apply(), launchMode);
        CRDInfos storedCRDInfos = stored;
        Set changedClasses = ConfigurationUtils.getChangedClasses((LiveReloadBuildItem)liveReload);
        HashSet scheduledForGeneration = new HashSet(7);
        Set excludedResourceClasses = crdConfig.excludeResources().map(Set::copyOf).orElseGet(Collections::emptySet);
        CRDInfos externalCRDs = unownedCRDInfo.getCRDs();
        Function<CustomResourceAugmentedClassInfo, Boolean> keepResourcePredicate = crInfo -> !this.isExcluded((CustomResourceAugmentedClassInfo)crInfo, externalCRDs, excludedResourceClasses);
        if (generate) {
            reconcilers.getReconcilers().values().stream().map(ResourceAssociatedAugmentedClassInfo::associatedResourceInfo).filter(ReconciledAugmentedClassInfo::isCR).map(CustomResourceAugmentedClassInfo.class::cast).filter(keepResourcePredicate::apply).forEach(associatedResource -> {
                ReconciledResourceAugmentedClassInfo crInfo = associatedResource.asResourceTargeting();
                ReconciledResourceAugmentedClassInfo.Id crId = crInfo.id();
                if (!operatorConfiguration.isControllerOwningPrimary((String)associatedResource.getAssociatedReconcilerName().orElseThrow())) {
                    scheduledForGeneration.add(crId);
                } else {
                    Map crdInfos = Collections.emptyMap();
                    if (liveReload.isLiveReload()) {
                        crdInfos = storedCRDInfos.getOrCreateCRDSpecVersionToInfoMapping(crInfo.fullResourceName());
                    }
                    if (crdGeneration.scheduleForGenerationIfNeeded((CustomResourceAugmentedClassInfo)crInfo, crdInfos, changedClasses)) {
                        scheduledForGeneration.add(crId);
                    }
                }
            });
            if (crdConfig.generateAll().booleanValue()) {
                keepResourcePredicate = crInfo -> !scheduledForGeneration.contains(crInfo.id()) && !this.isExcluded((CustomResourceAugmentedClassInfo)crInfo, externalCRDs, excludedResourceClasses);
                Map<String, Function<CustomResourceAugmentedClassInfo, Boolean>> context = Map.of("keep-cr-predicate", keepResourcePredicate);
                ClassUtils.getProcessableSubClassesOf((DotName)Constants.CUSTOM_RESOURCE, (IndexView)combinedIndexBuildItem.getIndex(), (Logger)log, context).map(CustomResourceAugmentedClassInfo.class::cast).forEach(cr -> {
                    crdGeneration.withCustomResource(cr.loadAssociatedClass(), null);
                    log.infov("Will generate CRD for non-reconciler bound resource: {0}", (Object)cr.fullResourceName());
                });
            }
        }
        CRDGenerationInfo crdInfo = crdGeneration.generate(outputTarget, validateCustomResources, storedCRDInfos);
        liveReload.setContextObject(CRDInfos.class, (Object)storedCRDInfos);
        return new GeneratedCRDInfoBuildItem(crdInfo);
    }

    @BuildStep
    UnownedCRDInfoBuildItem unownedCRDInfo(BuildTimeOperatorConfiguration operatorConfiguration, CurateOutcomeBuildItem appInfoBuildItem) {
        Optional maybeExternalCRDs = operatorConfiguration.crd().externalCRDLocations();
        CRDInfos crds = new CRDInfos();
        if (maybeExternalCRDs.isPresent()) {
            Path moduleRoot = appInfoBuildItem.getApplicationModel().getApplicationModule().getModuleDir().toPath();
            ((List)maybeExternalCRDs.get()).parallelStream().filter(Predicate.not(String::isBlank)).map(String::trim).forEach(crdLocation -> {
                Path crdPath = moduleRoot.resolve((String)crdLocation);
                CRDInfo crd = CRDUtils.loadFromAsCRDInfo((Path)crdPath);
                crds.addCRDInfo(crd);
            });
        }
        return new UnownedCRDInfoBuildItem(crds);
    }

    private boolean isExcluded(CustomResourceAugmentedClassInfo crInfo, CRDInfos externalCRDs, Set<String> excludedResourceClassNames) {
        String crClassName = crInfo.classInfo().name().toString();
        boolean excluded = excludedResourceClassNames.contains(crClassName);
        boolean external = externalCRDs.contains(crInfo.fullResourceName());
        if (excluded || external) {
            log.infov("CRD generation was skipped for ''{0}'' because {1}", (Object)crClassName, (Object)(external ? externalCause : excludedCause));
            return true;
        }
        return false;
    }
}

