/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.quarkiverse.operatorsdk.common.DeserializedKubernetesResourcesBuildItem;
import io.quarkiverse.operatorsdk.common.GeneratedResourcesUtils;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.kubernetes.spi.GeneratedKubernetesResourceBuildItem;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.eclipse.microprofile.config.ConfigProvider;

public class GeneratedKubernetesManifestsProcessor {
    @BuildStep(onlyIf={NeedResourcesDeserialization.class})
    DeserializedKubernetesResourcesBuildItem deserializeGeneratedKubernetesResources(List<GeneratedKubernetesResourceBuildItem> generatedResources) {
        return new DeserializedKubernetesResourcesBuildItem(GeneratedResourcesUtils.loadFrom(generatedResources));
    }

    private static class NeedResourcesDeserialization
    implements BooleanSupplier {
        private NeedResourcesDeserialization() {
        }

        @Override
        public boolean getAsBoolean() {
            Boolean helmEnabled = ConfigProvider.getConfig().getOptionalValue("quarkus.operator-sdk.helm.enabled", Boolean.class).orElse(false);
            Boolean bundleEnabled = ConfigProvider.getConfig().getOptionalValue("quarkus.operator-sdk.bundle.enabled", Boolean.class).orElse(false);
            return helmEnabled != false || bundleEnabled != false;
        }
    }
}

