/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment.devui.commands;

import io.quarkiverse.operatorsdk.runtime.Version;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.invocation.CommandInvocation;

@CommandDefinition(name="versions", description="Outputs QOSDK, Quarkus, Fabric8 and JOSDK versions, with which this QOSDK version was built")
public class VersionsCommand
implements Command {
    private final Version version;

    public VersionsCommand(Version version) {
        this.version = version;
    }

    public CommandResult execute(CommandInvocation commandInvocation) {
        String output = "Targeted Quarkus version: " + this.version.getQuarkusVersion() + "\nFabric8 client version targeted by JOSDK: " + this.version.getKubernetesClientVersion() + "\nQOSDK version: " + this.version.getExtensionCompleteVersion() + "\nJOSDK version: " + this.version.getSdkVersion();
        commandInvocation.println(output);
        return CommandResult.SUCCESS;
    }
}

