/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.quarkiverse.operatorsdk.common.ConfigurationUtils;
import io.quarkiverse.operatorsdk.runtime.BuildTimeControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

class BuildTimeHybridControllerConfiguration {
    private final BuildTimeOperatorConfiguration operatorConfiguration;
    private final BuildTimeControllerConfiguration externalConfiguration;
    private final AnnotationInstance controllerAnnotation;

    public BuildTimeHybridControllerConfiguration(BuildTimeOperatorConfiguration operatorConfiguration, BuildTimeControllerConfiguration externalConfiguration, AnnotationInstance controllerAnnotation) {
        this.operatorConfiguration = operatorConfiguration;
        this.externalConfiguration = externalConfiguration;
        this.controllerAnnotation = controllerAnnotation;
    }

    boolean generationAware() {
        return (Boolean)ConfigurationUtils.extract((Object)this.externalConfiguration, (AnnotationInstance)this.controllerAnnotation, BuildTimeControllerConfiguration::generationAware, (String)"generationAwareEventProcessing", AnnotationValue::asBoolean, () -> this.operatorConfiguration.generationAware().orElse(true));
    }

    Set<String> generateWithWatchedNamespaces(boolean wereNamespacesSet) {
        Optional overrideNamespaces;
        HashSet namespaces = null;
        if (this.externalConfiguration != null && (overrideNamespaces = this.externalConfiguration.generateWithWatchedNamespaces()).isPresent()) {
            namespaces = new HashSet((Collection)overrideNamespaces.get());
        }
        Optional watchedNamespaces = this.operatorConfiguration.generateWithWatchedNamespaces();
        if (!wereNamespacesSet && namespaces == null && watchedNamespaces.isPresent()) {
            namespaces = new HashSet((Collection)watchedNamespaces.get());
        }
        return namespaces;
    }
}

