/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleFluent;
import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import io.fabric8.kubernetes.api.model.rbac.PolicyRuleBuilder;
import io.javaoperatorsdk.operator.api.config.Utils;
import io.javaoperatorsdk.operator.api.reconciler.dependent.Deleter;
import io.javaoperatorsdk.operator.processing.dependent.Creator;
import io.javaoperatorsdk.operator.processing.dependent.Updater;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.GenericKubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.GroupVersionKindPlural;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResourceConfig;
import io.quarkiverse.operatorsdk.annotations.RBACVerbs;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class ClusterRoles {
    public static final String JOSDK_CRD_VALIDATING_CLUSTER_ROLE_NAME = "josdk-crd-validating-cluster-role";
    private static final ClusterRole CRD_VALIDATING_CLUSTER_ROLE = ((ClusterRoleBuilder)((ClusterRoleBuilder)((ClusterRoleFluent.MetadataNested)new ClusterRoleBuilder().withNewMetadata().withName("josdk-crd-validating-cluster-role")).endMetadata()).addToRules(new PolicyRule[]{((PolicyRuleBuilder)((PolicyRuleBuilder)((PolicyRuleBuilder)new PolicyRuleBuilder().addToApiGroups(new String[]{"apiextensions.k8s.io"})).addToResources(new String[]{"customresourcedefinitions"})).addToVerbs(new String[]{"get", "list"})).build()})).build();
    private static final Logger log = Logger.getLogger(ClusterRoles.class);
    private static final String ADD_CLUSTER_ROLES_DECORATOR = "AddClusterRolesDecorator";

    public static List<ClusterRole> createClusterRoles(Collection<QuarkusControllerConfiguration<?>> configs, boolean validateCRDs) {
        ArrayList<ClusterRole> roles = new ArrayList<ClusterRole>(configs.size() + 1);
        configs.forEach(cri -> {
            ClusterRole clusterRole = ClusterRoles.createClusterRole(cri);
            roles.add(clusterRole);
        });
        if (validateCRDs) {
            roles.add(CRD_VALIDATING_CLUSTER_ROLE);
        }
        return roles;
    }

    public static ClusterRole createClusterRole(QuarkusControllerConfiguration<?> cri) {
        LinkedHashMap<String, PolicyRule> rules = new LinkedHashMap<String, PolicyRule>();
        PolicyRule clusterRolePolicyRuleFromPrimaryResource = ClusterRoles.getClusterRolePolicyRuleFromPrimaryResource(cri);
        String primaryRuleKey = ClusterRoles.getKeyFor(clusterRolePolicyRuleFromPrimaryResource);
        rules.put(primaryRuleKey, clusterRolePolicyRuleFromPrimaryResource);
        ClusterRoles.collectAndMergeIfNeededRulesFrom(ClusterRoles.getClusterRolePolicyRulesFromDependentResources(cri), rules);
        ClusterRoles.collectAndMergeIfNeededRulesFrom(cri.getAdditionalRBACRules(), rules);
        return ((ClusterRoleBuilder)((ClusterRoleBuilder)((ClusterRoleFluent.MetadataNested)new ClusterRoleBuilder().withNewMetadata().withName(ClusterRoles.getClusterRoleName(cri.getName()))).endMetadata()).addAllToRules(rules.values())).build();
    }

    private static void collectAndMergeIfNeededRulesFrom(Collection<PolicyRule> newRules, Map<String, PolicyRule> existingRules) {
        newRules.forEach(newPolicyRule -> {
            String key = ClusterRoles.getKeyFor(newPolicyRule);
            existingRules.merge(key, (PolicyRule)newPolicyRule, (existing, npr) -> {
                TreeSet verbs1 = new TreeSet(existing.getVerbs());
                verbs1.addAll(npr.getVerbs());
                existing.setVerbs(new ArrayList(verbs1));
                return existing;
            });
        });
    }

    private static String getKeyFor(PolicyRule rule) {
        return rule.getApiGroups().stream().sorted().collect(Collectors.joining("-")) + "/" + rule.getResources().stream().sorted().collect(Collectors.joining("-"));
    }

    private static Set<PolicyRule> getClusterRolePolicyRulesFromDependentResources(QuarkusControllerConfiguration<?> cri) {
        LinkedHashSet<PolicyRule> rules = new LinkedHashSet<PolicyRule>();
        Map dependentsMetadata = cri.dependentsMetadata();
        dependentsMetadata.forEach((name, spec) -> {
            Class dependentResourceClass = spec.getDependentResourceClass();
            Class associatedResourceClass = spec.getResourceClass();
            if (HasMetadata.class.isAssignableFrom(associatedResourceClass)) {
                boolean isCreator;
                Class asHasMetadataClass = associatedResourceClass;
                String resourceGroup = HasMetadata.getGroup((Class)asHasMetadataClass);
                String resourcePlural = HasMetadata.getPlural((Class)asHasMetadataClass);
                TreeSet<String> verbs = new TreeSet<String>(List.of(RBACVerbs.READ_VERBS));
                if (Updater.class.isAssignableFrom(dependentResourceClass)) {
                    verbs.addAll(List.of(RBACVerbs.UPDATE_VERBS));
                }
                if (Deleter.class.isAssignableFrom(dependentResourceClass)) {
                    verbs.add("delete");
                }
                if (isCreator = Creator.class.isAssignableFrom(dependentResourceClass)) {
                    verbs.add("create");
                }
                boolean ignore = false;
                if (KubernetesDependentResource.class.isAssignableFrom(dependentResourceClass)) {
                    Class asKubeDRClass = dependentResourceClass;
                    if (isCreator) {
                        if (cri.getConfigurationService().shouldUseSSA(asKubeDRClass, asHasMetadataClass, (KubernetesDependentResourceConfig)spec.getConfiguration().filter(KubernetesDependentResourceConfig.class::isInstance).orElse(null))) {
                            verbs.add("patch");
                        }
                    }
                    try {
                        KubernetesDependentResource kubeResource = (KubernetesDependentResource)Utils.instantiate((Class)asKubeDRClass, KubernetesDependentResource.class, (String)ADD_CLUSTER_ROLES_DECORATOR);
                        if (kubeResource instanceof GenericKubernetesDependentResource) {
                            GenericKubernetesDependentResource genericKubeRes = (GenericKubernetesDependentResource)kubeResource;
                            GroupVersionKindPlural gvk = genericKubeRes.getGroupVersionKind();
                            resourceGroup = gvk.getGroup();
                            resourcePlural = gvk.getPluralOrDefault();
                        }
                    }
                    catch (Exception e) {
                        ignore = true;
                        log.warn((Object)(" Ignoring dependent " + dependentResourceClass.getName() + " because it couldn't be instantiated as it doesn't provide a no-arg constructor, preventing its group and plural from being determined."));
                    }
                }
                if (!ignore) {
                    PolicyRuleBuilder dependentRule = (PolicyRuleBuilder)((PolicyRuleBuilder)new PolicyRuleBuilder().addToApiGroups(new String[]{resourceGroup})).addToResources(new String[]{resourcePlural});
                    dependentRule.addToVerbs((String[])verbs.toArray(String[]::new));
                    rules.add(dependentRule.build());
                }
            }
        });
        return rules;
    }

    private static PolicyRule getClusterRolePolicyRuleFromPrimaryResource(QuarkusControllerConfiguration<?> cri) {
        PolicyRuleBuilder rule = new PolicyRuleBuilder();
        Class resourceClass = cri.getResourceClass();
        String plural = HasMetadata.getPlural((Class)resourceClass);
        rule.addToResources(new String[]{plural});
        if (cri.isStatusPresentAndNotVoid()) {
            rule.addToResources(new String[]{plural + "/status"});
        }
        rule.addToResources(new String[]{plural + "/finalizers"});
        ((PolicyRuleBuilder)((PolicyRuleBuilder)rule.addToApiGroups(new String[]{HasMetadata.getGroup((Class)resourceClass)})).addToVerbs(RBACVerbs.ALL_COMMON_VERBS)).build();
        return rule.build();
    }

    public static String getClusterRoleName(String controller) {
        return controller + "-cluster-role";
    }
}

