/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import io.fabric8.kubernetes.api.model.rbac.PolicyRuleBuilder;
import io.fabric8.kubernetes.api.model.rbac.RoleRef;
import io.fabric8.kubernetes.api.model.rbac.RoleRefBuilder;
import io.fabric8.kubernetes.client.informers.cache.ItemStore;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.dependent.ConfigurationConverter;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceConfigurationResolver;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceSpec;
import io.javaoperatorsdk.operator.api.config.informer.InformerConfiguration;
import io.javaoperatorsdk.operator.api.config.workflow.WorkflowSpec;
import io.javaoperatorsdk.operator.api.reconciler.Constants;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentConverter;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResourceConfig;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Condition;
import io.javaoperatorsdk.operator.processing.dependent.workflow.ManagedWorkflow;
import io.javaoperatorsdk.operator.processing.dependent.workflow.ManagedWorkflowSupport;
import io.javaoperatorsdk.operator.processing.event.rate.RateLimiter;
import io.javaoperatorsdk.operator.processing.event.source.filter.GenericFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnAddFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import io.javaoperatorsdk.operator.processing.retry.GenericRetry;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import io.quarkiverse.operatorsdk.common.AnnotationConfigurableAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ClassLoadingUtils;
import io.quarkiverse.operatorsdk.common.ConfigurationUtils;
import io.quarkiverse.operatorsdk.common.DependentResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconciledAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconciledResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ReconcilerAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.SelectiveAugmentedClassInfo;
import io.quarkiverse.operatorsdk.deployment.AnnotationConfigurablesBuildItem;
import io.quarkiverse.operatorsdk.deployment.BuildTimeConfigurationServiceBuildItem;
import io.quarkiverse.operatorsdk.deployment.BuildTimeHybridControllerConfiguration;
import io.quarkiverse.operatorsdk.deployment.ContextStoredControllerConfigurations;
import io.quarkiverse.operatorsdk.deployment.ControllerConfigurationsBuildItem;
import io.quarkiverse.operatorsdk.deployment.ReconcilerInfosBuildItem;
import io.quarkiverse.operatorsdk.runtime.BuildTimeConfigurationService;
import io.quarkiverse.operatorsdk.runtime.BuildTimeControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.DependentResourceSpecMetadata;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.QuarkusInformerConfiguration;
import io.quarkiverse.operatorsdk.runtime.QuarkusKubernetesDependentResourceConfig;
import io.quarkiverse.operatorsdk.runtime.QuarkusManagedWorkflow;
import io.quarkiverse.operatorsdk.runtime.QuarkusWorkflowSpec;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class QuarkusControllerConfigurationBuildStep {
    static final Logger log = Logger.getLogger((String)QuarkusControllerConfigurationBuildStep.class.getName());
    private static final ManagedWorkflowSupport workflowSupport = new ManagedWorkflowSupport();
    private static final KubernetesDependentConverter KUBERNETES_DEPENDENT_CONVERTER = new KubernetesDependentConverter(){

        public KubernetesDependentResourceConfig configFrom(KubernetesDependent configAnnotation, DependentResourceSpec spec, ControllerConfiguration controllerConfig) {
            KubernetesDependentResourceConfig original = super.configFrom(configAnnotation, spec, controllerConfig);
            return new QuarkusKubernetesDependentResourceConfig(original.useSSA(), original.createResourceOnlyIfNotExistingWithSSA(), new QuarkusInformerConfiguration(original.informerConfig()));
        }
    };
    private static final Supplier<AnnotationInstance> NULL_ANNOTATION_SUPPLIER = () -> null;
    public static final Supplier<String[]> NULL_STRING_ARRAY_SUPPLIER = () -> null;
    public static final Supplier<String> NULL_STRING_SUPPLIER = () -> null;

    QuarkusControllerConfigurationBuildStep() {
    }

    @BuildStep
    ControllerConfigurationsBuildItem createControllerConfigurations(BuildTimeConfigurationServiceBuildItem buildTimeConfigurationServiceBuildItem, ReconcilerInfosBuildItem reconcilers, AnnotationConfigurablesBuildItem annotationConfigurables, BuildTimeOperatorConfiguration buildTimeConfiguration, CombinedIndexBuildItem combinedIndexBuildItem, LiveReloadBuildItem liveReload) {
        ContextStoredControllerConfigurations maybeStoredConfigurations = (ContextStoredControllerConfigurations)liveReload.getContextObject(ContextStoredControllerConfigurations.class);
        ContextStoredControllerConfigurations storedConfigurations = maybeStoredConfigurations != null ? maybeStoredConfigurations : new ContextStoredControllerConfigurations();
        liveReload.setContextObject(ContextStoredControllerConfigurations.class, (Object)storedConfigurations);
        Set changedClasses = ConfigurationUtils.getChangedClasses((LiveReloadBuildItem)liveReload);
        Set changedResources = liveReload.getChangedResources();
        List<QuarkusControllerConfiguration> collect = reconcilers.getReconcilers().values().stream().map(reconcilerInfo -> {
            ClassInfo info = reconcilerInfo.classInfo();
            String reconcilerClassName = info.toString();
            QuarkusControllerConfiguration configuration = null;
            if (liveReload.isLiveReload()) {
                configuration = storedConfigurations.configurationOrNullIfNeedGeneration(reconcilerClassName, changedClasses, changedResources);
            }
            if (configuration == null) {
                configuration = QuarkusControllerConfigurationBuildStep.createConfiguration(reconcilerInfo, annotationConfigurables.getConfigurableInfos(), buildTimeConfigurationServiceBuildItem.getConfigurationService(), buildTimeConfiguration, combinedIndexBuildItem.getIndex());
            }
            storedConfigurations.recordConfiguration(configuration);
            return configuration;
        }).collect(Collectors.toList());
        liveReload.setContextObject(ContextStoredControllerConfigurations.class, (Object)storedConfigurations);
        return new ControllerConfigurationsBuildItem(collect);
    }

    static QuarkusControllerConfiguration createConfiguration(ReconcilerAugmentedClassInfo reconcilerInfo, Map<String, AnnotationConfigurableAugmentedClassInfo> configurableInfos, BuildTimeConfigurationService buildTimeConfigurationService, BuildTimeOperatorConfiguration buildTimeConfiguration, IndexView index) {
        boolean wereNamespacesSet;
        ClassInfo info = reconcilerInfo.classInfo();
        String reconcilerClassName = info.toString();
        String name = reconcilerInfo.nameOrFailIfUnset();
        AnnotationInstance controllerAnnotation = info.declaredAnnotation(io.quarkiverse.operatorsdk.common.Constants.CONTROLLER_CONFIGURATION);
        BuildTimeControllerConfiguration externalConfiguration = (BuildTimeControllerConfiguration)buildTimeConfiguration.controllers().get(name);
        BuildTimeHybridControllerConfiguration configExtractor = new BuildTimeHybridControllerConfiguration(buildTimeConfiguration, externalConfiguration, controllerAnnotation);
        Duration maxReconciliationInterval = null;
        OnAddFilter onAddFilter = null;
        OnUpdateFilter onUpdateFilter = null;
        GenericFilter genericFilter = null;
        Class retryClass = GenericRetry.class;
        Class<?> retryConfigurationClass = null;
        Class rateLimiterClass = QuarkusControllerConfiguration.DefaultRateLimiter.class;
        Class<?> rateLimiterConfigurationClass = null;
        Long nullableInformerListLimit = null;
        String fieldManager = null;
        ItemStore itemStore = null;
        Set namespaces = null;
        String informerName = null;
        String labelSelector = null;
        if (controllerAnnotation != null) {
            AnnotationInstance informerConfigAnnotation;
            AnnotationInstance intervalFromAnnotation = (AnnotationInstance)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"maxReconciliationInterval", AnnotationValue::asNested, NULL_ANNOTATION_SUPPLIER);
            Long interval = (Long)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)intervalFromAnnotation, (String)"interval", AnnotationValue::asLong, () -> 10L);
            TimeUnit timeUnit = (TimeUnit)((Object)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)intervalFromAnnotation, (String)"timeUnit", av -> TimeUnit.valueOf(av.asEnum()), () -> TimeUnit.HOURS));
            if (interval > 0L) {
                maxReconciliationInterval = Duration.of(interval, timeUnit.toChronoUnit());
            }
            if ((informerConfigAnnotation = (AnnotationInstance)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"informer", AnnotationValue::asNested, NULL_ANNOTATION_SUPPLIER)) != null) {
                onAddFilter = (OnAddFilter)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)informerConfigAnnotation, (String)"onAddFilter", OnAddFilter.class, OnAddFilter.class, (boolean)true, (IndexView)index);
                onUpdateFilter = (OnUpdateFilter)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)informerConfigAnnotation, (String)"onUpdateFilter", OnUpdateFilter.class, OnUpdateFilter.class, (boolean)true, (IndexView)index);
                genericFilter = (GenericFilter)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)informerConfigAnnotation, (String)"genericFilter", GenericFilter.class, GenericFilter.class, (boolean)true, (IndexView)index);
                retryClass = (Class)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)informerConfigAnnotation, (String)"retry", av -> ClassLoadingUtils.loadClass((String)av.asClass().name().toString(), Retry.class), () -> GenericRetry.class);
                nullableInformerListLimit = (Long)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)informerConfigAnnotation, (String)"informerListLimit", AnnotationValue::asLong, () -> null);
                itemStore = (ItemStore)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)informerConfigAnnotation, (String)"itemStore", ItemStore.class, ItemStore.class, (boolean)true, (IndexView)index);
                informerName = (String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)informerConfigAnnotation, (String)"name", AnnotationValue::asString, NULL_STRING_SUPPLIER);
                labelSelector = (String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)informerConfigAnnotation, (String)"labelSelector", AnnotationValue::asString, NULL_STRING_SUPPLIER);
                namespaces = Optional.ofNullable(informerConfigAnnotation.value("namespaces")).map(v -> new HashSet<String>(Arrays.asList(v.asStringArray()))).orElse(null);
            }
            AnnotationConfigurableAugmentedClassInfo retryConfigurableInfo = configurableInfos.get(retryClass.getName());
            retryConfigurationClass = QuarkusControllerConfigurationBuildStep.getConfigurationAnnotationClass((SelectiveAugmentedClassInfo)reconcilerInfo, retryConfigurableInfo);
            rateLimiterClass = (Class)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"rateLimiter", av -> ClassLoadingUtils.loadClass((String)av.asClass().name().toString(), RateLimiter.class), () -> QuarkusControllerConfiguration.DefaultRateLimiter.class);
            AnnotationConfigurableAugmentedClassInfo rateLimiterConfigurableInfo = configurableInfos.get(rateLimiterClass.getName());
            rateLimiterConfigurationClass = QuarkusControllerConfigurationBuildStep.getConfigurationAnnotationClass((SelectiveAugmentedClassInfo)reconcilerInfo, rateLimiterConfigurableInfo);
            fieldManager = (String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"fieldManager", AnnotationValue::asString, NULL_STRING_SUPPLIER);
        }
        List<PolicyRule> additionalRBACRules = QuarkusControllerConfigurationBuildStep.extractAdditionalRBACRules(info);
        List<RoleRef> additionalRBACRoleRefs = QuarkusControllerConfigurationBuildStep.extractAdditionalRBACRoleRefs(info);
        if (namespaces == null) {
            namespaces = Constants.DEFAULT_NAMESPACES_SET;
            wereNamespacesSet = false;
        } else {
            wereNamespacesSet = true;
        }
        Set buildTimeNamespaces = configExtractor.generateWithWatchedNamespaces(wereNamespacesSet);
        if (buildTimeNamespaces != null) {
            namespaces = buildTimeNamespaces;
        }
        ReconciledAugmentedClassInfo primaryInfo = reconcilerInfo.associatedResourceInfo();
        ReconciledResourceAugmentedClassInfo primaryAsResource = primaryInfo.asResourceTargeting();
        Class resourceClass = primaryInfo.loadAssociatedClass();
        String resourceFullName = primaryAsResource.fullResourceName();
        InformerConfiguration informerConfiguration = InformerConfiguration.builder((Class)resourceClass).withName(informerName).withNamespaces(namespaces).withLabelSelector(labelSelector).withGenericFilter(genericFilter).withOnAddFilter(onAddFilter).withOnUpdateFilter(onUpdateFilter).withItemStore(itemStore).withInformerListLimit(nullableInformerListLimit).buildForController();
        QuarkusInformerConfiguration informerConfig = new QuarkusInformerConfiguration(informerConfiguration);
        QuarkusControllerConfiguration configuration = new QuarkusControllerConfiguration(reconcilerClassName, name, resourceFullName, primaryAsResource.version(), configExtractor.generationAware(), resourceClass, wereNamespacesSet, QuarkusControllerConfigurationBuildStep.getFinalizer(controllerAnnotation, resourceFullName), primaryAsResource.hasNonVoidStatus(), maxReconciliationInterval, retryClass, retryConfigurationClass, rateLimiterClass, rateLimiterConfigurationClass, additionalRBACRules, additionalRBACRoleRefs, fieldManager, informerConfig);
        configuration.setParent((ConfigurationService)buildTimeConfigurationService);
        QuarkusControllerConfigurationBuildStep.initializeWorkflowIfNeeded(configuration, reconcilerInfo, index);
        log.infov("Processed ''{0}'' reconciler named ''{1}'' for ''{2}'' resource (version ''{3}'')", new Object[]{reconcilerClassName, name, resourceFullName, HasMetadata.getApiVersion((Class)resourceClass)});
        return configuration;
    }

    private static <R extends HasMetadata> void initializeWorkflowIfNeeded(QuarkusControllerConfiguration<R> configuration, ReconcilerAugmentedClassInfo reconcilerInfo, IndexView index) {
        Collection dependentResourceInfos;
        AnnotationInstance workflowAnnotation = reconcilerInfo.classInfo().declaredAnnotation(io.quarkiverse.operatorsdk.common.Constants.WORKFLOW);
        QuarkusManagedWorkflow workflow = QuarkusManagedWorkflow.noOpManagedWorkflow;
        if (workflowAnnotation != null && !(dependentResourceInfos = reconcilerInfo.getDependentResourceInfos()).isEmpty()) {
            HashMap dependentResources = new HashMap(dependentResourceInfos.size());
            dependentResourceInfos.forEach(dependent -> {
                DependentResourceSpecMetadata spec = QuarkusControllerConfigurationBuildStep.createDependentResourceSpec(dependent, index, configuration);
                DotName dependentName = dependent.classInfo().name();
                dependentResources.put(dependentName.toString(), spec);
            });
            Boolean explicitInvocation = (Boolean)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)workflowAnnotation, (String)"explicitInvocation", AnnotationValue::asBoolean, () -> false);
            Boolean handleExceptionsInReconciler = (Boolean)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)workflowAnnotation, (String)"handleExceptionsInReconciler", AnnotationValue::asBoolean, () -> false);
            QuarkusWorkflowSpec spec = new QuarkusWorkflowSpec(dependentResources, explicitInvocation.booleanValue(), handleExceptionsInReconciler.booleanValue());
            ManagedWorkflow original = workflowSupport.createWorkflow((WorkflowSpec)spec);
            workflow = new QuarkusManagedWorkflow(spec, original.getOrderedSpecs(), original.hasCleaner());
        }
        configuration.setWorkflow(workflow);
    }

    private static List<PolicyRule> extractAdditionalRBACRules(ClassInfo info) {
        return QuarkusControllerConfigurationBuildStep.extractRepeatableAnnotations(info, io.quarkiverse.operatorsdk.common.Constants.RBAC_RULE, io.quarkiverse.operatorsdk.common.Constants.ADDITIONAL_RBAC_RULES, QuarkusControllerConfigurationBuildStep::extractRule);
    }

    private static <T> List<T> extractRepeatableAnnotations(ClassInfo info, DotName singleAnnotationName, DotName repeatableHolderName, Function<AnnotationInstance, T> extractor) {
        AnnotationInstance singleAnnotation;
        AnnotationInstance[] additionalAnnotations = (AnnotationInstance[])ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)info.declaredAnnotation(repeatableHolderName), (String)"value", AnnotationValue::asNestedArray, () -> null);
        List repeatables = Collections.emptyList();
        if (additionalAnnotations != null && additionalAnnotations.length > 0) {
            repeatables = new ArrayList(additionalAnnotations.length);
            for (AnnotationInstance annotation : additionalAnnotations) {
                repeatables.add(extractor.apply(annotation));
            }
        }
        if ((singleAnnotation = info.declaredAnnotation(singleAnnotationName)) != null) {
            repeatables = List.of(extractor.apply(singleAnnotation));
        }
        return repeatables;
    }

    private static List<RoleRef> extractAdditionalRBACRoleRefs(ClassInfo info) {
        return QuarkusControllerConfigurationBuildStep.extractRepeatableAnnotations(info, io.quarkiverse.operatorsdk.common.Constants.RBAC_ROLE_REF, io.quarkiverse.operatorsdk.common.Constants.ADDITIONAL_RBAC_ROLE_REFS, QuarkusControllerConfigurationBuildStep::extractRoleRef);
    }

    private static PolicyRule extractRule(AnnotationInstance ruleAnnotation) {
        PolicyRuleBuilder builder = new PolicyRuleBuilder();
        builder.withApiGroups((String[])ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)ruleAnnotation, (String)"apiGroups", AnnotationValue::asStringArray, NULL_STRING_ARRAY_SUPPLIER));
        builder.withVerbs((String[])ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)ruleAnnotation, (String)"verbs", AnnotationValue::asStringArray, NULL_STRING_ARRAY_SUPPLIER));
        builder.withResources((String[])ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)ruleAnnotation, (String)"resources", AnnotationValue::asStringArray, NULL_STRING_ARRAY_SUPPLIER));
        builder.withResourceNames((String[])ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)ruleAnnotation, (String)"resourceNames", AnnotationValue::asStringArray, NULL_STRING_ARRAY_SUPPLIER));
        builder.withNonResourceURLs((String[])ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)ruleAnnotation, (String)"nonResourceURLs", AnnotationValue::asStringArray, NULL_STRING_ARRAY_SUPPLIER));
        return builder.build();
    }

    private static RoleRef extractRoleRef(AnnotationInstance roleRefAnnotation) {
        RoleRefBuilder builder = new RoleRefBuilder();
        builder.withApiGroup("rbac.authorization.k8s.io");
        builder.withKind((String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)roleRefAnnotation, (String)"kind", AnnotationValue::asEnum, () -> null));
        builder.withName((String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)roleRefAnnotation, (String)"name", AnnotationValue::asString, NULL_STRING_SUPPLIER));
        return builder.build();
    }

    private static Class<?> getConfigurationAnnotationClass(SelectiveAugmentedClassInfo configurationTargetInfo, AnnotationConfigurableAugmentedClassInfo configurableInfo) {
        if (configurableInfo != null) {
            DotName associatedConfigurationClass = configurableInfo.getAssociatedConfigurationClass();
            if (configurationTargetInfo.classInfo().annotationsMap().containsKey(associatedConfigurationClass)) {
                return ClassLoadingUtils.loadClass((String)associatedConfigurationClass.toString(), Object.class);
            }
        }
        return null;
    }

    private static DependentResourceSpecMetadata createDependentResourceSpec(DependentResourceAugmentedClassInfo dependent, IndexView index, QuarkusControllerConfiguration configuration) {
        ClassInfo dependentResourceType = dependent.classInfo();
        DotName drTypeName = dependentResourceType.name();
        List types = JandexUtil.resolveTypeParameters((DotName)drTypeName, (DotName)io.quarkiverse.operatorsdk.common.Constants.DEPENDENT_RESOURCE, (IndexView)index);
        if (types.size() != 2) {
            throw new IllegalArgumentException("Improperly parameterized DependentResource implementation: " + drTypeName.toString());
        }
        String resourceTypeName = ((Type)types.get(0)).name().toString();
        String dependentTypeName = drTypeName.toString();
        Class dependentClass = ClassLoadingUtils.loadClass((String)dependentTypeName, DependentResource.class);
        Class resourceClass = ClassLoadingUtils.loadClass((String)resourceTypeName, Object.class);
        AnnotationInstance dependentConfig = dependent.getDependentAnnotationFromController();
        AnnotationValue dependsOnField = dependentConfig.value("dependsOn");
        Set dependsOn = Optional.ofNullable(dependsOnField).map(AnnotationValue::asStringArray).filter(array -> ((String[])array).length > 0).map(Set::of).orElse(Collections.emptySet());
        Condition readyCondition = (Condition)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)dependentConfig, (String)"readyPostcondition", Condition.class, Condition.class, (boolean)true, (IndexView)index);
        Condition reconcilePrecondition = (Condition)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)dependentConfig, (String)"reconcilePrecondition", Condition.class, Condition.class, (boolean)true, (IndexView)index);
        Condition deletePostcondition = (Condition)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)dependentConfig, (String)"deletePostcondition", Condition.class, Condition.class, (boolean)true, (IndexView)index);
        Condition activationCondition = (Condition)ConfigurationUtils.instantiateImplementationClass((AnnotationInstance)dependentConfig, (String)"activationCondition", Condition.class, Condition.class, (boolean)true, (IndexView)index);
        String useEventSourceWithName = (String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)dependentConfig, (String)"useEventSourceWithName", AnnotationValue::asString, NULL_STRING_SUPPLIER);
        DependentResourceSpecMetadata spec = new DependentResourceSpecMetadata(dependentClass, dependent.nameOrFailIfUnset(), dependsOn, readyCondition, reconcilePrecondition, deletePostcondition, activationCondition, useEventSourceWithName, resourceClass);
        DependentResourceConfigurationResolver.configureSpecFromConfigured((DependentResourceSpec)spec, (ControllerConfiguration)configuration, (Class)dependentClass);
        return spec;
    }

    private static String getFinalizer(AnnotationInstance controllerAnnotation, String crdName) {
        return (String)ConfigurationUtils.annotationValueOrDefault((AnnotationInstance)controllerAnnotation, (String)"finalizerName", AnnotationValue::asString, () -> ReconcilerUtils.getDefaultFinalizerName((String)crdName));
    }

    static {
        DependentResourceConfigurationResolver.registerConverter(KubernetesDependentResource.class, (ConfigurationConverter)KUBERNETES_DEPENDENT_CONVERTER);
    }
}

