/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.kubernetes.api.model.rbac.RoleRef;
import io.quarkiverse.operatorsdk.deployment.ClusterRoles;
import io.quarkiverse.operatorsdk.deployment.ControllerConfigurationsBuildItem;
import io.quarkiverse.operatorsdk.deployment.RoleBindings;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.kubernetes.deployment.KubernetesConfig;
import io.quarkus.kubernetes.deployment.PlatformConfiguration;
import io.quarkus.kubernetes.deployment.ResourceNameUtil;
import io.quarkus.kubernetes.spi.KubernetesClusterRoleBindingBuildItem;
import io.quarkus.kubernetes.spi.KubernetesClusterRoleBuildItem;
import io.quarkus.kubernetes.spi.KubernetesEffectiveServiceAccountBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBindingBuildItem;
import io.quarkus.kubernetes.spi.Subject;
import io.quarkus.kubernetes.spi.Targetable;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;

public class RBACAugmentationStep {
    private static final String ANY_TARGET = null;

    @BuildStep(onlyIf={IsRBACEnabled.class})
    @Produce(value=ArtifactResultBuildItem.class)
    void augmentRBACForResources(BuildTimeOperatorConfiguration buildTimeConfiguration, ControllerConfigurationsBuildItem configurations, KubernetesConfig kubernetesConfig, ApplicationInfoBuildItem applicationInfo, List<KubernetesEffectiveServiceAccountBuildItem> effectiveServiceAccounts, BuildProducer<KubernetesClusterRoleBuildItem> clusterRolesProducer, BuildProducer<KubernetesRoleBindingBuildItem> roleBindingsProducer, BuildProducer<KubernetesClusterRoleBindingBuildItem> clusterRoleBindingsProducer) {
        String serviceAccountNamespace;
        String serviceAccountName;
        Collection<QuarkusControllerConfiguration<?>> configs = configurations.getControllerConfigs().values();
        ClusterRoles.createClusterRoles(configs, buildTimeConfiguration.crd().validate()).forEach(clusterRole -> clusterRolesProducer.produce((BuildItem)RBACAugmentationStep.clusterRoleBuildItemFrom(clusterRole)));
        List potentialSAs = Targetable.filteredByTarget(effectiveServiceAccounts, (String)"kubernetes").toList();
        if (potentialSAs.isEmpty()) {
            serviceAccountName = ResourceNameUtil.getResourceName((PlatformConfiguration)kubernetesConfig, (ApplicationInfoBuildItem)applicationInfo);
            serviceAccountNamespace = kubernetesConfig.namespace().orElse(null);
        } else {
            if (potentialSAs.size() > 1) {
                throw new IllegalStateException("More than one effective service account found for application " + applicationInfo.getName());
            }
            KubernetesEffectiveServiceAccountBuildItem serviceAccount = (KubernetesEffectiveServiceAccountBuildItem)potentialSAs.get(0);
            serviceAccountName = serviceAccount.getServiceAccountName();
            serviceAccountNamespace = serviceAccount.getNamespace();
        }
        RoleBindings.createRoleBindings(configs, buildTimeConfiguration, serviceAccountName, serviceAccountNamespace).forEach(binding -> roleBindingsProducer.produce((BuildItem)this.roleBindingItemFor((RoleBinding)binding)));
        RoleBindings.createClusterRoleBindings(configs, buildTimeConfiguration, serviceAccountName, serviceAccountNamespace).forEach(binding -> clusterRoleBindingsProducer.produce((BuildItem)this.clusterRoleBindingFor((ClusterRoleBinding)binding)));
    }

    private KubernetesRoleBindingBuildItem roleBindingItemFor(RoleBinding binding) {
        io.quarkus.kubernetes.spi.RoleRef roleRef = RBACAugmentationStep.convertToQuarkusRoleRef(binding.getRoleRef());
        Subject[] subjects = (Subject[])binding.getSubjects().stream().map(RBACAugmentationStep::convertToQuarkusSubject).toArray(Subject[]::new);
        return new KubernetesRoleBindingBuildItem(binding.getMetadata().getName(), binding.getMetadata().getNamespace(), ANY_TARGET, binding.getMetadata().getLabels(), roleRef, subjects);
    }

    private KubernetesClusterRoleBindingBuildItem clusterRoleBindingFor(ClusterRoleBinding binding) {
        io.quarkus.kubernetes.spi.RoleRef roleRef = RBACAugmentationStep.convertToQuarkusRoleRef(binding.getRoleRef());
        Subject[] subjects = (Subject[])binding.getSubjects().stream().map(RBACAugmentationStep::convertToQuarkusSubject).toArray(Subject[]::new);
        return new KubernetesClusterRoleBindingBuildItem(binding.getMetadata().getName(), ANY_TARGET, binding.getMetadata().getLabels(), roleRef, subjects);
    }

    private static Subject convertToQuarkusSubject(io.fabric8.kubernetes.api.model.rbac.Subject subject) {
        return new Subject(subject.getApiGroup(), subject.getKind(), subject.getName(), subject.getNamespace());
    }

    private static io.quarkus.kubernetes.spi.RoleRef convertToQuarkusRoleRef(RoleRef roleRef) {
        return new io.quarkus.kubernetes.spi.RoleRef(roleRef.getName(), "ClusterRole".equals(roleRef.getKind()));
    }

    private static KubernetesClusterRoleBuildItem clusterRoleBuildItemFrom(ClusterRole clusterRole) {
        return new KubernetesClusterRoleBuildItem(clusterRole.getMetadata().getName(), clusterRole.getRules().stream().map(RBACAugmentationStep::convertToQuarkusPolicyRule).toList(), ANY_TARGET);
    }

    private static io.quarkus.kubernetes.spi.PolicyRule convertToQuarkusPolicyRule(PolicyRule pr) {
        return new io.quarkus.kubernetes.spi.PolicyRule(pr.getApiGroups(), pr.getNonResourceURLs(), pr.getResourceNames(), pr.getResources(), pr.getVerbs());
    }

    private static class IsRBACEnabled
    implements BooleanSupplier {
        private BuildTimeOperatorConfiguration config;

        private IsRBACEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.config.disableRbacGeneration() == false;
        }
    }
}

