/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluent;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingBuilder;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent;
import io.fabric8.kubernetes.api.model.rbac.RoleRef;
import io.fabric8.kubernetes.api.model.rbac.RoleRefBuilder;
import io.javaoperatorsdk.operator.api.config.informer.InformerConfiguration;
import io.quarkiverse.operatorsdk.deployment.ClusterRoles;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.logging.Logger;

public class RoleBindings {
    public static final String CLUSTER_ROLE = "ClusterRole";
    protected static final String RBAC_AUTHORIZATION_GROUP = "rbac.authorization.k8s.io";
    public static final RoleRef CRD_VALIDATING_ROLE_REF = new RoleRef("rbac.authorization.k8s.io", "ClusterRole", "josdk-crd-validating-cluster-role");
    protected static final String SERVICE_ACCOUNT = "ServiceAccount";
    private static final Logger log = Logger.getLogger(RoleBindings.class);
    private static final ConcurrentMap<QuarkusControllerConfiguration, BindingsHolder> cachedBindings = new ConcurrentHashMap<QuarkusControllerConfiguration, BindingsHolder>();

    public static String getCRDValidatingBindingName(String controllerName) {
        return controllerName + "-crd-validating-role-binding";
    }

    public static String getClusterRoleBindingName(String controllerName) {
        return controllerName + "-cluster-role-binding";
    }

    public static String getRoleBindingName(String controllerName) {
        return controllerName + "-role-binding";
    }

    public static String getSpecificRoleBindingName(String controllerName, String roleRefName) {
        return roleRefName + "-" + RoleBindings.getRoleBindingName(controllerName);
    }

    public static String getSpecificRoleBindingName(String controllerName, RoleRef roleRef) {
        return RoleBindings.getSpecificRoleBindingName(controllerName, roleRef.getName());
    }

    private static RoleRef createDefaultRoleRef(String controllerName) {
        return ((RoleRefBuilder)((RoleRefBuilder)((RoleRefBuilder)new RoleRefBuilder().withApiGroup(RBAC_AUTHORIZATION_GROUP)).withKind(CLUSTER_ROLE)).withName(ClusterRoles.getClusterRoleName(controllerName))).build();
    }

    private static RoleBinding createRoleBinding(String roleBindingName, String serviceAccountName, String serviceAccountNamespace, String targetNamespace, RoleRef roleRef) {
        String nsMsg = (String)(targetNamespace == null ? "current" : "'" + targetNamespace + "'") + " namespace";
        log.infov("Creating ''{0}'' RoleBinding to be applied to {1}", (Object)roleBindingName, (Object)nsMsg);
        return ((RoleBindingBuilder)((RoleBindingBuilder)((RoleBindingBuilder)((RoleBindingFluent.MetadataNested)((RoleBindingFluent.MetadataNested)new RoleBindingBuilder().withNewMetadata().withName(roleBindingName)).withNamespace(targetNamespace)).endMetadata()).withRoleRef(roleRef)).addNewSubject(null, SERVICE_ACCOUNT, serviceAccountName, serviceAccountNamespace)).build();
    }

    private static ClusterRoleBinding createClusterRoleBinding(String bindingName, String serviceAccountName, String serviceAccountNamespace, String controllerName, String controllerConfMessage, RoleRef roleRef) {
        RoleBindings.outputWarningIfNeeded(serviceAccountNamespace, controllerName, bindingName, controllerConfMessage);
        roleRef = roleRef == null ? RoleBindings.createDefaultRoleRef(controllerName) : roleRef;
        log.infov("Creating ''{0}'' ClusterRoleBinding to be applied to ''{1}'' namespace", (Object)bindingName, (Object)serviceAccountNamespace);
        return ((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.SubjectsNested)((ClusterRoleBindingFluent.SubjectsNested)((ClusterRoleBindingFluent.SubjectsNested)((ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.MetadataNested)new ClusterRoleBindingBuilder().withNewMetadata().withName(bindingName)).endMetadata()).withRoleRef(roleRef)).addNewSubject().withKind(SERVICE_ACCOUNT)).withName(serviceAccountName)).withNamespace(serviceAccountNamespace)).endSubject()).build();
    }

    private static void outputWarningIfNeeded(String serviceAccountNamespace, String controllerName, String crBindingName, String controllerConfMessage) {
        if (serviceAccountNamespace == null || serviceAccountNamespace.isEmpty()) {
            log.warnv("''{0}'' controller is configured to " + controllerConfMessage + ", this requires a ClusterRoleBinding which REQUIRES a namespace for the operator ServiceAccount, which has NOT been provided. You can specify the ServiceAccount's namespace using the ''quarkus.kubernetes.rbac.service-accounts.<service account name>.namespace=<service account namespace>'' property (or, alternatively, ''quarkus.kubernetes.namespace'', though using this property will use the specified namespace for ALL your resources. Leaving the namespace blank to be provided by the user by editing the ''{1}'' ClusterRoleBinding to provide the namespace in which the operator will be deployed.", (Object)controllerName, (Object)crBindingName);
        }
    }

    public static List<RoleBinding> createRoleBindings(Collection<QuarkusControllerConfiguration<?>> configs, BuildTimeOperatorConfiguration operatorConfiguration, String serviceAccountName, String serviceAccountNamespace) {
        return configs.stream().flatMap(config -> RoleBindings.bindingsFor(config, operatorConfiguration, serviceAccountName, serviceAccountNamespace).getRoleBindings().stream()).toList();
    }

    public static List<ClusterRoleBinding> createClusterRoleBindings(Collection<QuarkusControllerConfiguration<?>> configs, BuildTimeOperatorConfiguration operatorConfiguration, String serviceAccountName, String serviceAccountNamespace) {
        return configs.stream().flatMap(config -> RoleBindings.bindingsFor(config, operatorConfiguration, serviceAccountName, serviceAccountNamespace).getClusterRoleBindings().stream()).toList();
    }

    private static BindingsHolder bindingsFor(QuarkusControllerConfiguration<?> controllerConfiguration, BuildTimeOperatorConfiguration operatorConfiguration, String serviceAccountName, String serviceAccountNamespace) {
        BindingsHolder bindings = (BindingsHolder)cachedBindings.get(controllerConfiguration);
        if (bindings != null) {
            return bindings;
        }
        bindings = new BindingsHolder();
        cachedBindings.put(controllerConfiguration, bindings);
        String controllerName = controllerConfiguration.getName();
        InformerConfiguration informerConfig = controllerConfiguration.getInformerConfig();
        Set desiredWatchedNamespaces = informerConfig.getNamespaces();
        LinkedList<RoleBinding> roleBindings = new LinkedList<RoleBinding>();
        LinkedList<ClusterRoleBinding> clusterRoleBindings = new LinkedList<ClusterRoleBinding>();
        if (operatorConfiguration.crd().validate().booleanValue()) {
            String crBindingName = RoleBindings.getCRDValidatingBindingName(controllerName);
            ClusterRoleBinding crdValidatorRoleBinding = RoleBindings.createClusterRoleBinding(crBindingName, serviceAccountName, serviceAccountNamespace, controllerName, "validate CRDs", CRD_VALIDATING_ROLE_REF);
            clusterRoleBindings.add(crdValidatorRoleBinding);
        }
        String roleBindingName = RoleBindings.getRoleBindingName(controllerName);
        if (informerConfig.watchCurrentNamespace()) {
            roleBindings.add(RoleBindings.createRoleBinding(roleBindingName, serviceAccountName, serviceAccountNamespace, null, RoleBindings.createDefaultRoleRef(controllerName)));
            controllerConfiguration.getAdditionalRBACRoleRefs().forEach(roleRef -> {
                String specificRoleBindingName = RoleBindings.getSpecificRoleBindingName(controllerName, roleRef);
                roleBindings.add(RoleBindings.createRoleBinding(specificRoleBindingName, serviceAccountName, serviceAccountNamespace, null, roleRef));
            });
        } else if (informerConfig.watchAllNamespaces()) {
            clusterRoleBindings.add(RoleBindings.createClusterRoleBinding(RoleBindings.getClusterRoleBindingName(controllerName), serviceAccountName, serviceAccountNamespace, controllerName, "watch all namespaces", null));
            controllerConfiguration.getAdditionalRBACRoleRefs().forEach(roleRef -> {
                if (!CLUSTER_ROLE.equals(roleRef.getKind())) {
                    log.warnv("Cannot create a ClusterRoleBinding for RoleRef ''{0}'' because it's not a ClusterRole", roleRef);
                } else {
                    clusterRoleBindings.add(RoleBindings.createClusterRoleBinding(roleRef.getName() + "-" + RoleBindings.getClusterRoleBindingName(controllerName), serviceAccountName, serviceAccountNamespace, controllerName, "watch all namespaces", roleRef));
                }
            });
        } else {
            desiredWatchedNamespaces.forEach(ns -> {
                roleBindings.add(RoleBindings.createRoleBinding(roleBindingName, serviceAccountName, serviceAccountNamespace, ns, RoleBindings.createDefaultRoleRef(controllerName)));
                controllerConfiguration.getAdditionalRBACRoleRefs().forEach(roleRef -> {
                    String specificRoleBindingName = RoleBindings.getSpecificRoleBindingName(controllerName, roleRef);
                    roleBindings.add(RoleBindings.createRoleBinding(specificRoleBindingName, serviceAccountName, serviceAccountNamespace, ns, roleRef));
                });
            });
        }
        bindings.setRoleBindings(roleBindings);
        bindings.setClusterRoleBindings(clusterRoleBindings);
        return bindings;
    }

    private static class BindingsHolder {
        private List<RoleBinding> roleBindings;
        private List<ClusterRoleBinding> clusterRoleBindings;

        private BindingsHolder() {
        }

        public List<RoleBinding> getRoleBindings() {
            return this.roleBindings;
        }

        public void setRoleBindings(List<RoleBinding> roleBindings) {
            this.roleBindings = roleBindings;
        }

        public List<ClusterRoleBinding> getClusterRoleBindings() {
            return this.clusterRoleBindings;
        }

        public void setClusterRoleBindings(List<ClusterRoleBinding> clusterRoleBindings) {
            this.clusterRoleBindings = clusterRoleBindings;
        }
    }
}

