/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.fabric8.kubernetes.client.CustomResource;
import io.quarkiverse.operatorsdk.common.CustomResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.FileUtils;
import io.quarkiverse.operatorsdk.deployment.CRDGenerator;
import io.quarkiverse.operatorsdk.deployment.CRDGeneratorV1;
import io.quarkiverse.operatorsdk.deployment.CRDGeneratorV2;
import io.quarkiverse.operatorsdk.runtime.CRDConfiguration;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import io.quarkiverse.operatorsdk.runtime.CRDInfo;
import io.quarkiverse.operatorsdk.runtime.CRDInfos;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.logging.Logger;

class CRDGeneration {
    private static final Logger log = Logger.getLogger((String)CRDGeneration.class.getName());
    private final LaunchMode mode;
    private final CRDConfiguration crdConfiguration;
    private CRDGenerator generator;
    private boolean needGeneration;

    CRDGeneration(CRDConfiguration crdConfig, LaunchMode mode) {
        this.crdConfiguration = crdConfig;
        this.mode = mode;
    }

    static boolean shouldGenerate(Optional<Boolean> configuredGenerate, Optional<Boolean> configuredApply, LaunchMode launchMode) {
        return CRDGeneration.shouldApply(configuredApply, launchMode) || configuredGenerate.orElse(true) != false;
    }

    static boolean shouldApply(Optional<Boolean> configuredApply, LaunchMode launchMode) {
        if (launchMode == null || !launchMode.isDevOrTest()) {
            return false;
        }
        return configuredApply.orElse(true);
    }

    boolean shouldApply() {
        return CRDGeneration.shouldApply(this.crdConfiguration.apply(), this.mode);
    }

    CRDGenerationInfo generate(OutputTargetBuildItem outputTarget, boolean validateCustomResources, CRDInfos existing, CRDInfos externalCRDs) {
        CRDInfos converted = new CRDInfos(existing);
        HashSet<String> generated = new HashSet<String>();
        externalCRDs.getCRDNameToInfoMappings().forEach((k, v) -> {
            CRDInfo alreadyAdded = converted.addCRDInfo(v);
            if (alreadyAdded == null) {
                generated.add((String)k);
            }
        });
        if (this.needGeneration) {
            Path targetDirectory = this.crdConfiguration.outputDirectory().map(d -> Paths.get("", new String[0]).toAbsolutePath().resolve((String)d)).orElse(outputTarget.getOutputDirectory().resolve("kubernetes"));
            File outputDir = targetDirectory.toFile();
            FileUtils.ensureDirectoryExists((File)outputDir);
            this.generator.generate(this.crdConfiguration.versions(), outputDir, generated, converted);
        }
        return new CRDGenerationInfo(this.shouldApply(), validateCustomResources, converted, generated);
    }

    private boolean needsGeneration(Map<String, CRDInfo> existingCRDInfos, Set<String> changedClassNames) {
        boolean[] generateCurrent = new boolean[]{true};
        this.crdConfiguration.versions().forEach(v -> {
            CRDInfo crd = (CRDInfo)existingCRDInfos.get(v);
            if (crd == null) {
                return;
            }
            if (changedClassNames != null && !changedClassNames.isEmpty()) {
                for (String changedClass : changedClassNames) {
                    if (!crd.getDependentClassNames().contains(changedClass)) continue;
                    return;
                }
            }
            log.infov("''{0}'' CRD generation was skipped for ''{1}'' because no changes impacting the CRD were detected", v, (Object)crd.getCrdName());
            generateCurrent[0] = false;
        });
        return generateCurrent[0];
    }

    boolean scheduleForGenerationIfNeeded(CustomResourceAugmentedClassInfo crInfo, Map<String, CRDInfo> existingCRDInfos, Set<String> changedClasses) {
        boolean scheduleCurrent = true;
        if (existingCRDInfos != null && !existingCRDInfos.isEmpty()) {
            scheduleCurrent = this.needsGeneration(existingCRDInfos, changedClasses);
        }
        if (scheduleCurrent) {
            this.withCustomResource(crInfo.loadAssociatedClass(), crInfo.getAssociatedReconcilerName().orElse(null));
        }
        return scheduleCurrent;
    }

    void withCustomResource(Class<? extends CustomResource<?, ?>> crClass, String associatedControllerName) {
        try {
            if (this.generator == null) {
                this.generator = this.crdConfiguration.useV1CRDGenerator() != false ? new CRDGeneratorV1(this.crdConfiguration.generateInParallel()) : new CRDGeneratorV2(this.crdConfiguration.generateInParallel());
            }
            this.generator.scheduleForGeneration(crClass);
            this.needGeneration = true;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot process " + crClass.getName() + " custom resource" + (String)(associatedControllerName != null ? " for controller '" + associatedControllerName + "'" : ""), e);
        }
    }
}

