/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.fabric8.crd.generator.CRDGenerationInfo;
import io.fabric8.crd.generator.CustomResourceInfo;
import io.fabric8.kubernetes.client.CustomResource;
import io.quarkiverse.operatorsdk.deployment.CRDGenerator;
import io.quarkiverse.operatorsdk.runtime.CRDInfo;
import io.quarkiverse.operatorsdk.runtime.CRDInfos;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;

class CRDGeneratorV1
implements CRDGenerator {
    private static final Logger log = Logger.getLogger((String)CRDGeneratorV1.class.getName());
    private final io.fabric8.crd.generator.CRDGenerator generator;

    public CRDGeneratorV1(boolean parallelGeneration) {
        this.generator = new io.fabric8.crd.generator.CRDGenerator().withParallelGenerationEnabled(parallelGeneration);
    }

    @Override
    public void generate(List<String> crdSpecVersions, File outputDir, Set<String> generated, CRDInfos converted) {
        CRDGenerationInfo info = this.generator.forCRDVersions(crdSpecVersions).inOutputDir(outputDir).detailedGenerate();
        Map crdDetailsPerNameAndVersion = info.getCRDDetailsPerNameAndVersion();
        crdDetailsPerNameAndVersion.forEach((crdName, initialVersionToCRDInfoMap) -> {
            log.infov("Generated {0} CRD:", crdName);
            generated.add((String)crdName);
            initialVersionToCRDInfoMap.forEach((crdSpecVersion, crdInfo) -> {
                String filePath = crdInfo.getFilePath();
                log.infov("  - {0} -> {1}", crdSpecVersion, (Object)filePath);
                converted.addCRDInfo(new CRDInfo(crdName, crdSpecVersion, filePath, crdInfo.getDependentClassNames()));
            });
        });
    }

    @Override
    public void scheduleForGeneration(Class<? extends CustomResource<?, ?>> crClass) {
        CustomResourceInfo info = CustomResourceInfo.fromClass(crClass);
        this.generator.customResources(new CustomResourceInfo[]{info});
    }
}

