/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.quarkiverse.operatorsdk.deployment.VersionBuildItem;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import io.quarkus.builder.Version;
import io.quarkus.deployment.annotations.BuildStep;
import java.util.Objects;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.semver4j.Semver;

public class VersionAlignmentCheckingStep {
    private static final Logger log = Logger.getLogger(VersionAlignmentCheckingStep.class);

    @BuildStep
    VersionBuildItem checkVersionsAlignment(BuildTimeOperatorConfiguration buildTimeConfiguration) {
        io.quarkiverse.operatorsdk.runtime.Version version = io.quarkiverse.operatorsdk.runtime.Version.loadFromProperties();
        log.info((Object)("QOSDK: " + version.getExtensionCompleteVersion()));
        log.info((Object)("JOSDK: " + version.getSdkCompleteVersion()));
        String runtimeFabric8Version = version.getRuntimeFabric8Version();
        log.info((Object)("Fabric8 (effective): " + runtimeFabric8Version));
        String runtimeQuarkusVersion = Version.getVersion();
        this.checkVersionCompatibility(buildTimeConfiguration, runtimeQuarkusVersion, version.getQuarkusVersion(), "Quarkus");
        String josdkFabric8Version = version.getKubernetesClientVersion();
        log.info((Object)("Fabric8 (JOSDK-defined): " + josdkFabric8Version));
        this.checkVersionCompatibility(buildTimeConfiguration, runtimeFabric8Version, josdkFabric8Version, "JOSDK Fabric8 Kubernetes Client");
        String quarkusFabric8Version = "7.1.0";
        log.info((Object)"Fabric8 (Quarkus): 7.1.0");
        this.checkVersionCompatibility(buildTimeConfiguration, runtimeFabric8Version, "7.1.0", "Quarkus-provided Fabric8 Kubernetes Client");
        return new VersionBuildItem(version);
    }

    private void checkVersionCompatibility(BuildTimeOperatorConfiguration buildTimeConfiguration, String found, String expected, String name) {
        if (Objects.equals(found, expected)) {
            return;
        }
        Optional<Semver> foundVersionOpt = VersionAlignmentCheckingStep.getSemverFrom(found);
        Optional<Semver> expectedVersionOpt = VersionAlignmentCheckingStep.getSemverFrom(expected);
        if (foundVersionOpt.isEmpty() || expectedVersionOpt.isEmpty()) {
            return;
        }
        Semver foundVersion = foundVersionOpt.get();
        Semver expectedVersion = expectedVersionOpt.get();
        if (!expectedVersion.equals((Object)foundVersion)) {
            String message = "Mismatched " + name + " version found: \"" + found + "\", expected: \"" + expected + "\"";
            if (buildTimeConfiguration.failOnVersionCheck().booleanValue()) {
                throw new RuntimeException(message);
            }
            Semver.VersionDiff diff = expectedVersion.diff(foundVersion);
            if (diff.compareTo((Enum)Semver.VersionDiff.MINOR) >= 0) {
                log.warn((Object)(message + " by at least a minor version and things might not work as expected."));
            } else {
                log.debug((Object)message);
            }
        }
    }

    private static Optional<Semver> getSemverFrom(String version) {
        try {
            return Optional.ofNullable(Semver.coerce((String)version));
        }
        catch (Exception e) {
            log.warn((Object)("Couldn't convert version " + version));
            return Optional.empty();
        }
    }
}

