/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.api.ResourceController;
import io.javaoperatorsdk.operator.api.config.AbstractConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.Version;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkus.arc.runtime.ClientProxyUnwrapper;
import java.util.List;
import java.util.stream.Stream;

public class QuarkusConfigurationService
extends AbstractConfigurationService {
    private static final ClientProxyUnwrapper unwrapper = new ClientProxyUnwrapper();
    private final KubernetesClient client;
    private final boolean checkCRDAndValidateLocalModel;

    public QuarkusConfigurationService(Version version, List<ControllerConfiguration> configurations, KubernetesClient client, boolean checkCRDAndValidateLocalModel) {
        super(version);
        this.client = client;
        if (configurations != null && !configurations.isEmpty()) {
            configurations.forEach(arg_0 -> ((QuarkusConfigurationService)this).register(arg_0));
        }
        this.checkCRDAndValidateLocalModel = checkCRDAndValidateLocalModel;
    }

    public Config getClientConfiguration() {
        return this.client.getConfiguration();
    }

    public <R extends CustomResource> QuarkusControllerConfiguration<R> getConfigurationFor(ResourceController<R> controller) {
        ResourceController<R> unwrapped = QuarkusConfigurationService.unwrap(controller);
        return (QuarkusControllerConfiguration)super.getConfigurationFor(unwrapped);
    }

    public boolean checkCRDAndValidateLocalModel() {
        return this.checkCRDAndValidateLocalModel;
    }

    private static <R extends CustomResource> ResourceController<R> unwrap(ResourceController<R> controller) {
        return (ResourceController)unwrapper.apply(controller);
    }

    protected String keyFor(ResourceController controller) {
        String controllerName = super.keyFor(controller);
        int i = controllerName.indexOf(95);
        if (i > 0) {
            controllerName = controllerName.substring(0, i);
        }
        return controllerName;
    }

    public Stream<QuarkusControllerConfiguration> configurations() {
        return this.controllerConfigurations().map(c -> (QuarkusControllerConfiguration)c);
    }

    public void updateConfiguration(QuarkusControllerConfiguration configuration) {
        this.replace(configuration);
    }
}

