/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.api.config.Version;
import io.quarkiverse.operatorsdk.runtime.QuarkusConfigurationService;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.RetryConfigurationResolver;
import io.quarkiverse.operatorsdk.runtime.RunTimeControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.RunTimeOperatorConfiguration;
import io.quarkus.arc.Arc;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Supplier;

@Recorder
public class ConfigurationServiceRecorder {
    public Supplier<QuarkusConfigurationService> configurationServiceSupplier(Version version, List<QuarkusControllerConfiguration> configurations, boolean validateCustomResources, RunTimeOperatorConfiguration runTimeConfiguration) {
        Integer maxThreads = runTimeConfiguration.concurrentReconciliationThreads.orElse(5);
        configurations.forEach(c -> {
            RunTimeControllerConfiguration extConfig = runTimeConfiguration.controllers.get(c.getName());
            if (extConfig != null) {
                extConfig.finalizer.ifPresent(c::setFinalizer);
                extConfig.namespaces.ifPresent(c::setNamespaces);
                c.setRetryConfiguration(RetryConfigurationResolver.resolve(extConfig.retry));
            }
        });
        return () -> new QuarkusConfigurationService(version, configurations, (KubernetesClient)Arc.container().instance(KubernetesClient.class, new Annotation[0]).get(), validateCustomResources, maxThreads);
    }
}

