/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.api.ResourceController;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.QuarkusConfigurationService;
import io.quarkus.arc.DefaultBean;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;

@Singleton
public class OperatorProducer {
    @Produces
    @DefaultBean
    @Singleton
    Operator operator(KubernetesClient client, QuarkusConfigurationService configuration, Instance<ResourceController<? extends CustomResource>> controllers, ObjectMapper objectMapper) {
        Operator operator = new Operator(client, (ConfigurationService)configuration, objectMapper);
        for (ResourceController controller : controllers) {
            ControllerConfiguration config = configuration.getConfigurationFor(controller);
            if (config.isRegistrationDelayed()) continue;
            operator.register(controller);
        }
        return operator;
    }
}

