/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.quarkiverse.operatorsdk.common.CustomResourceInfo;
import io.quarkiverse.operatorsdk.runtime.CRDInfo;
import io.quarkus.runtime.annotations.IgnoreProperty;
import io.quarkus.runtime.annotations.RecordableConstructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CRDGenerationInfo {
    private final boolean applyCRDs;
    private final boolean validateCRDs;
    private final Map<String, Map<String, CRDInfo>> crds;
    private final Set<String> generated;
    private final Map<String, CustomResourceInfo> controllerToCRI;

    @RecordableConstructor
    public CRDGenerationInfo(boolean applyCRDs, boolean validateCRDs, Map<String, Map<String, CRDInfo>> crds, Set<String> generated) {
        this.applyCRDs = applyCRDs;
        this.validateCRDs = validateCRDs;
        this.crds = Collections.unmodifiableMap(crds);
        this.generated = generated;
        HashMap mappings = new HashMap(crds.size());
        crds.values().forEach(crdInfos -> crdInfos.values().forEach(info -> info.getVersions().values().forEach(cri -> {
            String controllerName = cri.getControllerName();
            if (!mappings.containsKey(controllerName)) {
                mappings.put(controllerName, cri);
            }
        })));
        this.controllerToCRI = Collections.unmodifiableMap(mappings);
    }

    public Map<String, Map<String, CRDInfo>> getCrds() {
        return this.crds;
    }

    public Set<String> getGenerated() {
        return this.generated;
    }

    public boolean isApplyCRDs() {
        return this.applyCRDs;
    }

    public boolean shouldApplyCRD(String name) {
        return this.generated.contains(name);
    }

    @IgnoreProperty
    public Map<String, CRDInfo> getCRDInfosFor(String crdName) {
        return this.crds.get(crdName);
    }

    public boolean isValidateCRDs() {
        return this.validateCRDs;
    }

    @IgnoreProperty
    public Map<String, CustomResourceInfo> getControllerToCustomResourceMappings() {
        return this.controllerToCRI;
    }
}

