/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.Metrics;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import io.quarkiverse.operatorsdk.runtime.QuarkusConfigurationService;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.RetryConfigurationResolver;
import io.quarkiverse.operatorsdk.runtime.RunTimeControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.RunTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.Version;
import io.quarkus.arc.Arc;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Supplier;

@Recorder
public class ConfigurationServiceRecorder {
    public Supplier<QuarkusConfigurationService> configurationServiceSupplier(Version version, List<QuarkusControllerConfiguration> configurations, CRDGenerationInfo crdInfo, RunTimeOperatorConfiguration runTimeConfiguration) {
        Integer maxThreads = runTimeConfiguration.concurrentReconciliationThreads.orElse(5);
        Integer timeout = runTimeConfiguration.terminationTimeoutSeconds.orElse(10);
        configurations.forEach(c -> {
            RunTimeControllerConfiguration extConfig = runTimeConfiguration.controllers.get(c.getName());
            runTimeConfiguration.finalizer.ifPresent(c::setFinalizer);
            runTimeConfiguration.namespaces.ifPresent(c::setNamespaces);
            if (extConfig != null) {
                extConfig.finalizer.ifPresent(c::setFinalizer);
                extConfig.namespaces.ifPresent(c::setNamespaces);
                extConfig.selector.ifPresent(c::setLabelSelector);
                c.setRetryConfiguration(RetryConfigurationResolver.resolve(extConfig.retry));
            }
        });
        return () -> new QuarkusConfigurationService(version, configurations, (KubernetesClient)Arc.container().instance(KubernetesClient.class, new Annotation[0]).get(), crdInfo, maxThreads, timeout, (ObjectMapper)Arc.container().instance(ObjectMapper.class, new Annotation[0]).get(), (Metrics)Arc.container().instance(Metrics.class, new Annotation[0]).get());
    }
}

