/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.Metrics;
import io.javaoperatorsdk.operator.api.ResourceController;
import io.javaoperatorsdk.operator.api.config.AbstractConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.Version;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkus.arc.runtime.ClientProxyUnwrapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuarkusConfigurationService
extends AbstractConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(QuarkusConfigurationService.class);
    private static final ClientProxyUnwrapper unwrapper = new ClientProxyUnwrapper();
    private final KubernetesClient client;
    private final CRDGenerationInfo crdInfo;
    private final int concurrentReconciliationThreads;
    private final ObjectMapper mapper;
    private int terminationTimeout;
    private final Map<String, String> controllerClassToName;
    private final Metrics metrics;

    public QuarkusConfigurationService(Version version, List<QuarkusControllerConfiguration> configurations, KubernetesClient client, CRDGenerationInfo crdInfo, int maxThreads, int timeout, ObjectMapper mapper, Metrics metrics) {
        super(version);
        this.client = client;
        this.mapper = mapper;
        this.metrics = metrics;
        if (configurations != null && !configurations.isEmpty()) {
            this.controllerClassToName = new HashMap<String, String>(configurations.size());
            configurations.forEach(c -> {
                this.controllerClassToName.put(c.getAssociatedControllerClassName(), c.getName());
                this.register((ControllerConfiguration)c);
            });
        } else {
            this.controllerClassToName = Collections.emptyMap();
        }
        this.crdInfo = crdInfo;
        this.concurrentReconciliationThreads = maxThreads;
        this.terminationTimeout = timeout;
    }

    public Config getClientConfiguration() {
        return this.client.getConfiguration();
    }

    public <R extends CustomResource> QuarkusControllerConfiguration<R> getConfigurationFor(ResourceController<R> controller) {
        ResourceController<R> unwrapped = QuarkusConfigurationService.unwrap(controller);
        return (QuarkusControllerConfiguration)super.getConfigurationFor(unwrapped);
    }

    public boolean checkCRDAndValidateLocalModel() {
        return this.crdInfo.isValidateCRDs();
    }

    private static <R extends CustomResource> ResourceController<R> unwrap(ResourceController<R> controller) {
        return (ResourceController)unwrapper.apply(controller);
    }

    protected String keyFor(ResourceController controller) {
        String controllerName;
        String controllerClass = controller.getClass().getName();
        int i = controllerClass.indexOf(95);
        if (i > 0) {
            controllerClass = controllerClass.substring(0, i);
        }
        if ((controllerName = this.controllerClassToName.get(controllerClass)) == null) {
            throw new IllegalArgumentException("Unknown controller " + controllerClass);
        }
        return controllerName;
    }

    public int concurrentReconciliationThreads() {
        return this.concurrentReconciliationThreads;
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public int getTerminationTimeoutSeconds() {
        return this.terminationTimeout;
    }

    public CRDGenerationInfo getCRDGenerationInfo() {
        return this.crdInfo;
    }

    protected void logMissingControllerWarning(String controllerName, String knowControllersMessage) {
        log.warn("Cannot find configuration for '{}' controller. {}", (Object)controllerName, (Object)knowControllersMessage);
    }

    public Metrics getMetrics() {
        return this.metrics;
    }
}

