/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.fabric8.kubernetes.client.CustomResource;
import io.javaoperatorsdk.operator.ControllerUtils;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.RetryConfiguration;
import io.quarkiverse.operatorsdk.common.ClassUtils;
import io.quarkus.runtime.annotations.IgnoreProperty;
import io.quarkus.runtime.annotations.RecordableConstructor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class QuarkusControllerConfiguration<R extends CustomResource>
implements ControllerConfiguration<R> {
    private final String associatedControllerClassName;
    private final String name;
    private final String crdName;
    private final String crVersion;
    private String finalizer;
    private final boolean generationAware;
    private Set<String> namespaces;
    private RetryConfiguration retryConfiguration;
    private final String crClass;
    private Class<R> clazz;
    private final boolean registrationDelayed;
    private String labelSelector;
    private ConfigurationService parent;

    @RecordableConstructor
    public QuarkusControllerConfiguration(String associatedControllerClassName, String name, String crdName, String crVersion, boolean generationAware, String crClass, boolean registrationDelayed, Set<String> namespaces, String finalizer, String labelSelector) {
        this.associatedControllerClassName = associatedControllerClassName;
        this.name = name;
        this.crdName = crdName;
        this.crVersion = crVersion;
        this.generationAware = generationAware;
        this.crClass = crClass;
        this.registrationDelayed = registrationDelayed;
        this.retryConfiguration = super.getRetryConfiguration();
        this.setNamespaces(namespaces);
        this.setFinalizer(finalizer);
        this.labelSelector = labelSelector;
    }

    public static Set<String> asSet(String[] namespaces) {
        return namespaces == null || namespaces.length == 0 ? Collections.emptySet() : Set.of(namespaces);
    }

    public String getCrdName() {
        return this.getCRDName();
    }

    public String getCrClass() {
        return this.crClass;
    }

    public boolean isRegistrationDelayed() {
        return this.registrationDelayed;
    }

    @IgnoreProperty
    public Class<R> getCustomResourceClass() {
        if (this.clazz == null) {
            this.clazz = ClassUtils.loadClass((String)this.crClass);
        }
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public String getCRDName() {
        return this.crdName;
    }

    public String getCrVersion() {
        return this.crVersion;
    }

    public String getFinalizer() {
        return this.finalizer;
    }

    public void setFinalizer(String finalizer) {
        this.finalizer = finalizer != null && !finalizer.isBlank() ? finalizer : ControllerUtils.getDefaultFinalizerName((String)this.crdName);
    }

    public boolean isGenerationAware() {
        return this.generationAware;
    }

    public String getAssociatedControllerClassName() {
        return this.associatedControllerClassName;
    }

    public Set<String> getNamespaces() {
        return this.namespaces;
    }

    void setNamespaces(Collection<String> namespaces) {
        this.namespaces = namespaces != null && !namespaces.isEmpty() ? new HashSet<String>(namespaces) : Collections.emptySet();
    }

    public RetryConfiguration getRetryConfiguration() {
        return this.retryConfiguration;
    }

    public ConfigurationService getConfigurationService() {
        return this.parent;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.parent = configurationService;
    }

    void setRetryConfiguration(RetryConfiguration retryConfiguration) {
        this.retryConfiguration = retryConfiguration != null ? retryConfiguration : super.getRetryConfiguration();
    }

    @IgnoreProperty
    public Set<String> getEffectiveNamespaces() {
        return super.getEffectiveNamespaces();
    }

    public String getLabelSelector() {
        return this.labelSelector;
    }

    public void setLabelSelector(String labelSelector) {
        this.labelSelector = labelSelector;
    }
}

