/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.javaoperatorsdk.operator.Operator;
import io.quarkiverse.operatorsdk.runtime.QuarkusConfigurationService;
import io.quarkiverse.operatorsdk.runtime.Version;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import javax.enterprise.event.Observes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppEventListener {
    private static final Logger log = LoggerFactory.getLogger(AppEventListener.class);
    private final Operator operator;
    private final QuarkusConfigurationService configurationService;

    public AppEventListener(Operator operator, QuarkusConfigurationService configurationService) {
        this.operator = operator;
        this.configurationService = configurationService;
    }

    public void onStartup(@Observes StartupEvent event) {
        if (this.configurationService.getVersion() instanceof Version) {
            Version version = (Version)this.configurationService.getVersion();
            String branch = !version.getExtensionBranch().equals("unknown") ? " on branch: " + version.getExtensionBranch() : "";
            log.info("Quarkus Java Operator SDK extension {} (commit: {}{}) built on {}", new Object[]{version.getExtensionVersion(), version.getExtensionCommit(), branch, version.getExtensionBuildTime()});
        }
        if (this.configurationService.shouldStartOperator()) {
            if (!this.operator.getControllers().isEmpty()) {
                this.operator.start();
            } else {
                log.warn("No Reconciler implementation was found so the Operator was not started.");
            }
        } else {
            log.warn("Operator was configured not to start automatically, call the start method to start it.");
        }
    }

    public void onShutdown(@Observes ShutdownEvent event) {
        log.info("Quarkus Java Operator SDK extension is shutting down");
    }
}

