/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import java.io.File;
import java.io.IOException;
import org.jboss.logging.Logger;

public final class CRDUtils {
    private static final YAMLMapper MAPPER = new YAMLMapper();
    private static final Logger LOGGER = Logger.getLogger((String)CRDUtils.class.getName());

    private CRDUtils() {
    }

    public static void applyCRD(KubernetesClient client, CRDGenerationInfo crdInfo, String crdName) {
        try {
            crdInfo.getCRDInfosFor(crdName).forEach((crdVersion, info) -> {
                String filePath = info.getFilePath();
                File crdFile = new File(filePath);
                try {
                    Object crd = MAPPER.readValue(crdFile, CRDUtils.getCRDClassFor(crdVersion));
                    CRDUtils.apply(client, crdVersion, crd);
                    LOGGER.infov("Applied {0} CRD named ''{1}'' from {2}", crdVersion, (Object)crdName, (Object)filePath);
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Couldn't read CRD file at " + filePath + " as a " + crdVersion + " CRD for " + crdName, ex);
                }
            });
        }
        catch (Exception exception) {
            LOGGER.debugv((Throwable)exception, "Couldn't apply ''{0}'' CRD", (Object)crdName);
        }
    }

    private static void apply(KubernetesClient client, String v, Object crd) {
        switch (v) {
            case "v1": {
                client.apiextensions().v1().customResourceDefinitions().createOrReplace((Object[])new io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition[]{(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition)crd});
                break;
            }
            case "v1beta1": {
                client.apiextensions().v1beta1().customResourceDefinitions().createOrReplace((Object[])new CustomResourceDefinition[]{(CustomResourceDefinition)crd});
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown CRD version: " + v);
            }
        }
    }

    private static Class<?> getCRDClassFor(String v) {
        switch (v) {
            case "v1": {
                return io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition.class;
            }
            case "v1beta1": {
                return CustomResourceDefinition.class;
            }
        }
        throw new IllegalArgumentException("Unknown CRD version: " + v);
    }
}

