/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.MissingCRDException;
import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ConfigurationServiceProvider;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import io.quarkiverse.operatorsdk.runtime.CRDUtils;
import io.quarkiverse.operatorsdk.runtime.QuarkusConfigurationService;
import io.quarkiverse.operatorsdk.runtime.Version;
import io.quarkus.arc.DefaultBean;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OperatorProducer {
    private static final Logger log = LoggerFactory.getLogger(OperatorProducer.class);

    @Produces
    @DefaultBean
    @Singleton
    Operator operator(QuarkusConfigurationService configuration, Instance<Reconciler<? extends HasMetadata>> reconcilers) {
        if (configuration.getVersion() instanceof Version) {
            Version version = (Version)configuration.getVersion();
            String branch = !version.getExtensionBranch().equals("unknown") ? " on branch: " + version.getExtensionBranch() : "";
            log.info("Quarkus Java Operator SDK extension {} (commit: {}{}) built on {}", new Object[]{version.getExtensionVersion(), version.getExtensionCommit(), branch, version.getExtensionBuildTime()});
        }
        ConfigurationServiceProvider.reset();
        Operator operator = new Operator(configuration.getClient(), (ConfigurationService)configuration);
        for (Reconciler reconciler : reconcilers) {
            OperatorProducer.applyCRDAndRegister(operator, (Reconciler<? extends HasMetadata>)reconciler, configuration);
        }
        return operator;
    }

    public static void applyCRDAndRegister(Operator operator, Reconciler<? extends HasMetadata> reconciler, QuarkusConfigurationService configuration) {
        String crdName;
        ControllerConfiguration config = configuration.getConfigurationFor((Reconciler)reconciler);
        CRDGenerationInfo crdInfo = configuration.getCRDGenerationInfo();
        if (crdInfo.shouldApplyCRD(crdName = config.getResourceTypeName())) {
            CRDUtils.applyCRD(operator.getKubernetesClient(), crdInfo, crdName);
        }
        try {
            operator.register(reconciler);
        }
        catch (MissingCRDException e) {
            CRDUtils.applyCRD(operator.getKubernetesClient(), crdInfo, crdName);
            operator.register(reconciler);
        }
    }
}

